<?php

namespace App\Http\Controllers\Admin;
use App\Models\Category;
use App\Models\Language;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
class CategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!Gate::allows('category.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $categories = Category::leftJoin('categories_description','categories_description.categories_id', '=', 'categories.id')
		->select('categories.id', 'categories.image',  'categories.icon', 'categories_description.name')
		->where('parent_id', '0')->where('categories_description.language_id', 'en')->get();

        return view('admin.categories.index',compact('categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (!Gate::allows('category.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
        $categories = Category::leftJoin('categories_description','categories_description.categories_id', '=', 'categories.id')
		->select('categories.id', 'categories.image',  'categories.icon', 'categories_description.name')
		->where('categories_description.language_id', 'en')->where('parent_id','=',0)->get();

        return view('admin.categories.create',compact('languages','categories'));
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!Gate::allows('category.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        if(!empty($request->parent_id)){
            $data = $this->validate($request, [
                'parent_id'=>'numeric',
                'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
                'icon' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]); 
        }else{
            $data = $this->validate($request, [
                'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
                'icon' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]);
        }
        $languages = Language::all();
        foreach($languages as $language){
            $data2 = $this->validate($request, [
            'name_'.$language->code => 'required|string|max:100|',
        ]);	
        }
        if($request->hasfile('image')){
            $image = $request->file('image');
            $filename = time() . '-image.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(600, 600)->save(public_path('/images/categories_images/' . $filename));
            $data['image'] = '/images/categories_images/'.$filename;
        }else{
            $data;
            }
        if($request->hasfile('icon')){
            $icon = $request->file('icon');
            $filename = time() . '-icon.' . $icon->getClientOriginalExtension();
            Image::make($icon)->resize(300, 300)->save(public_path('/images/categories_images/' . $filename));
            $data['icon'] = '/images/categories_images/'.$filename;
        }else{
            $data;
            }
            $id = Category::create($data)->id;    
            $myVar = new SettingsController();
            
            $slug_flag = false;	
            //multiple lanugauge with record 
            foreach($languages as $language){

                $name= 'name_'.$language->code;
                
                //slug
                if($slug_flag==false){
                    $slug_flag=true;
                    
                    $slug = $request->$name;
                    $old_slug = $request->$name;
                    $slug_count = 0;
                    do{
                        if($slug_count==0){
                            $currentSlug = $myVar->slugify($old_slug);
                        }else{
                            $currentSlug = $myVar->slugify($old_slug.'-'.$slug_count);
                        }
                        $slug = $currentSlug;
                        $checkSlug = Category::where('slug',$currentSlug)->get();
                        $slug_count++;
                    }
                    while(count($checkSlug)>0);
                    Category::where('id',$id)->update([
                        'slug'	 =>   $slug
                        ]);
                }			
                    
                DB::table('categories_description')->insert([
                        'name'              =>   $request->$name,
                        'categories_id'     =>   $id,
                        'language_id'       =>   $language->code
                    ]);
            }
        
        $message = array('message' => 'Category has been added successfully','type' => 'success');
        return redirect()->back()->with($message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!Gate::allows('category.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $category = Category::find($id);
        //get function from other controller
		
		$languages = Language::all();
		$category = Category::find($id);
		$description = array();		
		foreach($languages as $language){
			
			$categories_description= DB::table('categories_description')->where([
					['language_id', '=', $language->code],
					['categories_id', '=', $id],
				])->get();
				
			if(count($categories_description)>0){								
				$description[$language->code]['name'] = $categories_description[0]->name;
				$description[$language->code]['language_name'] = $language->name;
				$description[$language->code]['language_id'] = $language->code;										
			}else{
				$description[$language->code]['name'] = '';
				$description[$language->code]['language_name'] = $language->name;
				$description[$language->code]['language_id'] = $language->code;	
			}
		}
		$categories = Category::leftJoin('categories_description','categories_description.categories_id', '=', 'categories.id')
		->select('categories.id', 'categories.image',  'categories.icon', 'categories_description.name')
		->where('categories_description.language_id', 'en')->where('parent_id','=',0)->get();
        return view('admin.categories.edit',compact('description','category','categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('ctegory.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        if(!empty($request->parent_id)){
            $data = $this->validate($request, [
                'parent_id'=>'numeric',
                'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
                'icon' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]); 
        }else{
        $data = $this->validate($request, [
            'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            'icon' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        $data['parent_id'] = 0;
        }
        $category = Category::find($id);
        if($request->hasfile('image')){
            File::delete(public_path($category->image));
            $image = $request->file('image');
            $filename = time() . '-image.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(600, 600)->save(public_path('/images/categories_images/' . $filename));
            $data['image'] = '/images/categories_images/'.$filename;
        }else{
            $data;
            }
        if($request->hasfile('icon')){
            File::delete(public_path($category->icon));
            $icon = $request->file('icon');
            $filename = time() . '-icon.' . $icon->getClientOriginalExtension();
            Image::make($icon)->resize(300, 300)->save(public_path('/images/categories_images/' . $filename));
            $data['icon'] = '/images/categories_images/'.$filename;
        }else{
            $data;
            }
            $data['updated_at']=date('Y-m-d H:i:s');
            Category::where('id', $id)->update($data);
            $languages = Language::all();
		foreach($languages as $language){
			$name = 'name_'.$language->code;
			$checkExist = DB::table('categories_description')->where('categories_id','=',$id)->where('language_id','=',$language->code)->get();			
			if(count($checkExist)>0){
				DB::table('categories_description')->where('categories_id','=',$id)->where('language_id','=',$language->code)->update([
					'name'  	    		 =>   $request->$name,
					]);
			}else{
				DB::table('categories_description')->insert([
					'name'  	             =>   $request->$name,
					'language_id'			 =>   $language->code,
					'categories_id'			 =>   $id,
                    'created_at'             =>   date('Y-m-d H:i:s')
					]);
			}
		}
        $message = array('message' => 'Category has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);  
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (!Gate::allows('category.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        $get = Category::whereIn('id',$ids)->get();
        foreach($get as $g){
            File::delete(public_path($g->image));
            File::delete(public_path($g->icon));
        }
        Category::leftjoin('categories_description','categories_description.categories_id','=','categories.id')->whereIn('categories.id', $ids)->delete();
	    Category::leftjoin('categories_description','categories_description.categories_id','=','categories.id')->whereIn('categories.parent_id', $ids)->delete();
        
        return $message = array('message' => 'Delete Failed','type' => 'error');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function subCategory()
    {
        if (!Gate::allows('category.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
       $categories = DB::table('categories as subCategories')
		->leftJoin('categories_description as subCategoryDesc','subCategoryDesc.categories_id', '=', 'subCategories.id')
		->leftJoin('categories as mainCategory','mainCategory.id', '=', 'subCategories.id')
		->leftJoin('categories_description as mainCategoryDesc','mainCategoryDesc.categories_id', '=', 'mainCategory.parent_id')
		->select('subCategories.id as subId','subCategories.image','subCategories.icon','subCategoryDesc.name as subName','mainCategoryDesc.name')
		->where('subCategories.parent_id', '>', '0')
        ->where('subCategoryDesc.language_id', 'en')
        ->where('mainCategoryDesc.language_id', 'en')
        ->orderBy('subId','ASC')->get();

        return view('admin.categories.subCategory',compact('categories'));
    }

    public function categories($language_id){
        $categories =DB::select("select `categories`.`id`, `categories`. `image`, `categories_description`.`name` from `categories` left join `categories_description` on `categories_description`.`categories_id` = `categories`.`id` where `categories_description`.`language_id` = 'en' and (parent_id=0 or categories.id in (select parent_id from categories))");
		$results = array();
		$index = 0;
		foreach($categories  as $category){
			array_push($results,$category);
			
			$subCategories = DB::select("select  `categories`.`id` as `sub_id`, `categories`.`image` as `sub_image`, `categories_description`.`name` as `sub_name`  from `categories` left join `categories_description` on `categories_description`.`categories_id` = `categories`.`id` where `categories_description`.`language_id` = 'en' and `parent_id` =". $category->id." AND categories.id NOT in (select parent_id from categories)");
			$results[$index]->subCategories = $subCategories;
			$index++;
		}	
        return($results);
    	}	
    
}
