<?php

namespace App\Http\Controllers\Admin;
use App\Models\Brand;
use App\Models\Language;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use DB;
class BrandController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!Gate::allows('brand.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $brands = Brand::leftJoin('brands_description','brands_description.brand_id', '=', 'brands.id')
		->select('brands.id', 'brands.image','brands_description.name')
		->where('brands_description.language_id', 'en')->get();

        return view('admin.brands.index',compact('brands'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (!Gate::allows('brand.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
     return view('admin.brands.create',compact('languages'));
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!Gate::allows('category.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
            $data = $this->validate($request, [
                'image' => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]);
        $languages = Language::all();
        foreach($languages as $language){
            $data2 = $this->validate($request, [
            'name_'.$language->code => 'required|string|max:100|',
        ]);	
        }
        if($request->hasfile('image')){
            $image = $request->file('image');
            $filename = time() . '-image.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(600, 600)->save(public_path('/images/brands_images/' . $filename));
            $data['image'] = 'images/brands_images/'.$filename;
        }else{
            $data;
            }
        $data['slug'] = Str::random(15);
        $id = Brand::create($data)->id;    
            
            foreach($languages as $language){
                $name= 'name_'.$language->code;
                DB::table('brands_description')->insert([
                        'name'              =>   $request->$name,
                        'brand_id'          =>   $id,
                        'language_id'       =>   $language->code
                    ]);
            }
        
        $message = array('message' => 'Brand has been created successfully','type' => 'success');
        return redirect()->back()->with($message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!Gate::allows('brand.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
     
		$languages = Language::all();
		$brand = Brand::find($id);
		$description = array();		
		foreach($languages as $language){
			
			$categories_description= DB::table('brands_description')->where([
					['language_id', '=', $language->code],
					['brand_id', '=', $id],
				])->get();
				
			if(count($categories_description)>0){								
				$description[$language->code]['name'] = $categories_description[0]->name;
				$description[$language->code]['language_name'] = $language->name;
				$description[$language->code]['language_id'] = $language->code;										
			}else{
				$description[$language->code]['name'] = '';
				$description[$language->code]['language_name'] = $language->name;
				$description[$language->code]['language_id'] = $language->code;	
			}
		}
	
        return view('admin.brands.edit',compact('description','brand'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('brand.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
      
        $data = $this->validate($request, [
            'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            
        ]);
      
        $brand = Brand::find($id);
        if($request->hasfile('image')){
            File::delete(public_path($brand->image));
            $image = $request->file('image');
            $filename = time() . '-image.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(600, 600)->save(public_path('/images/brands_images/' . $filename));
            $data['image'] = '/images/brands_images/'.$filename;
        }else{
            $data;
            }
     
            $data['updated_at']=date('Y-m-d H:i:s');
            Brand::where('id', $id)->update($data);
            $languages = Language::all();
		foreach($languages as $language){
			$name = 'name_'.$language->code;
			$checkExist = DB::table('brands_description')->where('brand_id','=',$id)->where('language_id','=',$language->code)->get();			
			if(count($checkExist)>0){
				DB::table('brands_description')->where('brand_id','=',$id)->where('language_id','=',$language->code)->update([
					'name'  	    		 =>   $request->$name,
					]);
			}else{
				DB::table('brands_description')->insert([
					'name'  	             =>   $request->$name,
					'language_id'			 =>   $language->code,
					'brand_id'			     =>   $id,
                    'created_at'             =>   date('Y-m-d H:i:s')
					]);
			}
		}
        $message = array('message' => 'Brand has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);  
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (!Gate::allows('brand.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        $get = Brand::whereIn('id',$ids)->get();
        foreach($get as $g){
            File::delete(public_path($g->image));
        }
        Brand::whereIn('id', $ids)->delete();
	    DB::table('brands_description')->whereIn('brand_id', $ids)->delete();
        return $message = array('message' => 'Delete Successed','type' => 'success');
    }
   
    
}
