<?php
namespace App\Http\Controllers\Admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Role;
use App\Models\Order;
use App\Models\Customer;
use App\Models\Product;
use App\Models\Permission;
use DB;
use Auth;
use Artisan;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Hash;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
class AdminController extends Controller
{
    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function dashboard(Request $request){
        
        if (!Gate::allows('dashboard') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $date_filters['start'] = request()->start;
        $date_filters['end'] = request()->end;
        //recently order placed
        $orders = Order::where('customer_id', '!=', '')->orderBy('created_at', 'DESC')->get();
        $index = 0;
        $total_price = 0;
        $cost = 0;
        foreach ($orders as $orders_data) {
            $total_price += $orders_data->order_price;
            $orders_products = DB::table('orders_products')
                ->select('final_price', DB::raw('SUM(final_price) as total_price'), 'product_id')
                ->where('order_id', '=', $orders_data->id)->groupBy('final_price')->get();

            if (count($orders_products) > 0 and !empty($orders_products[0]->total_price)) {
                $orders[$index]->total_price = $orders_products[0]->total_price;
                //$related_product = DB::table('products')->where('products_id',$orders_products[0]->products_id)->get();
                $cost += DB::table('inventory')->where('product_id', $orders_products[0]->product_id)->sum('purchase_price');
            } else {
                $orders[$index]->total_price = 0;
            }
            $orders_status_history = DB::table('orders_status_history')->where('order_id', '=', $orders_data->id)->orderby('orders_status_history.date_added', 'DESC')->limit(1)->get();
            $orders[$index]->order_status = $orders_status_history[0]->status;
            $index++;
        }
        $compeleted_orders = 0;
        $pending_orders = 0;
        foreach ($orders as $orders_data) {

            if ($orders_data->order_status == 'Completed') {
                $compeleted_orders++;
            }
            if ($orders_data->order_status == 'Pending') {
                $pending_orders++;
            }
        }

        $result['orders'] = $orders->chunk(10);
        $result['pending_orders'] = $pending_orders;
        $result['compeleted_orders'] = $compeleted_orders;
        $result['total_orders'] = count($orders);
        $result['inprocess'] = count($orders) - $pending_orders - $compeleted_orders;
        
        //add to cart orders
        $cart = DB::table('customers_basket')->count();
        $result['cart'] = $cart;
        
        //Rencently added products
        $recentProducts = DB::table('products')->leftJoin('products_description', 'products_description.product_id', '=', 'products.id')
        ->select('products.id','products.image','products.price','products_description.name','products_description.short_description')
        ->where('products_description.language_id', '=', 'en')->orderBy('products.id', 'DESC')->paginate(8);
        $result['recentProducts'] = $recentProducts;
        
        //products
        $products = Product::leftJoin('products_description', 'products_description.product_id', '=', 'products.id')
            ->where('products_description.language_id', '=', 'en')->orderBy('products.id', 'DESC')->get();

        //low products & out of stock
        $lowLimit = 0;
        $outOfStock = 0;
        $total_money = 0;
        $products_ids = array();
        $data = array();
        foreach ($products as $products_data) {
            //$total_money += $products_data->products_price;
            $currentStocks = DB::table('inventory')->where('product_id', $products_data->id)->get();
            $total_money += DB::table('inventory')->where('product_id', $products_data->id)->sum('purchase_price');
            
            if (count($currentStocks) > 0) {
                if ($products_data->products_type != 'Variable') {
                    $c_stock_in = DB::table('inventory')->where('product_id', $products_data->id)->where('stock_type', 'in')->sum('stock');
                    $c_stock_out = DB::table('inventory')->where('product_id', $products_data->id)->where('stock_type', 'out')->sum('stock');

                    if (($c_stock_in - $c_stock_out) == 0) {
                        if (!in_array($products_data->id, $products_ids)) {
                            $products_ids[] = $products_data->id;
                            array_push($data, $products_data);
                            $outOfStock++;
                        }
                    }
                }

            } else {
                $outOfStock++;
            }
        }
        //products profit
        if ($total_money == 0) {
            $profit = 0;
        } else {
            $profit = abs($total_price - $cost);
        }
        $result['profit'] = $profit;
        //$result['total_money'] = $total_money;
        $result['total_money'] = $cost;
        $result['lowLimit'] = $lowLimit;
        $result['outOfStock'] = $outOfStock;
        $result['totalProducts'] = count($products);
        
        $customers = DB::table('customers')->select('id','first_name','last_name','image','created_at')->orderBy('created_at', 'DESC')->get();
        $result['customers'] = $customers;
        $result['totalCustomers'] = count($customers);
        
        return view('admin.dashboard',compact('date_filters','result'));
    }
   
    public function index(){
       if (!Gate::allows('user.index') && !Gate::allows('all')) {
         $message = array('message' => '403, You are not allowed to access this page !','type' => 'error');
         return redirect('admin/dashboard')->with($message);
       }
            $users =User::with('roles')->get();//geting all users with their assinged roles
            return view('admin.users.index')->with('users', $users); 
    }

    public function create(){
        if (!Gate::allows('user.create') && !Gate::allows('all')) {
                $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
                return redirect()->back()->with($message);
            }
        $roles = Role::all();
        $permissions = Permission::all();
        return view('admin.users.create')->with(['roles'=>$roles,'permissions'=>$permissions]);
    }

    public function store(Request $request){
      if (!Gate::allows('user.create') && !Gate::allows('all')) {
        $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
        return redirect('admin/dashboard')->with($message);
        }
        $data = $this->validate($request, [
            'first_name'      =>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
            'last_name'      =>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
            'email'     =>  'required|string|email|max:50|unique:users',
            'password'  =>  'required|string|min:6|confirmed',
            'gender'    =>  'in:Male,Female',
            'dob'       =>  'date|date_format:Y-m-d',
            'image'     => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            'phone'     =>'string|max:15'
          ]);
          $data['phone'] =$request->phone;
        if($request->hasfile('image')){
            $image = $request->file('image');
            $filename = time() . '.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(100, 100)->save(public_path('/images/user_profile/' . $filename));
            $data['image'] = '/images/user_profile/'.$filename;
        }else{
            $oldPath = public_path('/images/default_images/default_customer.png');
            $fileExtension = \File::extension($oldPath);
            $newName = time().'.'.$fileExtension;
            $newPathWithName =public_path('/images/user_profile/' .$newName);
            File::copy($oldPath , $newPathWithName);
            $data['image'] = '/images/user_profile/'.$newName;
        } 
        $data['password'] = Hash::make($request->password);
        
        if($request->vendor == 'Yes'){
            $data['user_type'] = 'Vendor';  
        }
        
        $user=User::create($data);
            if(!empty($request->role_id)){
                foreach($request->role_id as $id){
                    DB::table('role_user')->Insert(['role_id'=>$id,'user_id'=>$user->id]);
                }
            }
            
        if($user->id){
        $message = array('message' => 'Admin user has been added successfully !','type' => 'success');
        return redirect()->back()->with($message);
        }else{
        $message = array('message' => 'Some thing went wrong try again !','type' => 'warning');
        return redirect()->back()->with($message);  
        }
    }
   
    public function show($id){
        //
    }
   
    public function edit($id){
        if (!Gate::allows('user.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $user = User::find($id);
        $user_roles = DB::table('role_user')->where('user_id',$id)->pluck('role_id');
        $user['user_roles']=$user_roles;
     
        $roles = DB::table('roles')->get();
        return view('admin.users.edit')->with(['user'=>$user,'roles'=>$roles]);     
    }
   
    public function update(Request $request, $id){
        
       if (!Gate::allows('user.edit') && !Gate::allows('all')) {
        $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
        return redirect('admin/dashboard')->with($message);
        }
        $user = User::find($id);
        $data = $this->validate($request, [
            'first_name'      =>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
            'last_name'      =>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
            'email'     => 'required|string|email|max:50|unique:users,email,'.$id,
            'gender'    => 'in:Male,Female',
            'dob'       => 'date|date_format:Y-m-d',
            'image'     => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            'phone'     => 'string|max:15'
          ]);
          $data['phone'] = $request->phone;
          $data['updated_at']=date('Y-m-d H:i:s');
        if($request->hasfile('image')){
            File::delete(public_path($user->image));
            $image = $request->file('image');
            $filename = time() . '.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(200, 200)->save(public_path('/images/user_profile/' . $filename));
            $data['image'] = '/images/user_profile/'.$filename;
        }else{
            $data;
            } 
            User::find($id)->update($data);
            if($request->change_password=="yes"){
                $this->validate($request, [
                    'password' => 'required|string|min:6|confirmed', 
                  ]);
                  User::find($id)->update([
                    'password' => Hash::make($request->password),
                ]);
            }
            if($id!=1){
            
            if(!empty($request->role_id)){
            DB::table('role_user')->where('user_id',$id)->delete();
            foreach($request->role_id as $role){
                DB::table('role_user')->Insert(['role_id'=>$role,'user_id'=>$id]);
                }
            }
        }
         
            $message = array('message' => 'Admin has been updated successfully','type' => 'success');
            return redirect()->back()->with($message);
    }
    
    public function destroy(Request $request, $id){
  
      if (!Gate::allows('user.destroy') && !Gate::allows('all')) {
        $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
        return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        $ids = array_diff($ids, ["1"]);
        $get = User::whereIn('id',$ids)->get();
        foreach($get as $g){
            File::delete(base_path($g->image));
        }
        if (User::destroy(array_filter($ids))) {
            DB::table('role_user')->whereIn('user_id',$ids)->delete();
            DB::table('user_permissions')->whereIn('user_id',$ids)->delete();
            $message = array('message' => 'Delete Succeeded','type' => 'success');
        }else{
            $message = array('message' => 'Delete Failed','type' => 'error');
        }
        return $message;
    }
    
    public function adminStatus(Request $request){
        if (!Gate::allows('user.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this action !','type' => 'error');
            return $message;
        }
        $user =User::find($request->id);
        if($user->status =='Active' && $user->user_type != 'Administrator'){
            $user->update(['status' => 'InActive']);	
        }elseif($user->status =='InActive' && $user->user_type != 'Administrator'){
            $user->update(['status' => 'Active']);	
        }
        $message = array('message' => 'Admin Status has been updated successfully','type' => 'success');
        return $message;
       
    }
    
    public function Profile(){
        if (!Gate::allows('user.profile') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        return view('admin.users.profile'); 
    }
    
    public function updateProfile(Request $request, $id){
        
       if (!Gate::allows('user.profile.edit') && !Gate::allows('all')) {
        $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
        return redirect('admin/dashboard')->with($message);
        }
        $user = User::find($id);
        $data = $this->validate($request, [
            'first_name'      =>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
            'last_name'      =>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
            'email'     => 'required|string|email|max:50|unique:users,email,'.$id,
            'gender'    => 'in:Male,Female',
            'dob'       => 'date|date_format:Y-m-d',
            'image'     => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            'phone'     => 'string|max:15'
          ]);
          $data['phone'] = $request->phone;
          $data['updated_at']=date('Y-m-d H:i:s');
        if($request->hasfile('image')){
            File::delete(public_path($user->image));
            $image = $request->file('image');
            $filename = time() . '.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(200, 200)->save(public_path('/images/user_profile/' . $filename));
            $data['image'] = '/images/user_profile/'.$filename;
        }else{
            $data;
            } 
            User::find($id)->update($data);
            if($request->change_password=="yes"){
                $this->validate($request, [
                    'password' => 'required|string|min:6|confirmed', 
                  ]);
                  User::find($id)->update([
                    'password' => Hash::make($request->password),
                ]);
            }
            if($id!=1){
            
            if(!empty($request->role_id)){
            DB::table('role_user')->where('user_id',$id)->delete();
            foreach($request->role_id as $role){
                DB::table('role_user')->Insert(['role_id'=>$role,'user_id'=>$id]);
                }
            }
        }
         
            $message = array('message' => 'Admin has been updated successfully','type' => 'success');
            return redirect()->back()->with($message);
    }
    
    //public function productSaleReport($reportBase){
    public function productSaleReport(Request $request){

        $saleData = array();
        $date = time();
        $reportBase = $request->reportBase;
        //$reportBase = 'last_year';

        if ($reportBase == 'this_month') {

            $dateLimit = date('d', $date);

            //for current month
            for ($j = 1; $j <= $dateLimit; $j++) {

                $dateFrom = date('Y-m-' . $j . ' 00:00:00', time());
                $dateTo = date('Y-m-' . $j . ' 23:59:59', time());
                
                $totalSale = DB::table('inventory')
                    ->whereBetween('created_at', [$dateFrom, $dateTo])
                    ->where('stock_type', 'out')
                    ->count();          
                
                $producQuantity = DB::table('inventory')
                    ->whereBetween('created_at', [$dateFrom, $dateTo])
                    ->where('stock_type', 'in')
                    ->count(); 

                $saleData[$j - 1]['date'] = date('d M', strtotime($dateFrom));
                $saleData[$j - 1]['totalSale'] = $totalSale;
                $saleData[$j - 1]['productQuantity'] = $producQuantity;
            }

        } else if ($reportBase == 'last_month') {
            $datePrevStart = date("Y-n-j", strtotime("first day of previous month"));
            $datePrevEnd = date("Y-n-j", strtotime("last day of previous month"));

            $dateLimit = date('d', strtotime($datePrevEnd));

            //for last month
            for ($j = 1; $j <= $dateLimit; $j++) {

                $dateFrom = date('Y-m-' . $j . ' 00:00:00', strtotime($datePrevStart));
                $dateTo = date('Y-m-' . $j . ' 23:59:59', strtotime($datePrevEnd));

                //sold products
                $totalSale = DB::table('inventory')
                    ->whereBetween('created_at', [$dateFrom, $dateTo])
                    ->where('stock_type', 'out')
                    ->count();  

                //purchase products
                $producQuantity = DB::table('inventory')
                    ->whereBetween('created_at', [$dateFrom, $dateTo])
                    ->where('stock_type', 'in')
                    ->count(); 

                $saleData[$j - 1]['date'] = date('d M', strtotime($dateFrom));
                $saleData[$j - 1]['totalSale'] = $totalSale;
                $saleData[$j - 1]['productQuantity'] = $producQuantity;
            }

        } else if ($reportBase == 'last_year') {

            $dateLimit = date("Y", strtotime("-1 year"));

            $datePrevStart = date("Y-n-j", strtotime("first day of previous month"));
            $datePrevEnd = date("Y-n-j", strtotime("last day of previous month"));

            //for last year
            for ($j = 1; $j <= 12; $j++) {
                $dateFrom = date($dateLimit . '-' . $j . '-1 00:00:00', strtotime($datePrevStart));
                $dateTo = date($dateLimit . '-' . $j . '-31 23:59:59', strtotime($datePrevEnd));

                //sold products
                $totalSale = DB::table('inventory')
                    ->whereBetween('created_at', [$dateFrom, $dateTo])
                    ->where('stock_type', 'out')
                    ->count();  

                //purchase products
                $producQuantity = DB::table('inventory')
                    ->whereBetween('created_at', [$dateFrom, $dateTo])
                    ->where('stock_type', 'in')
                    ->count(); 

                $saleData[$j - 1]['date'] = date('M Y', strtotime($dateFrom));
                $saleData[$j - 1]['totalSale'] = $totalSale;
                $saleData[$j - 1]['productQuantity'] = $producQuantity;
            }
        } else {
            $reportBase = str_replace('dateRange', '', $reportBase);
            $reportBase = str_replace('=', '', $reportBase);
            $reportBase = str_replace('-', '/', $reportBase);

            $dateFrom = substr($reportBase, 0, 10);
            $dateTo = substr($reportBase, 11, 21);

            $diff = abs(strtotime($dateFrom) - strtotime($dateTo));
            $years = floor($diff / (365 * 60 * 60 * 24));
            $months = floor(($diff - $years * 365 * 60 * 60 * 24) / (30 * 60 * 60 * 24));
            $days = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24) / (60 * 60 * 24));
            $totalDays = floor($diff / (60 * 60 * 24));
            //    print ('day: '.$days.' months: '.$months.' years: '.$years.'<br>');
            $totalMonths = floor($diff / 60 / 60 / 24 / 30);

            if ($diff == 0 && $days == 0 && $years == 0 && $months == 0) {
                //print 'asdsad';

                $dateLimitFrom = date('G', strtotime($dateFrom));
                $dateLimitTo = date('d', strtotime($dateTo));
                $selecteddate = date('m', strtotime($dateFrom));
                $selecteddate = date('Y', strtotime($dateFrom));

                //for current month
                for ($j = 1; $j <= 24; $j++) {

                    $dateFrom = date('Y-m-d' . ' ' . $j . ':00:00', strtotime($dateFrom));
                    $dateTo = date('Y-m-d' . ' ' . $j . ':59:59', strtotime($dateFrom));

                    //sold products
                    $totalSale = DB::table('inventory')
                        ->whereBetween('created_at', [$dateFrom, $dateTo])
                        ->where('stock_type', 'out')
                        ->count();  

                    //purchase products
                    $producQuantity = DB::table('inventory')
                        ->whereBetween('created_at', [$dateFrom, $dateTo])
                        ->where('stock_type', 'in')
                        ->count(); 

                    $saleData[$j - 1]['date'] = date('h a', strtotime($dateFrom));
                    $saleData[$j - 1]['totalSale'] = $totalSale;
                    $saleData[$j - 1]['productQuantity'] = $producQuantity;
                    //print $dateLimitFrom.'<br>';

                }

            } else if ($days > 1 && $years == 0 && $months == 0) {

                //print 'daily';

                $dateLimitFrom = date('d', strtotime($dateFrom));
                $dateLimitTo = date('d', strtotime($dateTo));
                $selectedMonth = date('m', strtotime($dateFrom));
                $selectedYear = date('Y', strtotime($dateFrom));
                //print $selectedYear;

                //for current month
                for ($j = 1; $j <= $totalDays; $j++) {

                    //print 'dateFrom: '.date('Y-m-'.$j.' 00:00:00', time()).'dateTo: '.date('Y-m-'.$j.' 23:59:59', time());
                    //print '<br>';

                    $dateFrom = date($selectedYear . '-' . $selectedMonth . '-' . $dateLimitFrom, strtotime($dateFrom));
                    //$dateTo     = date('Y-m-'.$j.' 23:59:59', time());
                    //print $dateFrom .'<br>';
                    $lastday = date('t', strtotime($dateFrom));
                    //print 'lastday: '.$lastday .' <br>';

                    //sold products
                    $totalSale = DB::table('inventory')
                     ->whereBetween('created_at', [$dateFrom, $dateTo])
                     ->where('stock_type', 'out')
                     ->count();  

                    //purchase products
                    $producQuantity = DB::table('inventory')
                        ->whereBetween('created_at', [$dateFrom, $dateTo])
                        ->where('stock_type', 'in')
                        ->count(); 

                    $saleData[$j - 1]['date'] = date('d M', strtotime($dateFrom));
                    $saleData[$j - 1]['totalSale'] = $totalSale;                    
                    $saleData[$j - 1]['productQuantity'] = $producQuantity;
                    //print $dateLimitFrom.'<br>';
                    if ($dateLimitFrom == $lastday) {
                        $dateLimitFrom = '1';
                        $selectedMonth++;

                    } else {
                        $dateLimitFrom++;
                    }

                    if ($selectedMonth > 12) {
                        $selectedMonth = '1';
                        $selectedYear++;
                    }
                }
            } else if ($months >= 1 && $years == 0) {

                //for check if date range enter into another month
                if ($days > 0) {
                    $months += 1;
                }

                $dateLimitFrom = date('d', strtotime($dateFrom));
                $dateLimitTo = date('d', strtotime($dateTo));
                $selectedMonth = date('m', strtotime($dateFrom));
                $selectedYear = date('Y', strtotime($dateFrom));
                //print $selectedMonth;

                $i = 0;
                //for current month
                for ($j = 1; $j <= $months; $j++) {
                    if ($j == $months) {
                        $lastday = $dateLimitTo;
                    } else {
                        $lastday = date('t', strtotime($dateLimitFrom . '-' . $selectedMonth . '-' . $selectedYear));
                    }

                    $dateFrom = date($selectedYear . '-' . $selectedMonth . '-' . $dateLimitFrom, strtotime($dateFrom));
                    $dateTo = date($selectedYear . '-' . $selectedMonth . '-' . $lastday, strtotime($dateTo));
                    //print $dateFrom.' '.$dateTo.'<br>';

                    //sold products
                    $totalSale = DB::table('inventory')
                     ->whereBetween('created_at', [$dateFrom, $dateTo])
                     ->where('stock_type', 'out')
                     ->count();  

                    //purchase products
                    $producQuantity = DB::table('inventory')
                        ->whereBetween('created_at', [$dateFrom, $dateTo])
                        ->where('stock_type', 'in')
                        ->count(); 

                    $saleData[$i]['date'] = date('M Y', strtotime($dateFrom));
                    $saleData[$i]['totalSale'] = $totalSale;
                    $saleData[$i]['productQuantity'] = $producQuantity;

                    $selectedMonth++;
                    if ($selectedMonth > 12) {
                        $selectedMonth = '1';
                        $selectedYear++;
                    }
                    $i++;
                }

            } else if ($years >= 1) {

                //print $years.'sadsa';
                if ($months > 0) {
                    $years += 1;
                }

                //print $years;

                $dateLimitFrom = date('d', strtotime($dateFrom));
                $dateLimitTo = date('d', strtotime($dateTo));

                $selectedMonthFrom = date('m', strtotime($dateFrom));
                $selectedMonthTo = date('m', strtotime($dateTo));

                $selectedYearFrom = date('Y', strtotime($dateFrom));
                $selectedYearTo = date('Y', strtotime($dateTo));
                //print $selectedYearFrom.' '.$selectedYearTo;

                $i = 0;
                //for current month
                for ($j = $selectedYearFrom; $j <= $selectedYearTo; $j++) {

                    if ($j == $selectedYearTo) {
                        $selectedYearTo = $selectedYearTo;
                        $dateLimitTo = $dateLimitTo;
                    } else {
                        $selectedMonthTo = 12;
                        $dateLimitTo = 31;
                    }

                    if ($selectedYearFrom == $j) {
                        $selectedMonthFrom = $selectedMonthFrom;
                    } else {
                        $selectedMonthFrom = 1;
                    }

                    //    print $j.'-'.$selectedMonthFrom.'-'.$dateLimitFrom.'<br>';
                    //print $j.'-'.$selectedMonthTo.'-'.$dateLimitTo.'<br>';
                    //$lastday  =  date('t',strtotime($dateLimitFrom.'-'.$selectedMonth.'-'.$selectedYear));

                    $dateFrom = date($j . '-' . $selectedMonthFrom . '-' . $dateLimitFrom, strtotime($dateFrom));
                    $dateTo = date($j . '-' . $selectedMonthTo . '-' . $dateLimitTo, strtotime($dateTo));
                    //    print $dateFrom.' '.$dateTo.'<br>';
                    //print $dateFrom.'<br>';

                    //sold products
                    $totalSale = DB::table('inventory')
                     ->whereBetween('created_at', [$dateFrom, $dateTo])
                     ->where('stock_type', 'out')
                     ->count();  

                    //purchase products
                    $producQuantity = DB::table('inventory')
                        ->whereBetween('created_at', [$dateFrom, $dateTo])
                        ->where('stock_type', 'in')
                        ->count(); 

                    $saleData[$i]['date'] = date('Y', strtotime($dateFrom));
                    $saleData[$i]['totalSale'] = $totalSale;
                    $saleData[$i]['productQuantity'] = $producQuantity;
                    $i++;
                }

            }
        }
        return $saleData;
    }
}