@extends('admin.layout')
@section('content')
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1> {{ trans('labels.Customers') }} <small>{{ trans('labels.ListingAllCustomers') }}...</small> </h1>
    <ol class="breadcrumb">
      <li><a href="{{ URL::to('admin/dashboard/this_month')}}"><i class="fa fa-dashboard"></i> {{ trans('labels.breadcrumb_dashboard') }}</a></li>
      <li class="active">{{ trans('labels.Customers') }}</li>
    </ol>
  </section>
  
  <!-- Main content -->
  <section class="content"> 
    <!-- Info boxes --> 
    
    <!-- /.row -->

    <div class="row">
      <div class="col-md-12">
        <div class="box">
         
          
          <!-- /.box-header -->
          <div class="box-body">
            <div class="row">
              <div class="col-xs-12">
              		
				  @if (count($errors) > 0)
					  @if($errors->any())
						<div class="alert alert-success alert-dismissible" role="alert">
						  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						  {{$errors->first()}}
						</div>
					  @endif
				  @endif
              </div>
              
            </div>
            <div class="row">
              <div class="col-xs-12">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                    <tr>
                      <th>{{ trans('labels.ID') }}</th>
                      
                      <th>{{ trans('labels.Elevater Code') }}</th>
                      <th>{{ trans('labels.CustomerInfo') }}</th>
                      <th>{{ trans('labels.Address') }}</th>
                      <th>{{ trans('labels.Floor No') }}</th>
                      <th>{{ trans('labels.Doors') }}</th>
                      
                      <th>{{ trans('labels.Elevater Type') }}</th>
                      
                     
                      <th>{{ trans('labels.Status') }}</th>
                      <th>{{ trans('labels.Action') }}</th>
                    </tr>
                  </thead>
                  <tbody>
                   @if (count($instalations['result']) > 0)
						@foreach ($instalations['result']  as $key=>$listinginstalations)
							<tr>
								<td>{{ $listinginstalations->installation_id }}</td>
							
								<td>{{ $listinginstalations->elevator_code }}</td>
								<td> <strong>{{ trans('labels.Name') }}: </strong> {{ $listinginstalations->customers_firstname }} 
									<strong>{{ trans('labels.Phone') }}: </strong> {{ $listinginstalations->customers_telephone }}
								</td>
								<td>{{ $listinginstalations->address }}</td>
								<td>{{ $listinginstalations->floor_no }}</td>
								<td>{{ $listinginstalations->door_no }}</td>
								
								<td>{{ $listinginstalations->elevator_type }}</td>
								
								<td>
								    
								    @if($listinginstalations->status==0)
								    <span class="label label-warning">
										Not completed
									</span>	
									
								@elseif($listinginstalations->status==1)
								
									<span class="label label-success">
										Completed

									</span>
									
					@if($listinginstalations->sstatus==1)				
                  <a href="addSchedual?installation={{ $listinginstalations->installation_id }}&type=4"><button class="form-control"> Mechanical</button></a>
                  
                  @elseif($listinginstalations->sstatus==4)	
                   <a href="addSchedual?installation={{ $listinginstalations->installation_id }}&type=5"><button class="form-control"> Electrical</button></a>
                  @endif
                
									
									
								@endif
								</td>
								
								
								<td>
									<a data-toggle="tooltip" data-placement="bottom" title="{{ trans('labels.Edit') }}" href="editInstalation/{{ $listinginstalations->id }}" class="badge bg-light-blue"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a> 

									<a data-toggle="tooltip" data-placement="bottom" title="{{ trans('labels.Delete') }}" id="deleteCustomerFrom" customers_id="{{ $listinginstalations->id }}" class="badge bg-red"><i class="fa fa-trash" aria-hidden="true"></i></a>
								</td>
							</tr>
						@endforeach
                    @else
                    	<tr>
							<td colspan="4">{{ trans('labels.NoRecordFound') }}</td>							
						</tr>
                    @endif
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <!-- /.box-body --> 
        </div>
        <!-- /.box --> 
      </div>
      <!-- /.col --> 
    </div>
    
    <!-- /.row --> 
   
    <!-- deleteCustomerModal -->
	<div class="modal fade" id="deleteCustomerModal" tabindex="-1" role="dialog" aria-labelledby="deleteCustomerModalLabel">
	  <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title" id="deleteCustomerModalLabel">{{ trans('labels.DeleteCustomer') }}</h4>
		  </div>
		  {!! Form::open(array('url' =>'admin/deleteInstalation', 'name'=>'deleteCustomer', 'id'=>'deleteCustomer', 'method'=>'post', 'class' => 'form-horizontal', 'enctype'=>'multipart/form-data')) !!}
				  {!! Form::hidden('action',  'delete', array('class'=>'form-control')) !!}
				  {!! Form::hidden('id',  '', array('class'=>'form-control', 'id'=>'customers_id')) !!}
		  <div class="modal-body">						
			  <p>{{ trans('labels.DeleteCustomerText') }}</p>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-default" data-dismiss="modal">{{ trans('labels.Close') }}</button>
			<button type="submit" class="btn btn-primary">{{ trans('labels.DeleteCustomer') }}</button>
		  </div>
		  {!! Form::close() !!}
		</div>
	  </div>
	</div>
    
    <div class="modal fade" id="notificationModal" tabindex="-1" role="dialog" aria-labelledby="notificationModalLabel">
	  <div class="modal-dialog" role="document">
		<div class="modal-content notificationContent">

		</div>
	  </div>
	</div>

    <!-- Main row --> 
    
    <!-- /.row --> 
  </section>
  <!-- /.content --> 
</div>
@endsection 