@extends('admin.layout')
@section('content')
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1> {{ trans('labels.Schedules') }} <small>{{ trans('labels.ListingAllSchedules') }}...</small> </h1>
    <ol class="breadcrumb">
      <li><a href="{{ URL::to('admin/dashboard/this_month')}}"><i class="fa fa-dashboard"></i> {{ trans('labels.breadcrumb_dashboard') }}</a></li>
      <li class="active">{{ trans('labels.Schedules') }}</li>
    </ol>
  </section>
  <style>
  .blink_me {
  animation: blinker 2s linear infinite;
}

@keyframes blinker {
  50% {
    opacity: 0;
  }
}
  </style>
  <!-- Main content -->
  <section class="content"> 
    <!-- Info boxes --> 
    
    <!-- /.row -->

    <div class="row">
      <div class="col-md-12">
        <div class="box">
          <div class="box-header">
            <h3 class="box-title">{{ trans('labels.ListingAllSchedules') }} </h3>
            <div class="box-tools pull-right">
            	<a href="addSchedual" type="button" class="btn btn-block btn-primary">{{ trans('labels.AddNewSchedules') }}</a>
            </div>
          </div>
          
          <!-- /.box-header -->
          <div class="box-body">
            <div class="row">
              <div class="col-xs-12">
              		
				  @if (count($errors) > 0)
					  @if($errors->any())
						<div class="alert alert-success alert-dismissible" role="alert">
						  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						  {{$errors->first()}}
						</div>
					  @endif
				  @endif
              </div>
              
            </div>
            <div class="row">
              <div class="col-xs-12">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                    <tr>
                        <th>{{ trans('labels.Scheduled At') }}</th>
                      <!--<th>{{ trans('labels.ID') }}</th>-->
                      <th>{{ trans('labels.Installation No') }}</th>
                      <th>{{ trans('labels.CustomerInfo') }}</th>
                      <th>{{ trans('labels.Tecnician') }}</th>
                      
                      <th>Completed at</th>
                      <th>Questions</th>
                      <th>Signature</th>
                      <th>{{ trans('labels.Status') }}</th>
                      <th>{{ trans('labels.Action') }}</th>
                    </tr>
                  </thead>
                  <tbody>
                   @if (count($instalations['result']) > 0)
						@foreach ($instalations['result']  as $key=>$listinginstalations)
							<tr>
							    	@php($date_facturation = \Carbon\Carbon::parse(strtotime($listinginstalations->scheduled_at)))
                                    @if ((strtotime("now") - strtotime($listinginstalations->scheduled_at) > 3600 )  && $listinginstalations->status == 0)
                                        <td class="blink_me">
                                    @else
                                        <td>
                                    @endif
                                            {{ $date_facturation }}
                                        </td>
								
								<td>{{ $listinginstalations->elevator_code }}</td>
								<td><strong>{{ trans('labels.Name') }}: </strong> {{ $listinginstalations->customers_firstname }} {{ $listinginstalations->customers_lastname }} <br>
								    <strong>{{ trans('labels.Phone') }}: </strong> {{ $listinginstalations->customers_telephone }}
								</td>
								<td>{{ $listinginstalations->first_name }}</td>
							
								
							
						 
								<td>{{ $listinginstalations->updated_at}}</td>
								
							
							<td>
							    @foreach($listinginstalations->answers as $ans)
							    {{$ans->name}} : {{$ans->answer}}<br>
							    @endforeach
							    
							    </td>
								<td>
								    <img src={{"/resources/assets/images/user_profile/pic_".$listinginstalations->sid.".jpg"}} width="100px">
								    
								</td>
								<td>
								
								    
								      
							 @if($listinginstalations->status==1)
									<span class="label label-success">
									    
									Completed
									</span>
								@elseif($listinginstalations->status==0)
								<span class="label label-warning">
									Not Complete
									</span>	
								@endif
								</td>
								
								
								<td>
									<a data-toggle="tooltip" data-placement="bottom" title="{{ trans('labels.Edit') }}" href="editSchedual/{{ $listinginstalations->id }}" class="badge bg-light-blue"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a> 

									<a data-toggle="tooltip" data-placement="bottom" title="{{ trans('labels.Delete') }}" id="deleteCustomerFrom" customers_id="{{ $listinginstalations->id }}" class="badge bg-red"><i class="fa fa-trash" aria-hidden="true"></i></a>
								</td>
							</tr>
						@endforeach
                    @else
                    	<tr>
							<td colspan="4">{{ trans('labels.NoRecordFound') }}</td>							
						</tr>
                    @endif
                  </tbody>
                </table>
                @if (count($instalations) > 0)
					<div class="col-xs-12 text-right">
						{{$instalations['result']->links()}}
					</div>
                 @endif
              </div>
            </div>
          </div>
          <!-- /.box-body --> 
        </div>
        <!-- /.box --> 
      </div>
      <!-- /.col --> 
    </div>
    
    <!-- /.row --> 
   
    <!-- deleteCustomerModal -->
	<div class="modal fade" id="deleteCustomerModal" tabindex="-1" role="dialog" aria-labelledby="deleteCustomerModalLabel">
	  <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title" id="deleteCustomerModalLabel">{{ trans('labels.DeleteCustomer') }}</h4>
		  </div>
		  {!! Form::open(array('url' =>'admin/deleteSchedual', 'name'=>'deleteCustomer', 'id'=>'deleteCustomer', 'method'=>'post', 'class' => 'form-horizontal', 'enctype'=>'multipart/form-data')) !!}
				  {!! Form::hidden('action',  'delete', array('class'=>'form-control')) !!}
				  {!! Form::hidden('id',  '', array('class'=>'form-control', 'id'=>'customers_id')) !!}
		  <div class="modal-body">						
			  <p>{{ trans('labels.DeleteCustomerText') }}</p>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-default" data-dismiss="modal">{{ trans('labels.Close') }}</button>
			<button type="submit" class="btn btn-primary">{{ trans('labels.DeleteCustomer') }}</button>
		  </div>
		  {!! Form::close() !!}
		</div>
	  </div>
	</div>
    
    <div class="modal fade" id="notificationModal" tabindex="-1" role="dialog" aria-labelledby="notificationModalLabel">
	  <div class="modal-dialog" role="document">
		<div class="modal-content notificationContent">

		</div>
	  </div>
	</div>

    <!-- Main row --> 
    
    <!-- /.row --> 
  </section>
  <!-- /.content --> 
</div>
@endsection 