@extends('admin.layout')
@section('content')
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1> {{ trans('labels.EditVendor') }} <small>{{ trans('labels.EditVendor') }}...</small> </h1>
    <ol class="breadcrumb">
       <li><a href="{{ URL::to('admin/dashboard/this_month') }}"><i class="fa fa-dashboard"></i> {{ trans('labels.breadcrumb_dashboard') }}</a></li>
      <li><a href="{{ URL::to('admin/listingvendor')}}"><i class="fa fa-bars"></i> {{ trans('labels.ListingAllVendors') }}</a></li>
      <li class="active">{{ trans('labels.EditVendor') }}</li>
    </ol>
  </section>
  
  <!-- Main content -->
  <section class="content"> 
    <!-- Info boxes --> 
    
    <!-- /.row -->

    <div class="row">
      <div class="col-md-12">
        <div class="box">
          <div class="box-header">
            <h3 class="box-title">{{ trans('labels.EditVendor') }} </h3>
          </div>
          
          <!-- /.box-header -->
          <div class="box-body">
            <div class="row">
              <div class="col-xs-12">
              		<div class="box box-info">
                    <br>                       
                        @if (count($errors) > 0)
                              @if($errors->any())
                                <div class="alert alert-success alert-dismissible" role="alert">
                                  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                  {{$errors->first()}}
                                </div>
                              @endif
                          @endif
                        <!--<div class="box-header with-border">
                          <h3 class="box-title">Edit category</h3>
                        </div>-->
                        <!-- /.box-header -->
                        <!-- form start -->                        
                        <div class="box-body">
                          <div class="row">
                            <div class="col-md-12">
                             {!! Form::open(array('url' =>'admin/updatevendor', 'method'=>'post', 'class' => 'form-horizontal', 'enctype'=>'multipart/form-data')) !!}
                                 {!! Form::hidden('id',  $result['vendor'][0]->myid , array('class'=>'form-control', 'id'=>'id')) !!}
                                  {!! Form::hidden('image',  $result['vendor'][0]->image, array('id'=>'image')) !!}
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Name') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                  {!! Form::text('first_name', $result['vendor'][0]->first_name, array('class'=>'form-control','id'=>'first_name')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.VendorSalonNametext') }}</span>
                                  </div>
                                </div>
                                
                                 <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Name in Arabic') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                  {!! Form::text('arabic_name', $result['vendor'][0]->arabic_name, array('class'=>'form-control','id'=>'arabic_name')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.Vendorsalontexta') }}</span>
                                  </div>
                                </div>
                                
                                
                            
                                
                                  
                                
                               <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Address') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('address', $result['vendor'][0]->address, array('class'=>'form-control','id'=>'address')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.VendorAddresstext') }}</span>
                                  </div>
                                </div>
                                
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.VendorPhone') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('phone', $result['vendor'][0]->phone, array('class'=>'form-control','id'=>'phone')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.VendorPhonetext') }}</span>
                                  </div>
                                </div>
                                
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Image') }}</label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::file('image', array('id'=>'image')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.ImageBannerText') }}</span>
                                    <br>
                			
                                    <img src="{{asset('').$result['vendor'][0]->image}}" alt="" width=" 100px">
                                  </div>
                                </div>
                                 <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.TechnicianType') }}</label>
                                  <div class="col-sm-10 col-md-4">
                                      <select class="form-control" name="type">
                                          <option @if($result['vendor'][0]->type==1) selected @endif value="1">{{ trans('labels.Electrician') }}</option>
                                          <option @if($result['vendor'][0]->type==0) selected @endif value="0">{{ trans('labels.Mechanic') }}</option>
                                      </select>
                                      <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">
                                      {{ trans('labels.VendorStatustext') }}</span>
                                  </div>
                                </div>
                            <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Status') }}</label>
                                  <div class="col-sm-10 col-md-4">
                                      <select class="form-control" name="status">
                                          <option @if($result['vendor'][0]->status==1) selected @endif value="1">{{ trans('labels.Active') }}</option>
                                          <option @if($result['vendor'][0]->status==0) selected @endif value="0">{{ trans('labels.InActive') }}</option>
                                      </select>
                                      <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">
                                      {{ trans('labels.VendorStatustext') }}</span>
                                  </div>
                                </div>
                                  
                             </div>  
                                
                              <!-- /.box-body -->
                              <div class="box-footer text-center">
                                <button type="submit" class="btn btn-primary">{{ trans('labels.Update') }}</button>
                                <a href="{{ URL::to('admin/listingVendors')}}" type="button" class="btn btn-default">{{ trans('labels.back') }}</a>
                              </div>
                              <!-- /.box-footer -->
                            {!! Form::close() !!}
                        </div>
                  </div>
              </div>
            </div>
            
          </div>
          <div class="box-body">
            <div class="row">
              <div class="col-xs-12">
              		<div class="box box-info">
                    <br>                       
                        @if (count($errors) > 0)
                              @if($errors->any())
                                <div class="alert alert-success alert-dismissible" role="alert">
                                  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                  {{$errors->first()}}
                                </div>
                              @endif
                          @endif
                        <!--<div class="box-header with-border">
                          <h3 class="box-title">Edit category</h3>
                        </div>-->
                        <!-- /.box-header -->
                        <!-- form start -->                        
                        <div class="box-body">
                          <div class="row">
                            <div class="col-md-6">
                             {!! Form::open(array('url' =>'admin/updatevendorpassword', 'method'=>'post', 'class' => 'form-horizontal', 'enctype'=>'multipart/form-data')) !!}
                                 {!! Form::hidden('id',  $result['vendor'][0]->myid , array('class'=>'form-control', 'id'=>'id')) !!}
                                  
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Update Password') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('password', '', array('class'=>'form-control','id'=>'password')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.VendorPasswordtext') }}</span>
                                  </div>
                                </div>
                                
                             </div>  
                              <!-- /.box-body -->
                              <div class="box-footer text-center">
                                <button type="submit" class="btn btn-primary">{{ trans('labels.Update') }}</button>
                                <a href="{{ URL::to('admin/listingVendors')}}" type="button" class="btn btn-default">{{ trans('labels.back') }}</a>
                              </div>
                              <!-- /.box-footer -->
                            {!! Form::close() !!}
                        </div>
                  </div>
              </div>
            </div>
            
          </div>
          <!-- /.box-body --> 
        </div>
        <!-- /.box --> 
      </div>
      <!-- /.col --> 
    </div>
    <!-- /.row --> 
    
    <!-- Main row --> 
    
    <!-- /.row --> 
  </section>
  <!-- /.content --> 
</div>
@endsection 