@extends('admin.layout')
@section('content')
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1> {{ trans('labels.AddCustomer') }} <small>{{ trans('labels.AddCustomer') }}...</small> </h1>
    <ol class="breadcrumb">
      <li><a href="{{ URL::to('admin/dashboard/this_month')}}"><i class="fa fa-dashboard"></i> {{ trans('labels.breadcrumb_dashboard') }}</a></li>
      <li><a href="listingCustomers"><i class="fa fa-users"></i> {{ trans('labels.ListingAllCustomers') }}</a></li>
      <li class="active">{{ trans('labels.AddCustomer') }}</li>
    </ol>
  </section>
  
  <!-- Main content -->
  <section class="content"> 
    <!-- Info boxes --> 
    
    <!-- /.row -->

    <div class="row">
      <div class="col-md-12">
        <div class="box">
          <div class="box-header">
            <h3 class="box-title">{{ trans('labels.AddCustomer') }} </h3>
          </div>
          
          <!-- /.box-header -->
          <div class="box-body">
            <div class="row">
              <div class="col-xs-12">
              		<div class="box box-info">
                        <!--<div class="box-header with-border">
                          <h3 class="box-title">Edit category</h3>
                        </div>-->
                        <!-- /.box-header -->
                        <br>                       
                       	@if(count($instalation['message'])>0)						
						<div class="alert alert-success alert-dismissible" role="alert">
						  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						 {{ $instalation['message'] }}
						</div>						
						@endif
                        
                       @if(count($instalation['errorMessage'])>0)						
						<div class="alert alert-danger" role="alert">
						  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						 {{ $instalation['errorMessage'] }}
						</div>						
						@endif
                        
                        <!-- form start -->                        
                         <div class="box-body">
                            {!! Form::open(array('url' =>'admin/addNewInstalation', 'method'=>'post', 'class' => 'form-horizontal form-validate', 'enctype'=>'multipart/form-data')) !!}
                              
                              <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.CustomerName') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    <select class="form-control field-validate select2" name="customers_id">
                                        @if(count($instalation['customers'])>0)
                                            @foreach ($instalation['customers'] as $customer)
                                            <option value="{{ $customer->customers_id }}">{{ $customer->customers_firstname}}&nbsp;{{ $customer->customers_lastname}}&nbsp;&nbsp;{{ $customer->customers_telephone}}&nbsp;&nbsp; {{ $customer->customers_email_address }}</option>
                                        @endforeach
                                        @endif
                                        
                                    </select>
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.FirstNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                
                              <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Elevater Code') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('elevator_code',  '', array('class'=>'form-control field-validate', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                 
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Address') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                      <input name="address" id="pac-input" class="  form-control" autocomplete="rutjfkde" type="text" placeholder="Search Address">
                                      <input name="lat" id="latitude" class=" form-control" autocomplete="rutjfkde" type="hidden" >
                                      <input name="lng" id="longitude" class=" form-control" autocomplete="rutjfkde" type="hidden" >
                                        <div id="map" ></div>
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>

                                
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Floor No') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('floor_no',  '', array('class'=>'form-control field-validate ', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Doors') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('door_no',  '', array('class'=>'form-control field-validate ', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                @if(!isset($_GET['type']))
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.QA00') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('qa',  '', array('class'=>'form-control field-validate ', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                @endif
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Elevater Type') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('elevator_type',  '', array('class'=>'form-control field-validate', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                @if(!isset($_GET['type']))
                               <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Installation Date') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                      
                                      <input type="datetime-local" id="installation_date"
       name="installation_date" value="" class="form-control field-validate"
       min="2020-05-05T00:00" >
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">Technician </label>
                                  <div class="col-sm-10 col-md-4">
                                    <select class="form-control field-validate select2" name="technician">
                                        @if(count($instalation['technician'])>0)
                                            @foreach ($instalation['technician'] as $customer)
                                            <option value="{{ $customer->myid }}">{{ $customer->first_name}}&nbsp;&nbsp;{{ $customer->phone}}</option>
                                        @endforeach
                                        @endif
                                        
                                    </select>
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.FirstNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Expiry Date') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('expiry_date',  '', array('class'=>'form-control field-validate datepicker', 'readonly','id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                               <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Maintenance Frequency') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('maintenance_frequency',  '', array('class'=>'form-control field-validate', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div> 
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Image') }}</label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::file('newImage', array('id'=>'image', 'class'=>'field-validate')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">
                                    {{ trans('labels.UploadProductImageText') }}</span>
                                  </div>
                                </div>
                                @endif
                                
                                
                                <input type="hidden" name="type" value=@if(isset($_GET['type'])) "1" @else "2" @endif>
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Status') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    <select class="form-control" name="status">
                                          <option value="1">{{ trans('labels.Active') }}</option>
                                          <option value="0">{{ trans('labels.Inactive') }}</option>
									</select>
                                  <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">
                                  {{ trans('labels.StatusText') }}</span>
                                  </div>
                                </div>
                                
                              <!-- /.box-body -->
                              <div class="box-footer text-center">
                                <button type="submit" class="btn btn-primary">{{ trans('labels.Submit') }}</button>
                                <a href="listingInstalations" type="button" class="btn btn-default">{{ trans('labels.back') }}</a>
                              </div>
                              <!-- /.box-footer -->
                            {!! Form::close() !!}
                        </div>
                  </div>
              </div>
            </div>
            
          </div>
          <!-- /.box-body --> 
        </div>
        <!-- /.box --> 
      </div>
      <!-- /.col --> 
    </div>
    <!-- /.row --> 
    
    <!-- Main row --> 
    
    <!-- /.row --> 
  </section>
  <!-- /.content --> 
</div>
@endsection 