<?php
/*
Project Name: Laundry Project

Author: Omkar Khalipe

Version: 2.9.2
*/
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;

//validator is builtin class in laravel
use Validator;
use App;
use Lang;
use DB;
//for password encryption or hash protected

use Hash;
use App\Administrator;

//for authenitcate login data
use Auth;
//for redirect
use Illuminate\Support\Facades\Redirect;
//use Illuminate\Foundation\Auth\ThrottlesLogins;
//use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;

//for requesting a value 
use Illuminate\Http\Request;
//use Illuminate\Routing\Controller;

class AdminInstalationController extends Controller
{
     public function getPlaces($str){
        
            $curl = curl_init();
            
            curl_setopt_array($curl, array(
              CURLOPT_URL => "https://maps.googleapis.com/maps/api/geocode/json?latlng=".$str."&key=AIzaSyA74kd12o-Ndz144M1eNcO3TW4vwgu04lw",
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => "",
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 30,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => "GET",
              CURLOPT_POSTFIELDS => "",
              CURLOPT_HTTPHEADER => array(
                "Postman-Token: 8750cd9f-bea5-4c40-a299-9b719ae60bb5",
                "cache-control: no-cache"
              ),
            ));
            
            $response = curl_exec($curl);
            $err = curl_error($curl);
            
            curl_close($curl);
            
            if ($err) {
              echo "cURL Error #:" . $err;
            } else {
              echo $response;
            }
    }
    
	//listingInstalations
	public function listingInstalations(Request $request){
		$title = array('pageTitle' => Lang::get("labels.ListingCustomers"));
		$language_id            				=   '1';			
		
		$instalationsData = array();
		$message = array();
		$errorMessage = array();
		
		$instalations = DB::table('instalations')
		->LeftJoin('customers','customers.customers_id','=','instalations.customers_id')
		->select('instalations.*','customers.customers_telephone','customers.customers_firstname','customers.customers_lastname')
		->orderBy('instalations.id','ASC')
		->where("status",">",2)
		->get();
		
		$instalationsData['message'] = $message;
		$instalationsData['errorMessage'] = $errorMessage;
		$instalationsData['result'] = $instalations;
		
		return view("admin.listingInstalations",$title)->with('instalations', $instalationsData);
	}
	
	
	
		public function listingContracts(Request $request){
		$title = array('pageTitle' => Lang::get("labels.ListingCustomers")); 
		$language_id            				=   '1';			
		
		$instalationsData = array();
		$message = array();
		$errorMessage = array();
		
		$instalations = DB::table('instalations')
		->LeftJoin('customers','customers.customers_id','=','instalations.customers_id')

		->select('instalations.*','customers.customers_telephone','customers.customers_firstname','customers.customers_lastname')
	//	->where("status",1)
		->orderBy('instalations.id','ASC')
		->get();
		
		$instalationsData['message'] = $message;
		$instalationsData['errorMessage'] = $errorMessage;
		$instalationsData['result'] = $instalations;
		
		return view("admin.listingContracts",$title)->with('instalations', $instalationsData);
	}
	
	
		public function listingElectrical(Request $request){
		$title = array('pageTitle' => Lang::get("labels.ListingCustomers"));
		$language_id            				=   '1';			
		
		$instalationsData = array();
		$message = array();
		$errorMessage = array();
		
		$instalations = DB::table('instalations')
		->LeftJoin('customers','customers.customers_id','=','instalations.customers_id')
				->LeftJoin("site_visits","site_visits.installation_id","=","instalations.id")
		->select('instalations.*','customers.customers_telephone','customers.customers_firstname','customers.customers_lastname','site_visits.*','instalations.status as sstatus')
		->where("type",5)
		->orderBy('instalations.id','ASC')
		->get();
		
		$instalationsData['message'] = $message;
		$instalationsData['errorMessage'] = $errorMessage;
		$instalationsData['result'] = $instalations;
		
		return view("admin.listingmechanical",$title)->with('instalations', $instalationsData);
	}
	
	
		public function listingMechanical(Request $request){
		$title = array('pageTitle' => Lang::get("labels.ListingCustomers"));
		$language_id            				=   '1';			
		
		$instalationsData = array();
		$message = array();
		$errorMessage = array();
		
		$instalations = DB::table('instalations')
	->LeftJoin('customers','customers.customers_id','=','instalations.customers_id')
				->LeftJoin("site_visits","site_visits.installation_id","=","instalations.id")
		->select('instalations.*','customers.customers_telephone','customers.customers_firstname','customers.customers_lastname','site_visits.*','instalations.status as sstatus')
		->where("type",4)
		->orderBy('instalations.id','ASC')
		->get();
		
		$instalationsData['message'] = $message;
		$instalationsData['errorMessage'] = $errorMessage;
		$instalationsData['result'] = $instalations;
		
		return view("admin.listingmechanical",$title)->with('instalations', $instalationsData);
	}
	
	//addInstalation
	public function addInstalation(Request $request){
		$title = array('pageTitle' => Lang::get("labels.AddCustomer"));
		//$language_id            				=   $request->language_id;
		$language_id            				=   '1';			
		//print_r($request->all());
		
		$instalationData = array();
		$message = array();
		$errorMessage = array();
		$customers=DB::table('customers')->get();
		$instalationData['customers'] = $customers;
		
		$instalationData['technician']= DB::table("technician")->get();
		
		$instalationData['message'] = $message;
		$instalationData['errorMessage'] = $errorMessage;
		
		return view("admin.addInstalation",$title)->with('instalation', $instalationData);
	}
	
	//addNewInstalation
	public function addNewInstalation(Request $request){
	$title = array('pageTitle' => Lang::get("labels.AddCustomer"));
		//$language_id            				=   $request->language_id;
		$language_id            				=   '1';			
		$instalationData = array();
		$message = array();
		$errorMessage = array();
		
		if($request->hasFile('newImage')){
			$image = $request->newImage;
			$fileName = time().'.'.$image->getClientOriginalName();
			$image->move('resources/assets/images/category_images/', $fileName);
			$uploadImage = 'resources/assets/images/category_images/'.$fileName; 
		}	else{
			$uploadImage = '';
		}
		
		$active_from = date('Y-m-d', strtotime($request->installation_date));
		$active_to = date('Y-m-d', strtotime($request->expiry_date));
		
			$instalation = DB::table('instalations')->insertGetId([
			            'image'                         =>   $uploadImage,
						'address'	 			 	    =>	 isset($request->address)?$request->address:"",
						'lat'                           =>	 $request->lat,    
						'lng'                           =>	 $request->lng,
						'elevator_code'                 =>	 $request->elevator_code,
						'elevator_type'                 =>	 $request->elevator_type,
						'floor_no'                      =>	 $request->floor_no,
						'door_no'                       =>	 $request->door_no,
						'qa'                            =>	 $request->qa,
						'installation_date'   		 	=>   $request->installation_date,
						'expiry_date'	 	            =>   $request->expiry_date,
						'maintenance_frequency' 	    =>   $request->maintenance_frequency,
						'status'		 	 			=>   $request->status,
						'customers_id'                  =>   $request->customers_id,
						'created_at'					=>	 time()
						]);
			DB::table('renewals')->insert([
						'installation_id'		 	            =>   $instalation,
						'active_from'		 	                =>   $request->$active_from,
						'active_to'	 			 	            =>	 $request->$active_to,
						'status'				        	    =>	 $request->type
						]);
						if(!$request->type)
						{
						DB::table('site_visits')->insert([
						'installation_id'		 	            =>   $instalation,
						'scheduled_at'		 	                =>   $request->installation_date,
						'status'				        	    =>	 0,
						'type'=>2,
						'tecnician_id'=>$request->technician,
						'client_id'=>$request->customers_id
						]);
	}
			$instalationData['message'] = $message;
			$instalationData['errorMessage'] = $errorMessage;
			
			return redirect('admin/addInstalation')->with('instalation', $instalationData);		
		}

	//editInstalation
	public function editInstalation(Request $request){
	    $title = array('pageTitle' => Lang::get("labels.AddCustomer"));
	    
		$instalationData = array();
		$message = array();
		$errorMessage = array();
		
		$id            =   $request->id;	
		$customers=DB::table('customers')->get();
		$instalationData['customers'] = $customers;
		
		$instalation = DB::table('instalations')->where('id','=', $id)->get();	
		
		$instalationData['message'] = $message;
		$instalationData['errorMessage'] = $errorMessage;
		$instalationData['instalation'] = $instalation;
		
			
		//print_r($customerData);
		return view("admin.editInstalation",$title)->with('instalation', $instalationData);
	}
	
	//updateInstalation
	public function updateInstalation(Request $request){
				
		$language_id            		=   '1';			
		$id					=	$request->id;
		
		$instalationData = array();
		$message = array();
		$errorMessage = array();
		
		if($request->hasFile('newImage')){
			$image = $request->newImage;
			$fileName = time().'.'.$image->getClientOriginalName();
			$image->move('resources/assets/images/category_images/', $fileName);
			$uploadImage = 'resources/assets/images/category_images/'.$fileName; 
		}	else{
			$uploadImage = $request->oldImage;
		}
		
		$active_from = date('Y-m-d', strtotime($request->installation_date));
		$active_to = date('Y-m-d', strtotime($request->expiry_date));
		
		$instalation_data = array(
		                'image'                         =>   $uploadImage,
						'address'	 			 	    =>	 $request->address,
						'lat'                           =>	 $request->lat,    
						'lng'                           =>	 $request->lng,
						'elevator_code'                 =>	 $request->elevator_code,
						'elevator_type'                 =>	 $request->elevator_type,
						'floor_no'                      =>	 $request->floor_no,
						'door_no'                       =>	 $request->door_no,
						'qa'                            =>	 $request->qa,
						'installation_date'   		 	=>   $request->$active_from,
						'expiry_date'	 	            =>   $request->$active_to,
						'maintenance_frequency' 	    =>   $request->maintenance_frequency,
						'status'		 	 			=>   $request->status,
						'customers_id'                  =>   $request->customers_id,
						'updated_at'					=>	 time()
		);

			DB::table('instalations')->where('id', '=', $id)->update($instalation_data);
			
			return redirect()->back()->withErrors([Lang::get("labels.DeleteCustomerMessage")]);
	}
	
	//deleteInstalation
	public function deleteInstalation(Request $request){
		$id = $request->id;
		
		DB::table('instalations')->where('id','=', $id)->delete();
	
		
		return redirect()->back()->withErrors([Lang::get("labels.DeleteCustomerMessage")]);
	}
	
	//listingSchedual
	public function listingSchedual(Request $request){
		$title = array('pageTitle' => Lang::get("labels.ListingCustomers"));
		$language_id            				=   '1';			
		
		$instalationsData = array();
		$message = array();
		$errorMessage = array();
		
	
           
		$instalations = DB::table('site_visits')
		    ->leftJoin('technician','technician.myid','=','site_visits.tecnician_id')
		    ->leftJoin('instalations','instalations.id','=','site_visits.installation_id')
		   // ->leftJoin('answers','answers.site_visit_id','=','site_visits.id')
		    //->leftJoin('questions','answers.qid','=','questions.id')
		 
		    ->leftJoin('customers','customers.customers_id','instalations.customers_id')
		    
		    ->select('site_visits.*','technician.first_name','instalations.id','instalations.elevator_code','customers.customers_firstname','customers.customers_telephone','customers.customers_lastname','site_visits.id as sid'
		    //,'answers.answer','questions.name'
		    );
		    
		    if(isset($_GET['installation_id']))
		    {
		        $instalations = $instalations->where("installation_id",$_GET['installation_id']);
		    }
		    
		    $recs=$instalations->get();
		   
		$instalations= $instalations	->orderBy('site_visits.id','ASC')
			->paginate(20);
	 foreach($instalations as $rec)
		    {
		      $rec->answers =  DB::table("answers")->leftJoin('questions','answers.qid','=','questions.id')->where('answers.site_visit_id','=',$rec->sid)->select("answers.answer","questions.name")->get();
		    }
	
		
		$instalationsData['message'] = $message;
		$instalationsData['errorMessage'] = $errorMessage;
		$instalationsData['result'] = $instalations;
		
		return view("admin.listingSchedual",$title)->with('instalations', $instalationsData);
	}
	
	//addSchedual
	public function addSchedual(Request $request){
		$title = array('pageTitle' => Lang::get("labels.AddCustomer"));
		//$language_id            				=   $request->language_id;
		$language_id            				=   '1';			
		//print_r($request->all());
		
		$schedualData = array();
		$message = array();
		$errorMessage = array();
		
		//technician
		$technician = DB::table('technician')->select('technician.*')->get();
		$schedualData['technician'] = $technician;
		//instalations
		$instalation = DB::table('instalations')->select('instalations.*')->get();
		$schedualData['instalation'] = $instalation;
		
		$schedualData['message'] = $message;
		$schedualData['errorMessage'] = $errorMessage;
		
		return view("admin.addSchedual",$title)->with('schedualData', $schedualData);
	}
	
	//addNewSchedual
	public function addNewSchedual(Request $request){
	$title = array('pageTitle' => Lang::get("labels.AddCustomer"));
		//$language_id            				=   $request->language_id;
		$language_id            				=   '1';			
		$instalationData = array();
		$message = array();
		$errorMessage = array();
		$type = isset($request->type)? $request->type : 1;
		if($type!=1)
		{
			DB::table("instalations")->where("id",$request->installation_id)->update(['status'=>$type]);
		}
		
		if(isset($request->schedules))
		{
			$sc = json_decode($request->schedules);
			foreach($sc as $schedule)
			{
				
				$instalation = DB::table('site_visits')->insertGetId([
					'installation_id'		 	                =>   $schedule->installation_id,
					'tecnician_id'		 	                =>   $schedule->tecnician_id,
					'scheduled_at'	 			 	    =>	 $schedule->scheduled_at,
					'type'=>$type,
					'created_at'					=>	 time()
					]);
			}
		}
		else
		{
			$instalation = DB::table('site_visits')->insertGetId([
						'installation_id'		 	                =>   $request->installation_id,
						'tecnician_id'		 	                =>   $request->tecnician_id,
						'scheduled_at'	 			 	    =>	 $request->scheduled_at,
						'type'=>$type,
						'created_at'					=>	 time()
						]);
			}
			$instalationData['message'] = $message;
			$instalationData['errorMessage'] = $errorMessage;
			
			return redirect()->back()->withErrors([Lang::get("labels.DeleteCustomerMessage")]);
		}

	//editSchedual
	public function editSchedual(Request $request){
	    $title = array('pageTitle' => Lang::get("labels.AddCustomer"));
	    
		$schedualData = array();
		$message = array();
		$errorMessage = array();
		
		$id            =   $request->id;	
		
		$scheduals = DB::table('site_visits')->where('id','=', $id)->get();	
		//technician
		$technician = DB::table('technician')->select('technician.*')->get();
		$schedualData['technician'] = $technician;
		//instalations
		$instalation = DB::table('instalations')->select('instalations.*')->get();
		$schedualData['instalation'] = $instalation;
		
		$schedualData['message'] = $message;
		$schedualData['errorMessage'] = $errorMessage;
		$schedualData['schedual'] = $scheduals;
			
		//print_r($customerData);
		return view("admin.editSchedual",$title)->with('schedualData', $schedualData);
	}
	
	//updateSchedual
	public function updateSchedual(Request $request){
				
		$language_id            		=   '1';			
		$id					=	$request->id;
		
		$instalationData = array();
		$message = array();
		$errorMessage = array();
		
		$instalation_data = array(
			           'installation_id'		 	                =>   $request->installation_id,
						'tecnician_id'		 	                =>   $request->tecnician_id,
						'scheduled_at'	 			 	    =>	 $request->scheduled_at,
						'updated_at'					=>	 time()
		);

			DB::table('site_visits')->where('id', '=', $id)->update($instalation_data);
			
			return redirect()->back()->withErrors([Lang::get("labels.DeleteCustomerMessage")]);
	}
	
	//deleteSchedual
	public function deleteSchedual(Request $request){
		$id = $request->id;
		
		DB::table('site_visits')->where('id','=', $id)->delete();
	
		
		return redirect()->back()->withErrors([Lang::get("labels.DeleteCustomerMessage")]);
	}
	
		//listingSchedual
	public function listingMaintenance(Request $request){
		$title = array('pageTitle' => Lang::get("labels.ListingCustomers"));
		$language_id            				=   '1';			
		
		$instalationsData = array();
		$message = array();
		$errorMessage = array();
		
		$instalations = DB::table('maintancance_questions')
		->orderBy('maintancance_questions.id','ASC')
		->paginate(20);
		   
		
		$instalationsData['message'] = $message;
		$instalationsData['errorMessage'] = $errorMessage;
		$instalationsData['result'] = $instalations;
		
		return view("admin.listingMaintenance",$title)->with('instalations', $instalationsData);
	}
	
	//addSchedual
	public function addMaintenance(Request $request){
		$title = array('pageTitle' => Lang::get("labels.AddCustomer"));
		//$language_id            				=   $request->language_id;
		$language_id            				=   '1';			
		//print_r($request->all());
		
		$schedualData = array();
		$message = array();
		$errorMessage = array();
		
		$schedualData['message'] = $message;
		$schedualData['errorMessage'] = $errorMessage;
		
		return view("admin.addMaintenance",$title)->with('schedualData', $schedualData);
	}
	
	//addNewSchedual
	public function addNewMaintenance(Request $request){
	$title = array('pageTitle' => Lang::get("labels.AddCustomer"));
		//$language_id            				=   $request->language_id;
		$language_id            				=   '1';			
		$instalationData = array();
		$message = array();
		$errorMessage = array();
		
			$instalation = DB::table('maintancance_questions')->insertGetId([
						'name'		 	                =>   $request->name,
						'created_at'					=>	 time()
						]);
			$instalationData['message'] = $message;
			$instalationData['errorMessage'] = $errorMessage;
			
			return redirect()->back()->withErrors([Lang::get("labels.DeleteCustomerMessage")]);
		}

	//editSchedual
	public function editMaintenance(Request $request){
	    $title = array('pageTitle' => Lang::get("labels.AddCustomer"));
	    
		$result = array();
		$message = array();
		$errorMessage = array();
		
		$id            =   $request->id;	
		
		$scheduals = DB::table('maintancance_questions')->where('id','=', $id)->get();	
	
		$result['message'] = $message;
		$result['errorMessage'] = $errorMessage;
		$result['result'] = $scheduals;
			
		//print_r($customerData);
		return view("admin.editMaintenance",$title)->with('result', $result);
	}
	
	//updateSchedual
	public function updateMaintenance(Request $request){
				
		$language_id            		=   '1';			
		$id					=	$request->id;
		
		$instalationData = array();
		$message = array();
		$errorMessage = array();
		
		$instalation_data = array(
			           'name'		 	                =>   $request->name,
					
						'updated_at'					=>	 time()
		);

			DB::table('maintancance_questions')->where('id', '=', $id)->update($instalation_data);
			
			return redirect()->back()->withErrors([Lang::get("labels.DeleteCustomerMessage")]);
	}
	
	//deleteSchedual
	public function deleteMaintenance(Request $request){
		$id = $request->id;
		
		DB::table('maintancance_questions')->where('id','=', $id)->delete();
	
		
		return redirect()->back()->withErrors([Lang::get("labels.DeleteCustomerMessage")]);
	}
	
	//listingRenewals
	public function listingRenewals(Request $request){
		$title = array('pageTitle' => Lang::get("labels.ListingVendors"));		
		
		$result = array();
		$message = array();
		$banners = DB::table('renewals')
		->LeftJoin('instalations','instalations.id','=','renewals.installation_id')
		->LeftJoin('customers','customers.customers_id','=','instalations.customers_id')
		->select('renewals.id','renewals.active_from','renewals.active_to','renewals.status','instalations.elevator_code','customers.customers_firstname','customers.customers_telephone','customers.customers_lastname')
		->get();
		
		$result['message'] = $message;
		$result['banners'] = $banners;
		
		return view("admin.listingRenewals", $title)->with('result', $result);
	}
	
	//addRenewals
	public function addRenewals(Request $request){
		$title = array('pageTitle' => Lang::get("labels.AddCustomer"));
		//$language_id            				=   $request->language_id;
		$language_id            				=   '1';			
		//print_r($request->all());
		
		$schedualData = array();
		$message = array();
		$errorMessage = array();
		
		//technician
		$technician = DB::table('technician')->select('technician.*')->get();
		$schedualData['technician'] = $technician;
		//instalations
		$instalation = DB::table('instalations')->select('instalations.*')->get();
		$schedualData['instalation'] = $instalation;
		
		$schedualData['message'] = $message;
		$schedualData['errorMessage'] = $errorMessage;
		
		return view("admin.addRenewals",$title)->with('schedualData', $schedualData);
	}
	
	//addNewRenewals
	public function addNewRenewals(Request $request){
	$title = array('pageTitle' => Lang::get("labels.AddCustomer"));
		//$language_id            				=   $request->language_id;
		$language_id            				=   '1';			
		$instalationData = array();
		$message = array();
		$errorMessage = array();
		
		$active_from = date('Y-m-d', strtotime($request->active_from));
		$active_to = date('Y-m-d', strtotime($request->active_to));
		
			$instalation = DB::table('renewals')->insert([
						'installation_id'		 	            =>   $request->installation_id,
						'active_from'		 	                =>   $active_from,
						'active_to'	 			 	            =>	 $active_to,
						'status'				        	    =>	 $request->status
						]);
			$instalationData['message'] = $message;
			$instalationData['errorMessage'] = $errorMessage;
			
			return redirect()->back()->withErrors([Lang::get("labels.DeleteCustomerMessage")]);
		}
		
	//editRenewals
	public function editRenewals(Request $request){
	    $title = array('pageTitle' => Lang::get("labels.AddCustomer"));
	    
		$schedualData = array();
		$message = array();
		$result = array();
		$errorMessage = array();
		$id            =   $request->id;	
		
		
		
		$banners = DB::table('renewals')->where('renewals.id',$id)->get();
		
		$instalations = DB::table('instalations')->select('instalations.id as instal_id','instalations.elevator_code')->get();
		$result['instalations'] = $instalations;
		
		
		$result['message'] = $message;
		$result['errorMessage'] = $errorMessage;
		$result['banners'] = $banners;
			
		//print_r($customerData);
		return view("admin.editRenewals",$title)->with('result', $result);
	}
	
	//updateRenewals
	public function updateRenewals(Request $request){
				
		$language_id            		=   '1';			
		$id					=	$request->id;
		$instalationData = array();
		$message = array();
		$errorMessage = array();
		$active_from = date('Y-m-d', strtotime($request->active_from));
		$active_to = date('Y-m-d', strtotime($request->active_to));
		
		$instalation_data = array(
			            'installation_id'		 	            =>   $request->installation_id,
						'active_from'		 	                =>   $active_from,
						'active_to'	 			 	            =>	 $active_to,
						'status'				        	    =>	 $request->status
		);

			DB::table('renewals')->where('id', '=', $id)->update($instalation_data);
			
			return redirect()->back()->withErrors([Lang::get("labels.DeleteCustomerMessage")]);
	}
	
	//deleteRenewals
	public function deleteRenewals(Request $request){
		$id = $request->id;
		DB::table('renewals')->where('id','=', $id)->delete();
		return redirect()->back()->withErrors([Lang::get("labels.DeleteCustomerMessage")]);
	}
}
