 <?php $__env->startSection('content'); ?>
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Products<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li>Products</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="#" target="_blank" class="btn btn-sm btn-twitter" title="Export"><i
                                            class="fa fa-download"></i><span class="hidden-xs"> Export</span></a>
                                    <button type="button" class="btn btn-sm btn-twitter dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" target="_blank">All</a></li>
                                        <li><a href="#" target="_blank">Current page</a></li>
                                        <li><a href="#" target="_blank" class="export-selected">Selected rows</a></li>
                                    </ul>
                                </div>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product.create','all'])): ?>
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a href="<?php echo e(route('product.create')); ?>" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                                <?php endif; ?>
                            </div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product.destroy','all'])): ?>
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="<?php echo e(url('public/admin/product')); ?>" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover grid-table" id="example">
                                <thead>
                                    <tr>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product.destroy','all'])): ?>
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        <?php endif; ?>
                                        <th>ID</th>
                                        <th>Image</th>
                                        <th>Product</th>
                                        <th>Other</th>
                                        <th>Price</th>
                                        <th>Vendor</th>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product.edit','all'])): ?>
                                        <th>Status</th>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product.destroy','product.edit','all'])): ?>
                                        <th>Action</th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr data-key="<?php echo e($product->id); ?>">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product.destroy','product.edit','all'])): ?>
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="<?php echo e($product->id); ?>" style="position: absolute; opacity: 0;">
                                        </td>
                                        <?php endif; ?>
                                        <td><?php echo e($product->id); ?></td>
                                        <td><img src="<?php echo e(asset('').$product->image); ?>" width="100px" alt=""></td>
                                        <td>
                                            <strong>Name: </strong><?php echo e($product->name); ?><br>
                                            <strong>Type: </strong><?php echo e($product->type); ?><br>
                                            <strong>Liked: </strong><?php echo e($product->liked); ?><br>
                                            <?php if(!empty($product->special_id)): ?>
                                            <strong class="badge bg-yellow">Special Price: </strong> QR <?php echo e($product->special_price); ?><br>
                                                <?php if(($product->special_id) !== null): ?>
                                                        <?php if($product->expires_date > strtotime(date('Y-m-d'))): ?>
                                                         <strong class="badge bg-light-blue">Expiry Date:</strong>
                                                            <?php echo e(date('Y-m-d', $product->expires_date)); ?>

                                                         <?php else: ?>
                                                        <strong class="badge bg-red">Expired</strong>
                                                        <?php echo e(date('Y-m-d', $product->expires_date)); ?>

                                                        <?php endif; ?> 
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <Strong>Category:</Strong> <?php echo e($product->category_name); ?><br>
                                            <Strong>current Stock:</Strong> <?php echo e($product->in_stock =  $product->out_stock); ?>

                                        </td>
                                        <td>QR <?php echo e($product->price); ?></td>
                                        <td><?php echo e($product->first_name); ?> <?php echo e($product->last_name); ?></td>
                                         <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product.edit','all'])): ?>
                                        <td class="column-updated_at">
                                            <div class="status-toggle"> 
                                                <input type="checkbox" route="<?php echo e(route('product.productStatus')); ?>" id="<?php echo e($product->id); ?>" class="check"  value="<?php echo e($product->id); ?>" <?php if($product->status=='Active'): ?> checked <?php endif; ?>>
                                                <label for="<?php echo e($product->id); ?>" class="checktoggle change_status">checkbox</label>
                                            </div>                                      
                                        </td>
                                       <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product.destroy','product.edit','all'])): ?>
                                        <td class="column-__actions__">
                                           <div class="btn-group" style="margin-right: 10px">
                                                <a href="#" class="btn btn-xs btn-twitter" title="Export"><span class="hidden-xs">Action</span></a>
                                                <button type="button" class="btn btn-xs btn-twitter dropdown-toggle" data-toggle="dropdown">
                                                    <span class="caret"></span>
                                                    <span class="sr-only"></span>
                                                </button>
                                                <ul class="dropdown-menu" role="menu">
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product.edit','all'])): ?>
                                                    <li><a href="<?php echo e(route('product.edit',$product->id)); ?>">Edit Product</a></li>
                                                    <?php if($product->type=='Variable'): ?>
                                                    <li><a href="<?php echo e(URL::to('admin/product/productAttribute')); ?>/<?php echo e($product->id); ?>">Product Attributes</a></li>
                                                    <?php endif; ?>
                                                    <li><a href="#">Add Inventory</a></li>
                                                    <li><a href="<?php echo e(URL::to('admin/product/images')); ?>/<?php echo e($product->id); ?>">Product Images</a></li>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product.destroy','all'])): ?>
                                                    <li><a data-id="<?php echo e($product->id); ?>" route="<?php echo e(route('product.destroy',$product->id)); ?>" href="#" class="grid-batch-0" >Delete Product</a></li>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>
                                            
                                        </td>
                                        <?php endif; ?>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    <?php echo $__env->make('admin.common.toastr', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mawaeedqatar/public_html/resources/views/admin/products/index.blade.php ENDPATH**/ ?>