 <?php $__env->startSection('content'); ?>
<div class="content-wrapper" id="pjax-container" style="min-height: 474px;">
    <style type="text/css"></style>
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Order<small>Edit</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>Auth</li>
                <li>Orders</li>
                <li>Update</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h2 class="box-title"><i class="fa fa-globe" style="font-size: 22px;"></i> Order ID# <?php echo e($order->id); ?> <small style="display: inline-block">Ordered Date: <?php echo e(date('d M Y', strtotime($order->created_at))); ?></small></h3>
                            
                            <div class="btn-group pull-right" style="margin-right: 5px">
                                <a href="<?php echo e(URL::to('admin/order')); ?>" class="btn btn-sm btn-default" title="List"><i class="fa fa-list"></i><spanclass="hidden-xs">&nbsp;List</span></a>
                                <a href="<?php echo e(URL::to('admin/orders/invoiceprint/'.$order->order_id)); ?>" class="btn btn-sm btn-default" title="List"><i class="fa fa-print"></i><spanclass="hidden-xs">&nbsp;Print</span></a>
                            </div>
                            
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        
                            <div class="box-body">
                                <div class="invoice-info">
                                    <div class="col-sm-4 invoice-col">
                                      Customer Info
                                       <address>
                                        <strong><?php echo e($order->name); ?></strong><br>
                                        <?php echo e($order->street_address); ?> <br>
                                        <?php echo e($order->city); ?>, <?php echo e($order->state); ?> <?php echo e($order->postcode); ?>, <?php echo e($order->country); ?><br>
                                        <strong>Phone:</strong> <?php echo e($order->phone); ?><br>
                                        <strong>Email:</strong> <?php echo e($order->email); ?>

                                      </address>
                                    </div>
                                    <div class="col-sm-4 invoice-col">
                                      Shipping Info
                                       <address>
                                        <strong><?php echo e($order->delivery_name); ?></strong><br>
                                        <?php echo e($order->delivery_street_address); ?> <br>
                                        <?php echo e($order->delivery_city); ?>, <?php echo e($order->delivery_state); ?> <?php echo e($order->delivery_postcode); ?>, <?php echo e($order->delivery_country); ?><br>
                                        <strong>Phone: </strong><?php echo e($order->delivery_phone); ?><br>
                                        <strong>Shipping Method:</strong> <?php echo e($order->shipping_method); ?> <br>
                                        <strong>Shipping Cost:</strong> <?php if(!empty($order->shipping_cost)): ?> QAR <?php echo e($order->shipping_cost); ?> <?php endif; ?>
                                      </address>
                                    </div>
                                    <div class="col-sm-4 invoice-col">
                                      Billing Info
                                      <address>
                                        <strong><?php echo e($order->billing_name); ?></strong><br>
                                        <?php echo e($order->billing_street_address); ?> <br>
                                        <strong>Phone: </strong><?php echo e($order->billing_phone); ?><br>
                                        <?php echo e($order->billing_city); ?>, <?php echo e($order->billing_state); ?> <?php echo e($order->billing_postcode); ?>, <?php echo e($order->billing_country); ?><br>
                                      </address>
                                    </div>
                                </div>
                                
                                <div class="table-responsive no-padding" style="overflow-x:unset;">
                               <table class="table table-hover grid-table">
                                <thead>
                                    <tr>
                                        <th>Vendor</th>
                                        <th>Qty</th>
                                        <th>Product</th>
                                        <th>Image</th>
                                        <th>Description</th>
                                        <th></th>
                                        <th>Total</th>
                                        <th>Subtotal</th>
                                    </tr>
                                </thead>
                                <tbody>
                                  <?php $__currentLoopData = $ordersData['orders_data'][0]->data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $products): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($products->first_name); ?> <?php echo e($products->last_name); ?></td>
                                        <td><?php echo e($products->product_quantity); ?></td>
                                        <td><img src="<?php echo e(asset('').$products->image); ?>" width="60px"></td>
                                        <td><?php echo e($products->product_name); ?><br></td>
                                        <td>
                                            <?php $__currentLoopData = $products->attribute; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attributes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            	<b>Option:</b> <?php echo e($attributes->product_option); ?><br>
                                                <b>Value:</b> <?php echo e($attributes->product_option_value); ?><br>
                                                <b>Price:</b> <?php echo e($web_setting[0]->code); ?> <?php echo e($attributes->option_value_price); ?><br>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </td>
                                        <td>
                                            <?php if($products->gift_price > 0): ?>
                                                <span style="font-size: 12px;color: #bb7a5c;display: inline-block;"><?php echo app('translator')->get('website.Gift Price'); ?></span><br><?php echo e($web_setting[0]->code); ?> <?php echo e($products->gift_price); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($web_setting[0]->code); ?> <?php echo e($products->final_price); ?></td>
                                        <td><?php echo e($web_setting[0]->code); ?> <?php echo e($products->final_price + $products->gift_price); ?></td>
                                     </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                                  </div> 
                                <div class="row">
                                    <!-- accepted payments column -->
                                    <div class="col-xs-6">
                                      <p class="lead">Payment Methods:</p>
                                     <p class="text-muted well well-sm no-shadow" style="text-transform:capitalize">
                                       	<?php echo e(str_replace('_',' ', $ordersData['orders_data'][0]->payment_method)); ?>

                                      </p>
                                        <?php if(!empty($ordersData['orders_data'][0]->coupon_code)): ?>
                                        <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
                                          <p class="lead" style="margin-bottom:10px">Coupons:</p>
                                            <table class="text-muted well well-sm no-shadow stripe-border table table-striped" style="text-align: center; ">
                                            	<tr>
                                                    <th style="text-align: center; ">Code</th>
                                                    <th style="text-align: center; ">Amount</th>
                                                </tr>
                                            	<?php $__currentLoopData = json_decode($ordersData['orders_data'][0]->coupon_code); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $couponData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                	<tr>
                                                    	<td><?php echo e($couponData->code); ?></td>
                                                        <td><?php echo e($couponData->amount); ?>

                                                            <?php if($couponData->discount_type=='percent_product'): ?>
                                                                (Percent)
                                                            <?php elseif($couponData->discount_type=='percent'): ?>
                                                                (Percent)
                                                            <?php elseif($couponData->discount_type=='fixed_cart'): ?>
                                                                (Fixed)
                                                            <?php elseif($couponData->discount_type=='fixed_product'): ?>
                                                                (Fixed)
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            				</table>
                                           <!-- <?php echo e($data['orders_data'][0]->coupon_code); ?>-->
                                        </p>
                                      <?php endif; ?>
                                      <p class="lead" style="margin-bottom:10px">Order information:</p>
                                      <p class="text-muted well well-sm no-shadow" style="text-transform:capitalize; word-break:break-all;">
                                       <?php if(trim($ordersData['orders_data'][0]->order_information) != '[]' or !empty($ordersData['orders_data'][0]->order_information)): ?>
                                       		<?php echo e($ordersData['orders_data'][0]->order_information); ?>

                                       <?php endif; ?>
                                      </p>
                                    </div>
                                    <!-- /.col -->
                                    <div class="col-xs-6">
                                      <p class="lead">Subtotal</p>
                            
                                      <div class="table-responsive">
                                        <table class="table">
                                          <tbody><tr>
                                            <th style="width:50%">Subtotal:</th>
                                            <td class="text-center"><?php echo e($web_setting[0]->code); ?> <?php echo e($ordersData['subtotal']); ?></td>
                                          </tr>
                                          <tr>
                                            <th>Tax</th>
                                            <td class="text-center"><?php echo e($web_setting[0]->code); ?> <?php echo e($ordersData['orders_data'][0]->total_tax); ?></td>
                                          </tr>
                                          <tr>
                                            <th>Shipping Cost:</th>
                                            <td class="text-center"><?php echo e($web_setting[0]->code); ?> <?php echo e($ordersData['orders_data'][0]->shipping_cost); ?></td>
                                          </tr>
                                          <?php if(!empty($ordersData['orders_data'][0]->coupon_code)): ?>
                                          <tr>
                                            <th>DicountCoupon:</th>
                                            <td class="text-center"> <?php echo e($ordersData['orders_data'][0]->coupon_amount); ?></td>
                                          </tr>
                                          <?php endif; ?>
                                          <tr>
                                            <th>Total:</th>
                                            <td class="text-center"><?php echo e($web_setting[0]->code); ?> <?php echo e($ordersData['total_price']); ?></td>
                                          </tr>
                                        </tbody>
                                        </table>
                                      </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="box-footer">
                                    
                                        <form method="POST" action="<?php echo e(route('order.update',$order->id)); ?>" class="form-horizontal model-form-5f6c9704b9434" accept-charset="UTF-8" enctype="multipart/form-data" pjax-container>
                                            <?php echo e(csrf_field()); ?>

                                            <?php echo e(method_field('PATCH')); ?>

                                          <p class="lead">Change Status:</p>
                                            
                                              <div class="form-group">
                                                <label>Payment Status:</label>
                                                <select class="form-control select2" id="status_id" name="order_status" style="width: 100%;">
                                                    <option value="<?php echo e($ordersData['orders_data'][0]->status); ?>" <?php if( $ordersData['orders_data'][0]->status == 'Pending'): ?> selected <?php endif; ?> >Pending</option>
                                                    <option value="<?php echo e($ordersData['orders_data'][0]->status); ?>" <?php if( $ordersData['orders_data'][0]->status == 'Confirmed'): ?> selected <?php endif; ?> >Confirmed</option>
                                                    <option value="<?php echo e($ordersData['orders_data'][0]->status); ?>" <?php if( $ordersData['orders_data'][0]->status == 'Completed'): ?> selected <?php endif; ?> >Completed</option>
                                                    <option value="<?php echo e($ordersData['orders_data'][0]->status); ?>" <?php if( $ordersData['orders_data'][0]->status == 'Cancelled'): ?> selected <?php endif; ?> >Canceled</option>
                                                </select>
                                              </div>
                                            
                                            
                                               <div class="form-group">
                                                <label>Comments:</label>
                                                <textarea name="comments" class="form-control" id="comments" rows="4"></textarea>
                                                </div>
                                            
                                        <div class="btn-group pull-right">
                                            <button type="submit" class="btn btn-primary">Submit</button>
                                        </div>
                                     
                                        <div class="btn-group pull-left">
                                            <a href="<?php echo e(URL::to('admin/order')); ?>" class="btn btn-default"><i class="fa fa-angle-left"></i> Back</a>
                                        </div>
                                        </form>
                                    
                                </div>
                                <div class="table-responsive no-padding" style="overflow-x:unset;">
                                <p class="lead">Order History</p>
                               <table class="table table-hover grid-table">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Status</th>
                                        <th>Comments</th>
                                    </tr>
                                </thead>
                                <tbody>
                                  <?php $__currentLoopData = $orderHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                							<?php
                								$date = new DateTime($order->date_added);
                								$status_date = $date->format('d-m-Y');
                								print $status_date;
                							?>
                                        </td>
                                        <td>
                                        	<?php if($order->status == 'Pending'): ?>
                                            	<span class="label label-warning">
                                            <?php elseif($order->status == 'Completed'): ?>
                                                <span class="label label-success">
                                            <?php elseif($order->status == 'Cancelled'): ?>
                                                 <span class="label label-danger">
                                            <?php elseif($order->status == 'Confirmed'): ?>
                                                 <span class="label label-primary">
                                            <?php endif; ?>
                                            <?php echo e($order->status); ?>

                                            </span>
                                        </td>
                                        <td style="text-transform: initial;"><?php echo e($order->comments); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                                  </div>
                            </div>
                          
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <?php echo $__env->make('admin.common.toastr', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mawaeedqatar/public_html/resources/views/admin/orders/edit.blade.php ENDPATH**/ ?>