@extends('web.layout') @section('content')
<div class="content" style="transform: none; min-height: 775px;">
				<div class="container-fluid" style="transform: none;">
                 @if(Session::has('message'))
                    <div class="row justify-content-center">
                        <div class="col-md-8"> 
                            <div class="alert alert-dismissible" style="background-color: #ded9cf;">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            <strong>Success!</strong> {{ Session::get('message') }}
                            </div>
                        </div>
                    </div>
                    @endif
					<div class="row" style="transform: none;">
						<div class="col-md-7 col-lg-8">
							<div class="card">
								<div class="card-header" style="background:#fff !important;">
									<h3 class="card-title">@lang('website.Billing Details')</h3>
								</div>
								<div class="card-body">
								
									<!-- Checkout Form -->
									<form action="{{route('web.place_order')}}" method="POST" >
									@csrf
										<!-- Personal Information -->
										<div class="info-widget">
											<h4 class="card-title">@lang('website.Personal Information')</h4>
											<div class="row">
												<div class="col-md-6 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.First Name') *</label>
														<input type="text" class="form-control @error('billing_first_name') is-invalid @enderror" name="billing_first_name" value="{{ Auth::guard('customer')->user()->first_name }}" autocomplete="off" autofocus>
                                                        @error('billing_first_name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
													</div>
												</div>
												<div class="col-md-6 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.Last Name') *</label>
														<input type="text" class="form-control @error('billing_last_name') is-invalid @enderror" name="billing_last_name" value="{{ Auth::guard('customer')->user()->last_name }}" autocomplete="last_name" autofocus>
                                                        @error('billing_last_name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
													</div>
												</div>
												<div class="col-md-6 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.Email') *</label>
														<input  type="email" class="form-control @error('billing_email') is-invalid @enderror" name="billing_email" value="{{ Auth::guard('customer')->user()->email }}" autocomplete="email" autofocus>
                                                        @error('billing_email')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
													</div>
												</div>
												<div class="col-md-6 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.Phone') *</label>
														<input type="text"  class="form-control @error('billing_phone') is-invalid @enderror" name="billing_phone" value="{{ Auth::guard('customer')->user()->phone }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" oninput="javascript: if (this.value.length > 15) this.value = this.value.slice(0, this.maxLength);">
                                                         @error('billing_phone')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                                                    </div>
												</div>
												<div class="col-md-6 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.Country') *</label>
														<select class="form-control @error('billing_country_id') is-invalid @enderror" name="billing_country_id" >
														    <option value="" >@lang('website.Select Country')</option>
														    @foreach($result['countries'] as $country)
														    <option value="{{$country->id}}" @if($country->name == $CurrentCountry) selected @endif>{{$country->name}}</option>
														    @endforeach
														</select>
                                                         @error('billing_country_id')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                                                    </div>
												</div>
												<div class="col-md-6 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.Zone') *</label>
														<select class="form-control @error('billing_zone_id') is-invalid @enderror" name="billing_zone_id">
														    <option value="" >@lang('website.Select Zone')</option>
														    @foreach($result['zones'] as $zone)
														    <option value="{{$zone->id}}" @if(old('billing_zone_id') == $zone->id) selected @endif>{{$zone->name}}</option>
														    @endforeach
														</select>
                                                         @error('billing_zone_id')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                                                    </div>
												</div>
												<div class="col-md-6 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.Streat Address') *</label>
														<input  type="text" class="form-control @error('billing_street_address') is-invalid @enderror" name="billing_street_address" value="{{old('billing_street_address')}}" autocomplete="address" autofocus>
                                                        @error('billing_street_address')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
													</div>
												</div>
												<div class="col-md-6 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.Postcode / ZIP')</label>
														<input type="text"  class="form-control @error('billing_postcode') is-invalid @enderror" name="billing_postcode" value="{{old('billing_postcode')}}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" oninput="javascript: if (this.value.length > 15) this.value = this.value.slice(0, this.maxLength);">
                                                         @error('billing_postcode')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                                                    </div>
												</div>
												<div class="col-md-12 col-sm-12">
    												<div class="form-group card-label">
        												<label>@lang('website.Order notes')</label>
        												<textarea rows="5" class="form-control" name="order_notes" spellcheck="false"></textarea>
    											    </div>
											    </div>
												
											</div>
										</div>
										<!-- /Personal Information -->

										<!-- Shipping Details -->
										<div class="info-widget">
											<h4 class="card-title">@lang('website.Shipping Details')</h4>
											<div class="terms-accept">
												<div class="custom-checkbox">
												   <input type="checkbox" name="shipping" value="Yes" id="different-shipping">
												   <label for="terms_accept">@lang('website.Ship to a different address?')</label>
												</div>
											</div>
											<div class="row show-different-shipping" style="display:none;">
												<div class="col-md-4 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.First Name') *</label>
														<input type="text" class="form-control @error('delivery_first_name') is-invalid @enderror" name="delivery_first_name" value="" autocomplete="off" autofocus>
                                                        @error('delivery_first_name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
													</div>
												</div>
												<div class="col-md-4 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.Last Name') *</label>
														<input type="text" class="form-control @error('delivery_last_name') is-invalid @enderror" name="delivery_last_name" value="" autocomplete="last_name" autofocus>
                                                        @error('delivery_last_name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
													</div>
												</div>
											
												<div class="col-md-4 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.Phone') *</label>
														<input type="text"  class="form-control @error('delivery_phone') is-invalid @enderror" name="delivery_phone" value="" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" oninput="javascript: if (this.value.length > 15) this.value = this.value.slice(0, this.maxLength);">
                                                         @error('delivery_phone')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                                                    </div>
												</div>
												<div class="col-md-6 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.Country') *</label>
														<select class="form-control @error('delivery_country_id') is-invalid @enderror" name="delivery_country_id">
														    <option value="" >@lang('website.Select Country')</option>
														    @foreach($result['countries'] as $country)
														    <option value="{{$country->id}}" @if($country->name == $CurrentCountry) selected @endif>{{$country->name}}</option>
														    @endforeach
														</select>
                                                         @error('delivery_country_id')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                                                    </div>
												</div>
												<div class="col-md-6 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.Zone') *</label>
														<select class="form-control @error('delivery_zone_id') is-invalid @enderror" name="delivery_zone_id">
														    <option value="" >@lang('website.Select Zone')</option>
														    @foreach($result['zones'] as $zone)
														    <option value="{{$zone->id}}" @if(old('delivery_zone_id') == $zone->id) selected @endif>{{$zone->name}}</option>
														    @endforeach
														</select>
                                                         @error('delivery_zone_id')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                                                    </div>
												</div>
												<div class="col-md-6 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.Streat Address') *</label>
														<input  type="text" class="form-control @error('delivery_street_address') is-invalid @enderror" name="delivery_street_address" value="" autocomplete="address" autofocus>
                                                        @error('delivery_street_address')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
													</div>
												</div>
												<div class="col-md-6 col-sm-12">
													<div class="form-group card-label">
														<label>@lang('website.Postcode / ZIP')</label>
														<input type="text"  class="form-control @error('shipping_postcode') is-invalid @enderror" name="shipping_postcode" value="" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" oninput="javascript: if (this.value.length > 15) this.value = this.value.slice(0, this.maxLength);">
                                                         @error('shipping_postcode')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                                                    </div>
												</div>
											  
											</div>
											
										</div>
										<!-- /Shipping Details -->
										
										<div class="payment-widget">
											<h4 class="card-title">@lang('website.Payment Method')</h4>
											@foreach($payment_methods as $payment_method)
                                                <input id="payment_currency" type="hidden" onClick="paymentMethods();" name="payment_currency" value="{{$payment_method->currency}}">
                                                <input id="{{$payment_method->payment_method}}_public_key" type="hidden" name="public_key" value="{{$payment_method->public_key}}">
                                                <input id="{{$payment_method->payment_method}}_environment" type="hidden" name="{{$payment_method->payment_method}}_environment" value="{{$payment_method->environment}}">
                                                <input id="payment_currency_value_in_usd" type="hidden" name="payment_currency_value_in_usd" value="{{$currValue}}">
                                                
                                                    <div class="payment-list">
    											    <label class="payment-radio credit-card-option">
    													<input type="radio" name="payment_method" onClick="paymentMethods();" id="{{$payment_method->payment_method}}_label" value="{{$payment_method->payment_method}}" class="payment_method" required>
    													<span class="checkmark"></span>
    													{{$payment_method->name}}
    												</label>
    											    </div>
                                         
                                            @endforeach 
										    <!-- Terms Accept -->
											<div class="terms-accept">
												<div class="custom-checkbox">
												   <input type="checkbox" id="terms_accept" required>
												   <label for="terms_accept1">@lang('website.I have read and accept') <a href="{{URL::to('/page?name=Terms-and-Conditions')}}" target="_blank">@lang('website.Terms & Conditions')</a></label>
												</div>
											</div>
											<!-- /Terms Accept -->
											
											<!-- Submit Section -->
											<div class="submit-section mt-4">
											    <div id="paypal_button" class="payment_btns" style="display: none"></div>
												<button type="submit" id="cash_on_delivery_button" class="btn btn-primary submit-btn pay-button" style="display: none">@lang('website.Order Now')</button>
												<button type="submit" id="self_pickup_button" class="btn btn-primary submit-btn pay-button" style="display: none">@lang('website.Order Now')</button>
											</div>
											<!-- /Submit Section -->
											
										</div>
									</form>
									<!-- /Checkout Form -->
									
								</div>
							</div>
							
						</div>
						
						<div class="col-md-5 col-lg-4 theiaStickySidebar" style="position: relative; overflow: visible; box-sizing: border-box; min-height: 1px;">
						
							<!-- Booking Summary -->
							
							<!-- /Booking Summary -->
							
						<div class="theiaStickySidebar" style="padding-top: 0px; padding-bottom: 1px; position: static; transform: none; left: 1011.5px; top: 0px;">
						    <div class="card booking-card" style="border:none;box-shadow: 0 0 30px rgb(0 0 0 / 20%);border-radius: 10px;">
								<div class="card-header" style="background: #fff !important;">
									<h3 class="card-title text-center">@lang('website.Summary')</h3>
								</div>
								<div class="card-body">
									<div class="table-responsive" style="font-size:14px;">
										<table class="table table-center mb-0">
										    <tbody><tr>
												<th>@lang('website.Product')</th>
												<th>@lang('website.Quantity')</th>
											    <th></th>
												<th class="text-right">@lang('website.Total')</th>
											</tr>
											</tbody>
										
											<tbody>
											    <?php $price = 0; ?>
											     @foreach( $result['cart'] as $products)
                                               <?php
                                                  $orignal_price = $products->final_price;
                                                  $price+= ($orignal_price * $products->basket_quantity) + ($products->basket_quantity * $products->gift_price) ;
                                               ?>
												<tr>
													<td>{{$products->name}}<br>
													    <div class="item-attributes">
                                                        @if(isset($products->attributes))
                                                          @foreach($products->attributes as $attributes)
                                                            <small>{{$attributes->attribute_name}} : {{$attributes->attribute_value}}</small>
                                                          @endforeach
                                                        @endif
                                                      </div>
													</td>
													<td class="text-center">{{$products->basket_quantity}}</td>
													<td>
													@if($products->gift_id>0)
													<span style="font-size: 10px;color: #bb7a5c;width: 100%;display: inline-block;">@lang('website.Gift Price')</span>{{$web_setting[0]->code}} {{$products->gift_price+0}}
													@endif
													</td>
													<td class="text-right">{{$web_setting[0]->code}} {{($orignal_price * $products->basket_quantity) + ($products->basket_quantity * $products->gift_price)}}</td>
												</tr>
								
												@endforeach
											</tbody>
										</table>
									</div>
									                <?php
                                                      if(!empty(session('coupon_discount'))){
                                                        $coupon_amount = session('currency_value') * session('coupon_discount');  
                                                      }else{
                                                        $coupon_amount = 0;
                                                      }

                                                      if(!empty(session('tax_rate'))){
                                                        $tax_rate = session('tax_rate');  
                                                      }else{
                                                        $tax_rate = 0;
                                                      }

                                                       if(!empty(session('shipping_detail')) and !empty(session('shipping_detail'))>0){
                                                           $shipping_price = session('shipping_detail')->shipping_price;
                                                           $shipping_name = session('shipping_detail')->mehtod_name;
                                                       }else{
                                                           $shipping_price = 0;
                                                           $shipping_name = '';
                                                       }

                                                      // dd($price,$tax_rate,$shipping_price);
                                                       $tax_rate = number_format((float)$tax_rate, 2, '.', '');
                                                       $coupon_discount = number_format((float)$coupon_amount, 2, '.', '');
                                                       $total_price = ($price+$tax_rate+($shipping_price)) - $coupon_discount;
                                                       session(['total_price'=>($total_price)]);

                                                    ?>
									<div class="booking-summary pt-5">
										<div class="booking-item-wrap">
											<ul class="booking-date">
												<li>@lang('website.Subtotal') <span>{{$web_setting[0]->code}} {{number_format((float)$price+0, 2, '.', '')}}</span></li>
												<li>@lang('website.Shipping Cost') <span>{{$web_setting[0]->code}} {{ number_format((float)$shipping_price+0, 2, '.', '')}}</span></li><br>
												<li>@lang('website.Discount') <span>{{$web_setting[0]->code}} {{number_format((float)$coupon_discount, 2, '.', '')+0}}<span></li>
											</ul>
										    <div class="booking-total">
												<ul class="booking-total-list">
													<li>
														<span>@lang('website.Total')</span>
														<span class="total-cost">{{$web_setting[0]->code}} {{number_format((float)$total_price+0, 2, '.', '')+0}}</span>
													</li>
												</ul>
											</div>
										</div>
									</div>
								</div>
							</div><div class="resize-sensor" style="position: absolute; inset: 0px; overflow: hidden; z-index: -1; visibility: hidden;"><div class="resize-sensor-expand" style="position: absolute; left: 0; top: 0; right: 0; bottom: 0; overflow: hidden; z-index: -1; visibility: hidden;"><div style="position: absolute; left: 0px; top: 0px; transition: all 0s ease 0s; width: 485px; height: 1121px;"></div></div><div class="resize-sensor-shrink" style="position: absolute; left: 0; top: 0; right: 0; bottom: 0; overflow: hidden; z-index: -1; visibility: hidden;"><div style="position: absolute; left: 0; top: 0; transition: 0s; width: 200%; height: 200%"></div></div></div></div></div>
					</div>

				</div>

			</div>
@endsection