@extends('auth.app')
@section('content')
<div class="login-box">
    <div class="login-logo">
        <a href="{{route('login')}}"><b>{{ config('app.name') }} Admin</b></a>
    </div>
    <!-- /.login-logo -->
    <div class="login-box-body">
        <p class="login-box-msg">{{ __('E-Mail Address') }}</p>
        @if (session('status'))
            <div class="alert alert-success" role="alert">
                {{ session('status') }}
            </div>
        @endif
        <form method="POST" action="{{ route('password.email') }}">
            {{ csrf_field() }}
            <div class="form-group  @error('email') has-error @enderror">
            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" autocomplete="email" autofocus>
                <span class="glyphicon glyphicon-envelope form-control-feedback"></span> @error('email')
                <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span>@enderror
            </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary btn-block btn-flat">{{ __('Send Password Reset Link') }}</button>
                </div>
        </form>
        <div class="row">
            <div class="col-md-12 text-center">
                <a href="{{ route('login') }}">Back</a>
            </div>
        </div>
    </div>
    <!-- /.login-box-body -->
</div>
@endsection
