@extends('auth.app') @section('content')
<div class="login-box">
    <div class="login-logo">
        <a href="{{route('login')}}"><b>{{ __('Welcome') }}</b>To Admin Panel</a>
    </div>
    <!-- /.login-logo -->
    <div class="login-box-body">
        <p class="login-box-msg">Login to ttart your session</p>
        @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade in" style="padding: 8px;margin-bottom:10px;">
        {{ session('error') }}
        </div>
        @endif
        <form action="{{ route('login') }}" method="POST">
            {{ csrf_field() }}
            <div class="form-group  @error('email') has-error @enderror">
                <lable>Email Address</lable>
                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" autocomplete="email" autofocus>
                <span class="glyphicon glyphicon-envelope form-control-feedback"></span> @error('email')
                <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span>@enderror
            </div>
            <div class="form-group @error('password') has-error @enderror">
                 <lable>Password</lable>
                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" autocomplete="current-password">
                <span class="glyphicon glyphicon-lock form-control-feedback"></span> @error('password')
                <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span>@enderror
            </div>
            <div class="row">
                <div class="col-xs-8">
                    <div class="checkbox icheck">
                        <label>
                                <input type="checkbox" name="remember" value="1" {{ old('remember') ? 'checked' : '' }} >
                                {{ __('Remember Me') }}
                            </label>
                    </div>
                </div>
                <!-- /.col -->
                <div class="col-xs-4">

                    <button type="submit" class="btn btn-primary btn-block btn-flat">Login</button>
                </div>
                <!-- /.col -->
            </div>
        </form>
        <div class="row">
            <div class="col-md-12 text-center">
                <a href="{{ route('password.request') }}">Fotgot your password ?</a>
            </div>
        </div>
    </div>
    <!-- /.login-box-body -->
</div>
<!-- /.login-box -->
@endsection