@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Administrator<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>Auth</li><li>Users</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="#" target="_blank" class="btn btn-sm btn-twitter" title="Export"><i
                                            class="fa fa-download"></i><span class="hidden-xs"> Export</span></a>
                                    <button type="button" class="btn btn-sm btn-twitter dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" target="_blank">All</a></li>
                                        <li><a href="#" target="_blank">Current page</a></li>
                                        <li><a href="#" target="_blank" class="export-selected">Selected rows</a></li>
                                    </ul>
                                </div>
                                @canany(['user.create','all'])
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a href="{{ route('user.create') }}" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                                @endcanany

                            </div>
                            @canany(['user.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{ url('public/admin/user') }}"  class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                       <!-- /.box-header -->
                        <div class="box-body table-responsive">
                            <table class="table table-hover grid-table" id="example">
                                <thead>
                                    <tr>
                                        @canany(['user.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th class="column-id">ID</th>
                                        <th class="column-username">Image</th>
                                        <th class="column-name">Name</th>
                                        <th class="column-email">Email</th>
                                        <th class="column-roles">Roles</th>
                                        <th class="column-created_at">Created At</th>
                                        <th class="column-updated_at">Updated At</th>
                                        @canany(['user.edit','all'])
                                        <th class="column-__actions__">Status</th>
                                        @endcanany
                                        @canany(['user.destroy','user.edit','all'])
                                        <th class="column-__actions__">Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($users as  $user)
                                    <tr data-key="{{ $user->id }}">
                                        @canany(['user.destroy','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{ $user->id }}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td class="column-id">{{ $user->id }}</td>
                                        <td class="column-username"><img src="{{asset('').$user->image}}" width="50px"></td>
                                        <td class="column-name">{{ $user->first_name }} {{ $user->last_name }}</td>
                                        <td class="column-name">{{ $user->email }}</td>
                                        <td class="column-roles">
                                        @foreach($user->roles as  $roles)
                                            <span class="label label-success"> {{ $roles->name }}</span>
                                        @endforeach
                                        </td>
                                        <td class="column-created_at">{{ date('Y-m-d',strtotime($user->created_at)) }}</td>
                                        <td class="column-updated_at">{{ date('Y-m-d',strtotime($user->updated_at)) }}</td>
                                        @canany(['user.edit','all'])
                                        <td class="column-updated_at">
                                            <div class="status-toggle"> 
                                                <input type="checkbox" route="{{ route('user.adminStatus') }}" id="{{ $user->id }}" class="check"  value="{{ $user->id }}" @if($user->status=='Active') checked @endif>
                                                <label for="{{ $user->id }}" class="checktoggle change_status">checkbox</label>
                                            </div>                                      
                                        </td>
                                       @endcanany
                                        @canany(['user.destroy','user.edit','all'])
                                        <td class="column-__actions__">
                                            @canany(['user.destroy','all'])
                                            <a href="{{ route('user.edit',$user->id) }}"><i class="fa fa-edit"></i></a>&nbsp;
                                            @endcanany
                                            @canany(['user.destroy','all'])
                                            
                                            <a data-id="{{ $user->id }}" href="#" route="{{ route('user.destroy',$user->id) }}" class="grid-batch-0"><i class="fa fa-trash label-danger"></i></a>
                                            @endcanany
                                        </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>                  
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection