@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Backup Databse<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li> Database Backup</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a id="create-new-backup-button" href="{{ url(config('backpack.base.route_prefix', 'admin').'/backup/create') }}" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                            </div>
                            @canany(['user.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{ url('/public/admin/databse') }}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover  grid-table" id="example">
                                <thead>
                                    <tr>
                                        @canany(['user.index','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th>ID</th>
                                        <th>Location</th>
                                        <th>Date</th>
                                        <th>File Size</th>
                                       
                                        <th>Action</th>
                                        
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach ($backups as $k => $b)
                                    <tr data-key="">
                                    
                                        <td class="column-__row_selector__"><input type="checkbox" class="grid-row-checkbox" data-id="" style="position: absolute; opacity: 0;"></td>
                                    
                                        <td>{{ $k+1 }}</td>
                                        <td>{{ $b['disk'] }}</td>
                                        <td>{{ \Carbon\Carbon::createFromTimeStamp($b['last_modified'])->formatLocalized('%d %B %Y, %H:%M') }}</td>
                                        <td>{{ round((int)$b['file_size']/1048576, 2).' MB' }}</td>
                                   
                                        <td class="column-__actions__">
                                            @if ($b['download'])
                                            <a class="btn btn-sm btn-link" href="{{ url(config('backpack.base.route_prefix', 'admin').'/backup/download/') }}?disk={{ $b['disk'] }}&path={{ urlencode($b['file_path']) }}&file_name={{ urlencode($b['file_name']) }}"><i class="la la-cloud-download"></i> {{ trans('backpack::backup.download') }}</a>
                                            @endif
                                            <a class="btn btn-sm btn-link" data-button-type="delete" href="{{ url(config('backpack.base.route_prefix', 'admin').'/backup/delete/'.$b['file_name']) }}?disk={{ $b['disk'] }}"><i class="la la-trash-o"></i> {{ trans('backpack::backup.delete') }}</a>
                                        
                                            {{-- <a href="{{ route('user.index') }}"><i class="fa fa-edit"></i></a>&nbsp;
                                            <a data-id="" route="{{ route('user.index') }}" href="#" class="grid-batch-0"><i class="fa fa-trash label-danger"></i></a> --}}
                                        </td>
                                  
                                    </tr>
                            @endforeach   
                                </tbody>
                            </table>
                        </div> 
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
    <script>
        jQuery(document).ready(function($) {
      
          // capture the Create new backup button
          $("#create-new-backup-button").click(function(e) {
              e.preventDefault();
              var create_backup_url = $(this).attr('href');
      
              // do the backup through ajax
              $.ajax({
                  url: create_backup_url,
                  type: 'PUT',
                  success: function(result) {
                      // Show an alert with the result
                      if (result.indexOf('failed') >= 0) {
                          new Noty({
                              text: "<strong>{{ trans('backpack::backup.create_warning_title') }}</strong><br>{{ trans('backpack::backup.create_warning_message') }}",
                              type: "warning"
                          }).show();
                      }
                      else
                      {
                          new Noty({
                              text: "<strong>{{ trans('backpack::backup.create_confirmation_title') }}</strong><br>{{ trans('backpack::backup.create_confirmation_message') }}",
                              type: "success"
                          }).show();
                      }
                  },
                  error: function(result) {
                      // Show an alert with the result
                      new Noty({
                          text: "<strong>{{ trans('backpack::backup.create_error_title') }}</strong><br>{{ trans('backpack::backup.create_error_message') }}",
                          type: "warning"
                      }).show();
                  }
              });
          });
      
          // capture the delete button
          $("[data-button-type=delete]").click(function(e) {
              e.preventDefault();
              var delete_button = $(this);
              var delete_url = $(this).attr('href');
      
              if (confirm("{{ trans('backpack::backup.delete_confirm') }}") == true) {
                  $.ajax({
                      url: delete_url,
                      type: 'DELETE',
                      success: function(result) {
                          // Show an alert with the result
                          new Noty({
                              text: "<strong>{{ trans('backpack::backup.delete_confirmation_title') }}</strong><br>{{ trans('backpack::backup.delete_confirmation_message') }}",
                              type: "success"
                          }).show();
                          // delete the row from the table
                          delete_button.parentsUntil('tr').parent().remove();
                      },
                      error: function(result) {
                          // Show an alert with the result
                          new Noty({
                              text: "<strong>{{ trans('backpack::backup.delete_error_title') }}</strong><br>{{ trans('backpack::backup.delete_error_message') }}",
                              type: "warning"
                          }).show();
                      }
                  });
              } else {
                  new Noty({
                      text: "<strong>{{ trans('backpack::backup.delete_cancel_title') }}</strong><br>{{ trans('backpack::backup.delete_cancel_message') }}",
                      type: "info"
                  }).show();
              }
            });
      
        });
      </script>
</div>

@endsection