@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 474px;">
    <style type="text/css"></style>
    <div id="app" class=" ">
        <section class="content-header">
            <h1>
                Administrator
                <small>Create</small>
            </h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>
                    Auth
                </li>
                <li>
                    Users
                </li>
                <li>
                    Create
                </li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Create</h3>
                            <div class="box-tools">
                                <div class="btn-group pull-right" style="margin-right: 5px">
                                    <a href="{{ route('user.store') }}" class="btn btn-sm btn-default" title="List"><i class="fa fa-list"></i><span
                                            class="hidden-xs">&nbsp;List</span></a>
                                </div>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form action="{{ route('user.store') }}" method="post" class="form-horizontal model-form-5f6c9704b9434" accept-charset="UTF-8" enctype="multipart/form-data" pjax-container>
                            {{ csrf_field() }}
                            <div class="box-body">
                                <div class="fields-group">
                                    <div class="col-md-12">
                                        <div class="form-group  @error('first_name') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">First Name</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" id="first_name" name="first_name" class="form-control" placeholder="Input First Name" value="{{ old('first_name') }}" autocomplete="name" autofocus>
                                                </div>
                                                @error('first_name') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('last_name') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">First Name</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" id="last_name" name="last_name" class="form-control" placeholder="Input Last Name" value="{{ old('last_name') }}" autocomplete="off" autofocus>
                                                </div>
                                                @error('last_name') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group @error('email') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">Email</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-envelope fa-fw"></i></span>
                                                    <input type="email" id="email" name="email" value="{{ old('email') }}" class="form-control email" placeholder="Input Email">
                                                </div>
                                                @error('email')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group @error('phone') has-error @enderror">
                                            <label for="name" class="col-sm-2 control-label">Phone</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-phone fa-fw"></i></span>
                                                    <input type="tel" class="form-control" placeholder="Phone" id="phone" value="{{ old('phone') }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57">
                                                </div>
                                                @error('phone')<span class=" invalid-feedback" role="alert "><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group @error( 'gender') has-error @enderror">
                                            <label for="name " class="col-sm-2 control-label ">Gender</label>
                                            <div class="col-sm-8 ">
                                                <div class="input-group ">
                                                    <label class=" control-label ">
                                                        <input type="radio" name="gender" value="Male" class="radio" > Male
                                                    </label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                    <label class=" control-label ">
                                                        <input type="radio" name="gender" value="Female" class="radio"> Female
                                                    </label>
                                                </div>
                                                @error('gender')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="name" class="col-sm-2 control-label">Venor</label>
                                            <div class="col-sm-8 ">
                                                <div class="input-group ">
                                                   <label class=" control-label">
                                                        <input type="checkbox" name="vendor" value="Yes" class="radio"> User will become a vendor, Assign role as Vendor
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group @error( 'dob') has-error @enderror">
                                            <label for="name " class="col-sm-2 control-label ">DOB</label>
                                            <div class="col-sm-8 ">
                                                <div class="input-group ">
                                                    <span class="input-group-addon"><i class="fa fa-calendar fa-fw "></i></span>
                                                    <input type="text" id="dob" name="dob" placeholder="Date of birth" value="{{ old('dob') }}" class="form-control dob-datepicker" readonly>
                                                </div>
                                                @error('dob')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  ">
                                            <label for="avatar" class="col-sm-2  control-label">Avatar</label>
                                            <div class="col-sm-8">
                                                <div class="file-input">
                                                    <div class="kv-upload-progress kv-hidden"></div>
                                                    <div class="clearfix"></div>
                                                    <div class="input-group file-caption-main">
                                                        <div class="input-group-btn input-group-append">
                                                            <input type="file" class="avatar" name="image" data-initial-preview="" data-initial-caption="" id="1600892307492_72">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="password" class="col-sm-2 control-label"></label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <label class=" control-label ">
                                                        <input type="checkbox" id="checkbox" name="change_password" value="yes" null > &nbsp;{{ __('Change Password ?') }}
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group  @error('password') has-error @enderror">
                                            <label for="password" class="col-sm-2 asterisk control-label">Password</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i
                                                            class="fa fa-eye-slash fa-fw"></i></span>
                                                    <input type="password" id="password" name="password" value="" class="form-control password" placeholder="Input Password" autocomplete="off">
                                                </div>
                                                @error('password')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  ">
                                            <label for="password_confirmation" class="col-sm-2 asterisk control-label">Password confirmation</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i
                                                            class="fa fa-eye-slash fa-fw"></i></span>
                                                    <input type="password" id="password_confirmation" name="password_confirmation" value="" class="form-control password_confirmation" placeholder="Input Password confirmation" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group @error('role_id') has-error @enderror ">
                                            <label for="roles" class="col-sm-2  control-label ">Roles</label>
                                            <div class="col-sm-8">
                                                <select class="form-control roles select2" name="role_id[]" multiple="true">
                                                    @if(count($roles)>0)
                                                    @foreach($roles as $role)
                                                    <option value="{{ $role->id }}">{{ $role->name }}</option>
                                                    @endforeach
                                                    @endif                                                 
                                                </select> @error('role_id')
                                                <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <div class="col-md-2">
                                </div>
                                <div class="col-md-8">
                                    <div class="btn-group pull-right">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>

                                    <div class="btn-group pull-left">
                                        <button type="reset" class="btn btn-warning">Reset</button>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-footer -->
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection