@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 474px;">
    <style type="text/css"></style>
    <div id="app" class=" ">
        <section class="content-header">
            <h1>
                Administrator
                <small>Update</small>
            </h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>
                    Auth
                </li>
                <li>
                    Slider
                </li>
                <li>
                    Update
                </li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Update</h3>
                            
                                <div class="btn-group pull-right" style="margin-right: 5px">
                                    <a href="{{ route('slider.index') }}" class="btn btn-sm btn-default" title="List"><i class="fa fa-list"></i><span
                                            class="hidden-xs">&nbsp;List</span></a>
                                </div>
                            
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form action="{{ route('slider.update',$slider->id) }}" method="post" class="form-horizontal model-form-5f6c9704b9434" accept-charset="UTF-8" enctype="multipart/form-data" pjax-container>
                        {{ csrf_field() }}
                        {{ method_field('PATCH') }}
                            <div class="box-body">
                                <div class="fields-group">
                                    <div class="col-md-12">
                                        <div class="form-group  @error('language_id') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">Language</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select class="form-control select2" name="language_id">
                                                        @foreach($languages as $language)
                                                        <option value="{{$language->code}}" @if($language->code == $slider->language_id) selected @endif>{{$language->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group  @error('title') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">Title</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="title" value="{{$slider->title}}" class="form-control">
                                                </div>
                                                @error('title') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('type') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">Slider Navigation</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select class="form-control select2" name="type" id="bannerType">
                                                        <option value="Category" @if($slider->type =='Category')selected @endif>Category</option>
                                                        <option value="Product" @if($slider->type =='Product')selected @endif>Product</option>
                                                        <option value="TopSeller" @if($slider->type =='TopSeller')selected @endif>Top Seller</option>
                                                        <option value="Special" @if($slider->type =='Special')selected @endif>Deals</option>
                                                        <option value="MostLiked" @if($slider->type =='MostLiked')selected @endif>Most Liked</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group @error('expires_date') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">Expiry Date</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-calendar fa-fw"></i></span>
                                                    <input type="text" name="expires_date" placeholder="Expiry Date" value="{{ date('Y-m-d',strtotime($slider->expires_date)) }}" class="form-control datepicker" readonly>
                                                </div>
                                                @error('expires_date')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('image') has-error @enderror">
                                            <label for="avatar" class="col-sm-2  control-label">Image</label>
                                            <div class="col-sm-8">
                                                <div class="input-group-btn input-group-append">
                                                    <input type="file" class="avatar" name="image" data-initial-preview="{{asset('').'/'.$slider->image }}" data-initial-caption="{{ $slider->image }}" id="1600892307492_72"> 
                                                </div>
                                                @error('image') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="avatar" class="col-sm-2  control-label"></label>
                                            <div class="col-sm-8">
                                                <img src="{{asset('').$slider->image}}" width="200px" alt="">
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <div class="col-md-2">
                                </div>
                                <div class="col-md-8">
                                    <div class="btn-group pull-right">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                 
                                    <div class="btn-group pull-left">
                                        <button type="reset" class="btn btn-warning">Reset</button>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-footer -->
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection