@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Add Options<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li>Add Options</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
          
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                
                                @canany(['product.create','all'])
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#addAttributeModal">
                                    <i class="fa fa-plus"></i> Add Option
                                </button>
                                 
                                </div>
                                @endcanany
                            </div>
                            @canany(['product.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{URL::to('admin/product/productAditionalAttributeDestroy')}}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover grid-table" id="example1">
                                <thead>
                                    <tr>
                                        @canany(['product.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                       <th>ID</th>
                                        <th>Option Name</th>
                                        <th>Option Value</th>
                                        <th>Price</th>
                                        <th>Default</th>
                                        @canany(['product.destroy','product.edit','all'])
                                        <th>Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody class="contentAttribute">
                                    @if (count($products_attributes) > 0)
                                        @foreach($products_attributes as $key=>$products_attribute)
                                            
                                    <tr data-key="{{ $products_attribute->product_id }}">
                                        @canany(['product.destroy','product.edit','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{ $products_attribute->products_attributes_id }}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td>{{ ++$key }}</td>
                                        <td>{{ $products_attribute->option_name }}</td>
                                        <td>{{ $products_attribute->option_value_name }}</td>
                                        <td>{{ $products_attribute->price_prefix }}{{ $products_attribute->option_value_price }}</td>
                                        <td class="column-updated_at">
                                            <div class="status-toggle"> 
                                                <input type="checkbox" route="{{ route('product.defaultOption') }}" id="{{ $products_attribute->products_attributes_id }}" class="check"  product_id="{{$product_id}}" option_id="{{$products_attribute->option_id}}" value="{{ $products_attribute->products_attributes_id }}" @if($products_attribute->is_default=='Yes') checked @endif>
                                                <label for="{{ $products_attribute->products_attributes_id }}" class="checktoggle defaultOption">checkbox</label>
                                            </div>                                      
                                        </td>
                                       @canany(['product.destroy','product.edit','all'])
                                        <td class="column-__actions__">
                                            <a class="badge bg-light-blue editproductattributemodal" product_id="{{ $products_attribute->product_id }}" products_attributes_id="{{ $products_attribute->products_attributes_id }}"  option_id ="{{ $products_attribute->option_id }}" ><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
                                            <a class="badge bg-red grid-batch-0" data-id="{{ $products_attribute->products_attributes_id }}" route="{{URL::to('admin/product/productAditionalAttributeDestroy')}}/{{$products_attribute->product_id}}/{{$products_attribute->products_attributes_id}}" href="#" ><i class="fa fa-trash " aria-hidden="true"></i></a>
                                        </td>
                                        @endcanany
                                    </tr>
                                    
                                    @endforeach
                                     @else
                                            <tr><td colspan="7" class="text-center"><strong>No Record Found Text For Additional Option</strong></td></tr>
                                        @endif
                                </tbody>
                            </table>
                            <!-- addAttributeModal -->
                                    <div class="modal fade" id="addAttributeModal" tabindex="-1" role="dialog" aria-labelledby="addAttributeModalLabel">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                                    <h4 class="modal-title" id="addAttributeModalLabel">Add Options</h4>
                                                <form action="{{URL::to('admin/product/productAditionalAttribute')}}" name="addattributefrom" id="addattributefrom" method="post" class="form-horizontal form-validate" enctype="multipart/form-data">
                                                <input type="hidden" name="product_id"  value="{{$product_id}}" id="product_id">
                                                <input type="hidden" name="subcategory_id"  value="{{$subcategory_id}}" id="subcategory_id">
                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <label for="name" class="col-sm-2 col-md-4 control-label">Option Name  </label>
                                                        <div class="col-sm-10 col-md-8">
                                                            <select class="form-control  additional-option-id field-validate" name="option_id">										 									  
                                                            <option value="" class="field-validate">Choose Options</option>
                                                                @foreach($options as $option)
                                                                    <option value="{{ $option->option_id }}">{{ $option->option_name }}</option>
                                                                @endforeach
                                                            </select>  
                                                            <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">Please add options name from Product Option inside of Product menu in case of empty options.</span>
                                                        </div>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="name" class="col-sm-2 col-md-4 control-label">Option Values</label>
                                                        <div class="col-sm-10 col-md-8">
                                                            <select class="form-control additional_products_options_values_id field-validate" name="option_value_id">
                                                            </select>
                                                            <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">Choose value for product option.</span>
                                                        </div>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="name" class="col-xs-12 col-sm-2 col-md-4 control-label">Price</label>
                                                        <div class="col-xs-4 col-sm-2">
                                                            <select class="form-control" name="price_prefix" id="price_prefix">
                                                                <option value="+">+</option>
                                                                <option value="-">-</option>
                                                            </select>
                                                        </div>
                                                        <div class="col-xs-8 col-sm-8 col-md-6">
                                                            <input type="text" name="option_value_price"  value="0" class="form-control" id="option_value_price" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57">
                                                            <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">Please enter numeric value only.</span>
                                                        </div>
                                                    </div>
                                                    </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                                    <button type="button" class="btn btn-primary" id="addAttribute">Add Option</button>
                                                </div>
                                               </form>
                                            </div>
                                        </div>
                                    </div>
</div>
                                    <!-- editproductattributemodal -->
                                    <div class="modal fade" id="editproductattributemodal" tabindex="-1" role="dialog" aria-labelledby="editproductattributemodalLabel">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content editContent">

                                            </div>
                                        </div>
                                    </div>
                                    
                                   <div class="box-footer text-center">
                                <a href="{{route('product.index')}}" class="btn btn-default pull-left"><i class="fa fa-angle-left"></i> Back </a>
                                
                            </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
        
    </div>
    </div>
    @include('admin.common.toastr')
</div>
@endsection