@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Products Images<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li>Products</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="{{route('product.index')}}" class="btn btn-sm btn-twitter" title="Export"><span class="hidden-xs"> Back</span></a>
                                    
                                   
                                </div>
                                @canany(['product.create','all'])
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a href="{{URL::to('admin/product/createImage')}}/{{$product_id}}" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                                @endcanany
                            </div>
                            @canany(['product.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{URL::to('admin/product/destroyImage')}}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover grid-table" id="example">
                                <thead>
                                    <tr>
                                        @canany(['product.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th>ID</th>
                                        <th>Image</th>
                                        <th>Description</th>
                                        @canany(['product.edit','all'])
                                        <th>Status</th>
                                        @endcan
                                        @canany(['product.destroy','product.edit','all'])
                                        <th>Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($images as $image)
                                    <tr data-key="{{ $image->id }}">
                                        @canany(['product.destroy','product.edit','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{ $image->id }}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td>{{ $image->id }}</td>
                                        <td><img src="{{asset('').$image->image}}" width="100px" alt=""></td>
                                       <td>{{$image->htmlcontent}}</td>
                                         @canany(['user.edit','all'])
                                        <td class="column-updated_at">
                                            <div class="status-toggle"> 
                                                <input type="checkbox" route="{{ route('product.statusImage') }}" id="{{ $image->id }}" class="check"  value="{{ $image->id }}" @if($image->status=='Active') checked @endif>
                                                <label for="{{ $image->id }}" class="checktoggle change_status">checkbox</label>
                                            </div>                                      
                                        </td>
                                       @endcanany
                                        @canany(['product.destroy','product.edit','all'])
                                        <td class="column-__actions__">
                                            @canany(['product.edit','all'])
                                            <a href="{{URL::to('admin/product/editImage')}}/{{$image->id}}"><i class="fa fa-edit" style="font-size: 20px;"></i></a>&nbsp;
                                            @endcan
                                            @canany(['product.destroy','all'])
                                            <a data-id="{{ $image->id }}" route="{{URL::to('admin/product/destroyImage')}}/{{$image->id}}" href="#" class="grid-batch-0"><i class="fa fa-trash label-danger" style="color:red;font-size: 20px;"></i></a>
                                             @endcanany
                                        </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>

@endsection