@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 474px;">
    <style type="text/css"></style>
    <div id="app" class=" ">
        <section class="content-header">
            <h1>
                Products
                <small>Create</small>
            </h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>Auth</li>
                <li>Products</li>
                <li>Create</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Create</h3>
                            
                                <div class="btn-group pull-right" style="margin-right: 5px">
                                    <a href="{{ route('product.index') }}" class="btn btn-sm btn-default" title="List"><i class="fa fa-list"></i><span class="hidden-xs">&nbsp;List</span></a>
                                </div>
                            
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form action="{{ route('product.store') }}" method="POST" class="form-horizontal form-validate model-form-5f6c9704b9434" accept-charset="UTF-8" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="box-body">
                                <div class="fields-group">
                                    <div class="col-md-6">
                                        <div class="form-group @error('type') has-error @enderror">
                                            <label for="name" class="control-label">Product Type</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select class="form-control" name="type">
                                                        <option value="Simple">Simple</option>
                                                        <option value="Variable">Variable</option>
                                                        <option value="External">External</option>
                                                    </select>
                                                </div>
                                                @error('type') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        </div>
                                        <div class="form-group  @error('categories') has-error @enderror">
                                            <label for="name" class="asterisk control-label">Categories</label> 
                                            <ul class="list-group list-group-root well">    
                                            @foreach ($categories as $category)                                    
                                            <li class="list-group-item">
                                                <label>
                                                    <input id="categories_<?=$category->id?>" type="checkbox" class=" required_one categories" name="categories[]" value="{{ $category->id }}"> 
                                                    {{ $category->name }}
                                                </label>
                                            </li>
                                            @if($category->subCategories)
                                                <ul class="list-group">
                                                    <li class="list-group-item" >
                                                        @foreach ($category->subCategories as $child)
                                                        <label>
                                                            <input type="checkbox" name="categories[]" class=" required_one sub_categories sub_categories_<?=$child->sub_id?>" parents_id = '<?=$category->id?>' value="{{ $child->sub_id }}"> 
                                                            {{ $child->sub_name }}
                                                        </label>
                                                        @endforeach
                                                    </li>
                                                </ul>
                                            @endif
                                            @endforeach                                  
                                            </ul>  
                                            @error('categories') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            
                                        </div>
                                        @foreach($languages as $language)
                                        <div class="form-group  @error('name_'.$language->code) has-error @enderror">
                                            <label for="name" class="asterisk control-label">Name ({{ $language->name }})</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" id="name_<?=$language->code?>" name="name_<?=$language->code?>" class="form-control field-validate" value="{{ old('name_'.$language->code) }}" autocomplete="off" autofocus>
                                                </div>
                                                @error('name_'.$language->code) <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        </div>
                                        @endforeach
                                        @foreach($languages as $language)
                                        <div class="form-group  @error('short_description_'.$language->code) has-error @enderror">
                                            <label for="name" class="control-label">Short Description ({{ $language->name }})</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="short_description_<?=$language->code?>" class="form-control field-validate" value="{{ old('short_description_'.$language->code) }}" autocomplete="off" autofocus>
                                                </div>
                                                @error('short_description_'.$language->code) <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        </div>
                                        @endforeach
                                        @foreach($languages as $language)
                                        <div class="form-group  @error('description_'.$language->code) has-error @enderror">
                                            <label for="name" class="control-label">Description ({{ $language->name }})</label>
                                                <textarea name="description_<?=$language->code?>" class="form-control editer{{$language->code}}" autocomplete="off" autofocus>{{ old('description_'.$language->code) }}</textarea>
                                                @error('description_'.$language->code) <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        </div>
                                        @endforeach
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                                <label for="name" class="control-label">Brand</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select class="form-control" name="brand_id">
                                                        <option value="">Select Brand</option>
                                                        @foreach($brands as $brand)
                                                        <option value="{{$brand->id}}">{{$brand->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                        </div>
                                        <div class="form-group  @error('price') has-error @enderror">
                                            <label for="name" class="asterisk control-label">Price</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="price" class="form-control number-validate" value="{{ old('price')  ? : '0' }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off" autofocus>
                                                </div>
                                                @error('price') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        </div>
                                        <div class="form-group  @error('min_order') has-error @enderror">
                                            <label for="name" class="asterisk control-label">Min Order Limit</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="min_order" class="form-control number-validate" value="{{ old('min_order')  ? : '1'}}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off" autofocus>
                                                </div>
                                                @error('min_order') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        </div>
                                        <div class="form-group  @error('max_stock') has-error @enderror">
                                            <label for="name" class="asterisk control-label">Max Order Limit</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="max_stock" class="form-control" value="{{ old('max_stock')}}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off" autofocus>
                                                </div>
                                                @error('max_stock') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        </div>
                                        <div class="form-group special-link">
                                            <label for="name" class=" control-label">Special</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select class="form-control showSpecial" name="isSpecial" id="isSpecial">
                                                        <option value="no">No</option>
                                                        <option value="yes">Yes</option>
                                                    </select>
                                                </div>
                                        </div>
                                        <div class="special-container" style="display: none;">
                                            <div class="form-group">
                                                <label for="name" class="control-label">Special Price<span style="color:red;">*</span></label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input class="form-control" type="text" name="special_new_product_price" value="0" id="special-price" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="form-group @error('dob') has-error @enderror">
                                            <label for="name" class="asterisk control-label">Expiry Date</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-calendar fa-fw"></i></span>
                                                    <input type="text" name="expires_date" placeholder="Expiry Date" value="{{ old('dob') }}" class="form-control datepicker" readonly>
                                                </div>
                                                @error('dob')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                            <div class="form-group">
                                                <label for="name" class="control-label">Status<span style="color:red;">*</span></label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select class="form-control" name="status">
                                                        <option value="Active">Active</option>
                                                        <option value="InActive">InActive</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>         
                                        <div class="form-group  @error('image') has-error @enderror">
                                            <label for="avatar" class="control-label">Image</label>
                                            <div class="input-group-btn input-group-append">
                                                <input type="file" class="avatar" name="image">
                                            </div>
                                            @error('image') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        </div>
                                    </div>
                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <div class="col-md-4">
                                </div>
                                <div class="col-md-8">
                                    <div class="btn-group pull-right">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                 
                                    <div class="btn-group pull-left">
                                        <button type="reset" class="btn btn-warning">Reset</button>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-footer -->
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    
    </div>
    @include('admin.common.toastr')
</div>
@endsection