@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Product Options<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li>Options</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="#" target="_blank" class="btn btn-sm btn-twitter" title="Export"><i
                                            class="fa fa-download"></i><span class="hidden-xs"> Export</span></a>
                                    <button type="button" class="btn btn-sm btn-twitter dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" target="_blank">All</a></li>
                                        <li><a href="#" target="_blank">Current page</a></li>
                                        <li><a href="#" target="_blank" class="export-selected">Selected rows</a></li>
                                    </ul>
                                </div>
                                @canany(['attribute.create','all'])
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a href="{{ route('attribute.create') }}" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                                @endcanany
                            </div>
                            @canany(['attribute.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{url('public/admin/attribute')}}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover grid-table" id="example">
                                <thead>
                                    <tr>
                                        @canany(['attribute.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th>ID</th>
                                        <th>Options</th>
                                       <th>Values</th>
                                        @canany(['attribute.destroy','attribute.edit','all'])
                                        <th class="column-__actions__">Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(count($result)>0)
                  	                @foreach($result as $data)
                                    
                                    <tr data-key="{{$data->option_id}}">
                                        @canany(['attribute.destroy','attribute.edit','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{ $data->option_id }}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td>{{$data->option_id}}</td>
                                        <td dir="ltr">
                                            @foreach($data->data as $language)
                                             	<strong>{{$language->name}}:</strong>
                                                	@if(count($language->attributes)>0)
                                                        @foreach($language->attributes as $attribute)
                                                            {{$attribute->option_name}}<br>
                                                        @endforeach
                                                    @else
                                                    	--- <br>
                                                    @endif
                                           	@endforeach
                                           	@canany(['attribute.edit','all'])
                                            <a href="{{route('attribute.edit',$data->option_id)}}">Edit Option</a>
                                            @endcanany
                                        </td>
                                       <td dir="ltr">
                                           @foreach($data->data as $language)
                                             	<strong>{{$language->name}}:</strong>
                                                	@if(count($language->values)>0)
                                                        @foreach($language->values as $value)
                                                            {{$value->option_value_name}}, 
                                                        @endforeach
                                                    @else
                                                    	--- <br>
                                                    @endif
                                                    <br>
                                           	@endforeach
                                           	
                                           	@canany(['attribute.edit','all'])
                                            <a href="{{URL::to('admin/attribute/values')}}/{{$data->option_id}}">Manage Values</a>
                                            @endcanany
                                            
                                       </td>
                                        @canany(['attribute.destroy','category.edit','all'])
                                        <td class="column-__actions__">
                                            @canany(['attribute.destroy','all'])
                                            <a data-id="{{ $data->option_id }}" route="{{route('attribute.destroy',$data->option_id)}}" href="#" class="grid-batch-0"><i class="fa fa-trash label-danger"></i></a>
                                             @endcanany
                                        </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection