@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Payment Methods<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li> Payment Methods</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover  grid-table" id="example">
                                <thead>
                                    <tr>
                                        <th>ID<a class="fa fa-fw fa-sort" href="#"></a></th>
                                        <th>Name</th>
                                        @canany(['payment.edit','all'])
                                        <th>Status</th>
                                        <th class="column-__actions__">Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach($payments as $key=>$payment)
                                    <tr>
                                        <td>{{ $payment->id }}</td>
                                        <td>{{ $payment->name }}</td>
                                    @canany(['payment.edit','all'])
                                        <td class="column-updated_at">
                                            <div class="status-toggle"> 
                                                <input type="checkbox" route="{{ route('payment.store') }}" id="{{ $payment->id }}" class="check"  value="{{ $payment->id }}" @if($payment->status=='Active') checked @endif>
                                                <label for="{{ $payment->id }}" class="checktoggle change_status">checkbox</label>
                                            </div>                                      
                                        </td>
                                    @endcanany
                                    @canany(['country.edit','all'])
                                        <td class="column-__actions__">
                                            <a href="{{ route('payment.edit',$payment->id) }}"><i class="fa fa-edit"></i></a>&nbsp;
                                        </td>
                                    @endcanany
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                           
                        </div> 
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection