@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 474px;">
    <style type="text/css"></style>
    <div id="app" class=" ">
        <section class="content-header">
            <h1>
                News
                <small>Create</small>
            </h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>
                    Auth
                </li>
                <li>
                    News
                </li>
                <li>
                    Update
                </li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Create</h3>
                            <div class="box-tools">
                                <div class="btn-group pull-right" style="margin-right: 5px">
                                    <a href="{{ route('news.index') }}" class="btn btn-sm btn-default" title="List"><i class="fa fa-list"></i><span
                                            class="hidden-xs">&nbsp;List</span></a>
                                </div>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form action="{{ route('news.update',$news->id) }}" method="post" class="form-horizontal model-form-5f6c9704b9434" accept-charset="UTF-8" enctype="multipart/form-data" pjax-container>
                        {{ csrf_field() }}
                        {{ method_field('PATCH') }}
                            <div class="box-body">
                                <div class="fields-group">
                                    <div class="col-md-12">
                                        
                                        @foreach($description as $description_data)
                                        <div class="form-group  @error('name') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">Name ({{ $description_data['language_name'] }})</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" id="name" name="name_<?=$description_data['language_id']?>" class="form-control name" placeholder="Input Name" value="{{$description_data['name']}}" autocomplete="off" autofocus>
                                                </div>
                                                @error('name') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        @endforeach
                                        @foreach($description as $description_data)
                                        <div class="form-group  @error('description_'.$description_data['language_id']) has-error @enderror">
                                            <label for="slug" class="col-sm-2 asterisk control-label">Description ({{ $description_data['language_name'] }})</label>
                                            <div class="col-sm-8">
                                                <textarea name="description_<?=$description_data['language_id']?>" class="form-control editer{{$description_data['language_id']}}" autocomplete="off">{{ $description_data['description'] }}</textarea>
                                                @error('description_'.$description_data['language_id']) <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div> 
                                        @endforeach
                                      <div class="form-group  @error('image') has-error @enderror">
                                            <label for="avatar" class="col-sm-2  control-label">Image</label>
                                            <div class="col-sm-8">
                                                <div class="input-group-btn input-group-append">
                                                    <input type="file" class="avatar" name="image" data-initial-preview="{{asset('').'/'.$news->image }}" data-initial-caption="{{ $news->image }}" id="1600892307492_72"> 
                                                </div>
                                                @error('image') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('is_feature') has-error @enderror">
                                            <label for="avatar" class="col-sm-2  control-label">Feature</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select class="form-control" name="is_feature">
                                                        <option value="No" @if($news->is_feature == 'No') selected @endif>No</option>
                                                        <option value="Yes" @if($news->is_feature == 'Yes') selected @endif>Yes</option>
                                                    </select>
                                                </div>
                                                @error('is_feature') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <div class="col-md-2">
                                </div>
                                <div class="col-md-8">
                                    <div class="btn-group pull-right">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                 
                                    <div class="btn-group pull-left">
                                        <button type="reset" class="btn btn-warning">Reset</button>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-footer -->
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection