@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container">
    <div id="app">
        <section class="content-header">
            <h1>
                Menu
                <small>List</small>
            </h1>

            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>
                    Auth
                </li>
                <li>
                    Menu
                </li>
            </ol>

            <!-- breadcrumb end -->

        </section>

        <section class="content">
            <div class="row">
                <div class="col-md-6">
                    <div class="box">

                        <div class="box-header">

                            <div class="btn-group">
                                <a class="btn btn-primary btn-sm tree-5fa05f7674479-tree-tools" data-action="expand" title="Expand">
                                    <i class="fa fa-plus-square-o"></i>&nbsp;Expand
                                </a>
                                <a class="btn btn-primary btn-sm tree-5fa05f7674479-tree-tools" data-action="collapse" title="Collapse">
                                    <i class="fa fa-minus-square-o"></i>&nbsp;Collapse
                                </a>
                            </div>

                            <div class="btn-group">
                                <a class="btn btn-info btn-sm tree-5fa05f7674479-save" title="Save"><i class="fa fa-save"></i><span class="hidden-xs">&nbsp;Save</span></a>
                            </div>



                            <div class="btn-group">

                            </div>


                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <div class="dd" id="tree-5fa05f7674479">
                                
                                <?php
                                function getTreeHierarchy2($parent_id = 0,$level = 0, $indicator = '&nbsp;&nbsp;&nbsp;') {
                                    $menus = DB::table('menus')->where('parent_id',$parent_id)->get();
                                    if(count($menus) > 0){
                                        foreach ($menus as $menu) {
                                            $space = str_repeat($indicator, $level);
                                        echo'<ol class="dd-list"><li class="dd-item" data-id="'.$menu->id.'">
                                                <div class="dd-handle">
                                                    <i class="fa '.$menu->icon.'"></i>&nbsp;<strong>'.$menu->title.'</strong>'.$space.'<a href="'.$menu->uri.'" class="dd-nodrag"> http://localhost/blogCopy/admin/'.$menu->uri.'</a><span class="pull-right dd-nodrag"><a href="editMenu/'.$menu->id.'"><i class="fa fa-edit"></i></a><a data-id="'.$menu->id.'" href="#" route="admin/deleteMenu" class="grid-batch-0"><i class="fa fa-trash"></i></a>
                                                    </span>
                                                </div>
                                            </li></ol>';
                                            getTreeHierarchy2($menu->id, $level+1, '&nbsp;&nbsp;&nbsp;'); 
                                        }
                                    }
                                }
                                getTreeHierarchy2(0, 0, '&nbsp;&nbsp;&nbsp;');
                                ?>   
                                    
                            </div>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="box box-success">
                        <div class="box-header with-border">
                            <h3 class="box-title">New</h3>
                            <div class="box-tools pull-right">
                            </div>
                            <!-- /.box-tools -->
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body" style="display: block;">
                            <form method="POST" action="{{ route('admin.addMenu') }}" class="form-horizontal " accept-charset="UTF-8" enctype="multipart/form-data" >
                                {{ csrf_field() }}
                                <div class="box-body fields-group">
                                    <div class="form-group  ">
                                        <label for="parent_id" class="col-sm-2  control-label">Parent</label>
                                        <div class="col-sm-8">

                                            <select class="form-control select2" style="width: 100%;" name="parent_id">
                                                <option value=""></option>
                                                <option value="0" selected>ROOT</option>
                                                <?php
                                                function getTreeHierarchy($parent_id = 0,$level = 0, $indicator = '&nbsp;&nbsp;&nbsp;') {
                                                    $results = DB::table('menus')->where('parent_id',$parent_id)->get();
                                                    if(count($results) > 0){
                                                        foreach ($results as $result) {
                                                            $space = str_repeat($indicator, $level);
                                                            echo "<option value='$result->id'>$space ┝&nbsp;$result->title</option>";
                                                            getTreeHierarchy($result->id, $level+1, '&nbsp;&nbsp;&nbsp;'); 
                                                        }
                                                    }
                                                }
                                                getTreeHierarchy(0, 0, '&nbsp;&nbsp;&nbsp;');
                                                ?>   
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group  @error('name') has-error @enderror">
                                        <label for="title" class="col-sm-2 asterisk control-label">Title</label>
                                        <div class="col-sm-8">
                                            <div class="input-group">
                                                <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                <input type="text" id="title" name="title" value="" class="form-control title" placeholder="Input Title">
                                            </div>
                                            @error('title') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        </div>
                                    </div>
                                    <div class="form-group  ">
                                        <label for="icon" class="col-sm-2 asterisk control-label">Icon</label>
                                        <div class="col-sm-8">
                                            <div class="input-group">
                                                <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                <input style="width: 140px" type="text" id="icon" name="icon" value="fa-bars" class="form-control icon" placeholder="Input Icon">
                                            </div>
                                            <span class="help-block"><i class="fa fa-info-circle"></i> For more icons please see <a href="http://fontawesome.io/icons/" target="_blank">http://fontawesome.io/icons/</a></span>
                                        </div>
                                    </div>
                                    <div class="form-group  ">
                                        <label for="uri" class="col-sm-2  control-label">URI</label>
                                        <div class="col-sm-8">
                                            <div class="input-group">
                                                <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                <input type="text" id="uri" name="uri" value="" class="form-control uri" placeholder="Input URI">
                                            </div>
                                        </div>
                                    </div>
                                
                                </div>

                                <!-- /.box-body -->
                                <div class="box-footer">
                                    <div class="col-md-2"></div>
                                    <div class="col-md-8">
                                        <div class="btn-group pull-left">
                                            <button type="reset" class="btn btn-warning pull-right">Reset</button>
                                        </div>
                                        <div class="btn-group pull-right">
                                            <button type="submit" class="btn btn-info pull-right">Submit</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>

            </div>
        </section>
    </div>
    @include('admin.common.toastr')
    <script data-exec-on-popstate>
        $(function() {
            $('#tree-5fa05f7674479').nestable([]);

            $('.tree-5fa05f7674479-save').click(function() {
                var serialize = $('#tree-5fa05f7674479').nestable('serialize');

                $.post('http://localhost/blogAdmin/public/admin/auth/menu', {
                        _token: LA.token,
                        _order: JSON.stringify(serialize)
                    },
                    function(data) {
                        $.pjax.reload('#pjax-container');
                        toastr.success('Save succeeded !');
                    });
            });
            $('.tree-5fa05f7674479-tree-tools').on('click', function(e) {
                var action = $(this).data('action');
                if (action === 'expand') {
                    $('.dd').nestable('expandAll');
                }
                if (action === 'collapse') {
                    $('.dd').nestable('collapseAll');
                }
            });

            ;
            (function() {

            })();
            $(".parent_id").select2({
                "allowClear": true,
                "placeholder": {
                    "id": "",
                    "text": "Parent"
                }
            });
            $('.icon').iconpicker({
                placement: 'bottomLeft'
            });
            $(".roles").select2({
                "allowClear": true,
                "placeholder": {
                    "id": "",
                    "text": "Roles"
                }
            });
            $(".permission").select2({
                "allowClear": true,
                "placeholder": {
                    "id": "",
                    "text": "Permission"
                }
            });;
            (function() {

            })();
        });
    </script>
</div>
@endsection