@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Languages<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li>Languages</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="#" target="_blank" class="btn btn-sm btn-twitter" title="Export"><i
                                            class="fa fa-download"></i><span class="hidden-xs"> Export</span></a>
                                    <button type="button" class="btn btn-sm btn-twitter dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" target="_blank">All</a></li>
                                        <li><a href="#" target="_blank">Current page</a></li>
                                        <li><a href="#" target="_blank" class="export-selected">Selected rows</a></li>
                                    </ul>
                                </div>
                                @canany(['addLanguage','all'])
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a href="{{ route('language.create') }}" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                                @endcanany
                            </div>
                            @canany(['deleteLanguage','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{url('public/admin/language')}}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover grid-table" id="example">
                                <thead>
                                    <tr>
                                        @canany(['deleteLanguage','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th class="column-id">ID</th>
                                        <th class="column-admin_type">Default</th>
                                        <th class="column-name">Name</th>
                                        <th class="column-name">Image</th>
                                        <th class="column-permissions">Code</th>
                                        <th class="column-created_at">Direction</th>
                                        @canany(['editLanguage','all'])
                                        <th class="column-updated_at">Status</th>
                                        @endcanany
                                        @canany(['deleteLanguage','editLanguage','all'])
                                        <th class="column-__actions__">Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($languages as $language)
                                    <tr data-key="{{ $language->id }}">
                                        @canany(['deleteLanguage','editLanguage','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{ $language->id }}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td class="column-id">
                                            {{ $language->id }}
                                        </td>
                                        <td class="column-username">
                                        <input type="radio" name="id" value="{{ $language->id}}"  class="default_language" @if($language->isdefault==1) checked @endif >
                                            
                                        </td>
                                        <td class="column-name">
                                            {{ $language->name }}
                                        </td>
                                        <td>
                                            <img src="{{asset('').$language->image}}" width="25px" alt="">
                                        </td>
                                        <td class="column-roles">
                                        {{ $language->code }}
                                        </td>
                                        <td class="column-created_at">
                                        {{ $language->direction }}
                                        </td>
                                        @canany(['editLanguage','all'])
                                        <td class="column-updated_at">
                                            <div class="status-toggle">   
                                            <input type="checkbox" route="{{ route('admin.languageStatus') }}" id="{{ $language->id }}" class="check"  value="{{ $language->id }}" @if($language->status=='Active') checked @endif>
    										<label for="{{ $language->id }}" class="checktoggle change_status">checkbox</label>
    										</div>                                       
                                        </td>
                                        @endcanany
                                        @canany(['deleteLanguage','editLanguage','all'])
                                        <td class="column-__actions__">
                                            @canany(['editLanguage','all'])
                                            <a href="{{route('language.edit',$language->id)}}"><i class="fa fa-edit"></i></a>&nbsp;
                                            @endcan
                                            @canany(['deleteLanguage','all'])
                                            <a data-id="{{ $language->id }}" route="{{route('language.destroy',$language->id)}}" href="#" class="grid-batch-0"><i class="fa fa-trash label-danger"></i></a>
                                             @endcanany
                                        </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection