@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Gifts<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li>Gifts</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="#" target="_blank" class="btn btn-sm btn-twitter" title="Export"><i
                                            class="fa fa-download"></i><span class="hidden-xs"> Export</span></a>
                                    <button type="button" class="btn btn-sm btn-twitter dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" target="_blank">All</a></li>
                                        <li><a href="#" target="_blank">Current page</a></li>
                                        <li><a href="#" target="_blank" class="export-selected">Selected rows</a></li>
                                    </ul>
                                </div>
                                @canany(['gift.create','all'])
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a href="{{ route('gift.create') }}" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                                @endcanany
                            </div>
                            @canany(['gift.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;vertical-align:unset;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{url('public/admin/gift')}}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                                <form action="{{URL::to('admin/gift')}}" pjax-container="" style="display: inline-block;">
                                    <div class="input-group input-group-sm hidden-xs" style="width: 170px;">
                                        <div class="input-group-btn">
                                            <a href="{{ URL::to('admin/gift') }}" class="btn btn-danger"><i class="fa fa-times"></i></a>
                                        </div>
                                        <input type="text" name="search" class="form-control pull-right grid-quick-search" style="width: 170px;" value="{{$search}}" placeholder="Search...">
                                        <div class="input-group-btn">
                                            <button type="submit" class="btn btn-primary"><i class="fa fa-search"></i></button>
                                        </div>
                                        
                                    </div>
                                </form>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover grid-table">
                                <thead>
                                    <tr>
                                        @canany(['gift.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th>ID</th>
                                        <th>Image</th>
                                        <th>Price</th>
                                        <th>Description</th>
                                        <th>Colors</th>
                                     
                                        @canany(['gift.destroy','gift.edit','all'])
                                        <th class="column-__actions__">Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(count($gifts)>0)
                                    @foreach($gifts as $gift)
                                    <tr data-key="{{ $gift->id }}">
                                        @canany(['gift.destroy','gift.edit','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{ $gift->id }}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td>{{ $gift->id }}</td>
                                        <td><img src="{{asset('').$gift->image}}" width="100px" alt=""></td>
                                        <td>{{ $gift->price }}</td>
                                        <td style="max-width:200px">{{ $gift->description_en }}</td>
                                        <td dir="ltr">
                                            @foreach($gift->data as $language)
                                             	<strong>{{$language->name}}:</strong>
                                                	@if(count($language->colors)>0)
                                                        @foreach($language->colors as $color)
                                                            {{$color->name}},
                                                        @endforeach
                                                    @else
                                                    	--- <br>
                                                    @endif
                                                    <br>
                                           	@endforeach
                                             <a href="{{URL::to('admin/gift/colors/'.$gift->id)}}">Manage Colors</a>
                                        </td>
                                        
                                        @canany(['gift.destroy','gift.edit','all'])
                                        <td class="column-__actions__">
                                            @canany(['gift.edit','all'])
                                            <a href="{{route('gift.edit',$gift->id)}}"><i class="fa fa-edit"></i></a>&nbsp;
                                            @endcan
                                            @canany(['gift.destroy','all'])
                                            <a data-id="{{ $gift->id }}" route="{{route('gift.destroy',$gift->id)}}" href="#" class="grid-batch-0"><i class="fa fa-trash label-danger"></i></a>
                                             @endcanany
                                        </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                    @else
                                    <tr>
                                        <td colspan="7" class="text-center">No Record Found</td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                             <div class="col-xs-12 text-right">
                                {{$gifts->links('admin.pagination.default')}}
                            </div>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection