@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container">
    <!-- Content Header (Page header) -->
    <div id="app" class=" ">
        <section class="content-header">
            <h1>
                Dashboard
                <small></small>

            </h1>
            <ol class="breadcrumb">
                <li class="active"><i class="fa fa-dashboard"></i> breadcrumb_dashboard') }}</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-4 col-xs-12">
                   
                </div>
                <div class="col-md-8 col-xs-12">
                    <div class="btn-group pull-right active" data-toggle="buttons">
                        <label class="btn btn-primary">
                            <a href="{{URL::to('admin/dashboard')}}" style="color:#fff;"><i class="fa fa-refresh"></i></a>
                         </label>
                        <label class="btn btn-info @if($date_filters['start'] == date('Y-m-d') && $date_filters['end'] == date('Y-m-d')) active @endif">
                            <a href="{{URL::to('admin/dashboard')}}?start={{date('Y-m-d')}}&end={{date('Y-m-d')}}" style="color:#fff;">Today</a>
                         </label>
                        <label class="btn btn-info @if($date_filters['start'] == date('Y-m-d', strtotime('monday this week')) && $date_filters['end'] == date('Y-m-d', strtotime('sunday this week'))) active @endif">
                        <a href="{{URL::to('admin/dashboard')}}?start={{date('Y-m-d', strtotime('monday this week'))}}&end={{date('Y-m-d', strtotime('sunday this week'))}}" style="color:#fff;">This Week</a>
                        </label>
                        <label class="btn btn-info @if($date_filters['start'] == date('Y-m-01') && $date_filters['end'] == date('Y-m-t')) active @endif">
                            <a href="{{URL::to('admin/dashboard')}}?start={{date('Y-m-01')}}&end={{date('Y-m-t')}}" style="color:#fff;">This Month</a>
                        </label>
                        <label class="btn btn-info @if($date_filters['start'] == date('Y-01-01') && $date_filters['end'] == date('Y-12-31')) active @endif">
                            <a href="{{URL::to('admin/dashboard')}}?start={{date('Y-01-01')}}&end={{date('Y-12-31')}}" style="color:#fff;">This Year</a>
                        </label>
                        <div class="input-group ">
                            <input class="form-control custom_date dateRange" readonly value="" >
                            <div class="input-group-btn"><button type="button" class="btn btn-primary getRange">Go</button> </div>
                        </div>
                    </div>
                </div>
            </div>
            <br>
            <div class="row">
                <div class="col-lg-4 col-xs-6">
                    <!-- small box -->
                    <div class="small-box bg-aqua">
                        <div class="inner">
                            <h3>{{ $result['total_orders'] }}</h3>
                            <p>New Orders</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-bag"></i>
                        </div>
                        <a href="{{ route('order.index')}}" class="small-box-footer" data-toggle="tooltip" data-placement="bottom" title="View All Orders">View All Orders <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-4 col-xs-6">
                    <!-- small box -->
                    <div class="small-box bg-light-blue">
                        <div class="inner">
                            <h3>QAR {{ $result['total_money'] }}</h3>
                            <p>Total Purchased Money</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-card"></i>
                        </div>
                        <a href="{{ route('product.index')}}" class="small-box-footer" data-toggle="tooltip" data-placement="bottom" title="View All Products">View All Products <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-4 col-xs-6">
                    <!-- small box -->
                    <div class="small-box bg-teal">
                        <div class="inner">
                            <h3>QAR {{ $result['profit'] }}</h3>
                            <p>Total Money Earned</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-card"></i>
                        </div>
                        <a href="{{ route('order.index')}}" class="small-box-footer" data-toggle="tooltip" data-placement="bottom" title="View All Orders">View All Orders <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-4 col-xs-6">

                    <div class="small-box bg-red">
                        <div class="inner">
                            <h3>{{ $result['outOfStock'] }}</h3>
                            <p>Out Of Stock</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-stats-bars"></i>
                        </div>
                        <a href="{{ route('product.index')}}" class="small-box-footer" data-toggle="tooltip" data-placement="bottom" title="Out Of Stock">Out Of Stock <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-4 col-xs-6">
                    <!-- small box -->
                    <div class="small-box bg-yellow">
                        <div class="inner">
                            <h3>{{ $result['totalCustomers'] }}</h3>

                            <p>Customer Registrations</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-persons-add"></i>
                        </div>
                        <a href="{{ route('customer.index')}}" class="small-box-footer" data-toggle="tooltip" data-placement="bottom" title="View All Customers">View All Customers  <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-4 col-xs-6">
                    <!-- small box -->
                    <div class="small-box bg-green">
                        <div class="inner">
                            <h3>{{ $result['totalProducts'] }}</h3>
                            <p>Total Products</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-pie-graph"></i>
                        </div>
                        <a href="{{ route('product.index')}}" class="small-box-footer" data-toggle="tooltip" data-placement="bottom" title="View All Products">View All Products <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->

            </div>

            <div class="row">
                <div class="col-sm-12">
                    <div class="nav-tabs-custom">
                        <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title"> Added Sale Report</h3>
                            <div class="box-tools pull-right">
                                <p class="notify-colors">
                                    <span class="sold-content" data-toggle="tooltip" data-placement="bottom" title="Sold Products"></span> Sold Products 
                                    <span class="purchased-content" data-toggle="tooltip" data-placement="bottom" title="Added Products"></span> Added Products 
                                </p>
                            </div>
                        </div>
                        
                            <div class="tab-content">
                                <div class="active tab-pane" id="activity">
                                    <!-- Post -->
                                    <div class="chart">
                                        <!-- Sales Chart Canvas -->
                                        <canvas id="salesChart" style="height: 400px;"></canvas>
                                    </div>
                                    <!-- /.post -->
                                </div>
                                <!-- /.tab-pane -->
                            </div>
                        </div>
                            <!-- /.tab-content -->
                    </div>
                    <!-- /.nav-tabs-custom -->
                </div>
                <div class="col-md-12" style="display: none">
                    <div class="box">
                        <div class="box-header with-border">
                            <!--<h3 class="box-title pull-left">Monthly Report</h3>-->

                            <div class="col-xs-12 col-lg-4">
                                <div class="input-group">
                                    <div class="input-group-btn">
                                        <button type="button" class="btn btn-default" aria-label="Help">Custom Date</button>
                                    </div>
                                    <input class="form-control" aria-label="Text input with multiple buttons">
                                    <div class="input-group-btn">
                                        <button type="button" class="btn btn-primary">Go</button>
                                    </div>
                                </div>
                            </div>

                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                </button>
                                <!--<div class="btn-group">
                  <button type="button" class="btn btn-box-tool dropdown-toggle" data-toggle="dropdown">
                    <i class="fa fa-wrench"></i></button>
                  <ul class="dropdown-menu" role="menu">
                    <li><a href="#">Action</a></li>
                    <li><a href="#">Another action</a></li>
                    <li><a href="#">Something else here</a></li>
                    <li class="divider"></li>
                    <li><a href="#">Separated link</a></li>
                  </ul>
                </div>-->
                                <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <p class="text-center">
                                        <strong>Sales: 1 Jan, 2014 - 30 Jul, 2014</strong>
                                    </p>

                                    <div class="chart">
                                        <!-- Sales Chart Canvas -->
                                        <canvas id="salesChart" style="height: 400px;"></canvas>
                                    </div>
                                    <!-- /.chart-responsive -->
                                </div>
                                <!-- /.col -->

                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- ./box-body -->
                        <div class="box-footer" style="display: none">
                            <div class="row">
                                <div class="col-sm-3 col-xs-6">
                                    <div class="description-block border-right">
                                        <span class="description-percentage text-green"><i class="fa fa-caret-up"></i> 17%</span>
                                        <h5 class="description-header">QAR 35,210.43</h5>
                                        <span class="description-text">Total Revenue</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-3 col-xs-6">
                                    <div class="description-block border-right">
                                        <span class="description-percentage text-yellow"><i class="fa fa-caret-left"></i> 0%</span>
                                        <h5 class="description-header">$10,390.90</h5>
                                        <span class="description-text">total_cost') }}</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-3 col-xs-6">
                                    <div class="description-block border-right">
                                        <span class="description-percentage text-green"><i class="fa fa-caret-up"></i> 20%</span>
                                        <h5 class="description-header">$24,813.53</h5>
                                        <span class="description-text">total_profit') }}</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-3 col-xs-6">
                                    <div class="description-block">
                                        <span class="description-percentage text-red"><i class="fa fa-caret-down"></i> 18%</span>
                                        <h5 class="description-header">1200</h5>
                                        <span class="description-text">goal_completions') }}</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- /.box-footer -->
                    </div>
                    <!-- /.box -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->

            <!-- Main row -->
            <div class="row">
                <!-- Left col -->
                <div class="col-md-8">
                    <!-- MAP & BOX PANE -->
                    <!-- /.box -->
                    <div class="row">
                        <!-- /.col -->
                        <div class="col-md-12">
                            <!-- USERS LIST -->
                            <div class="box box-danger">
                                <div class="box-header with-border">
                                    <h3 class="box-title">Latest Customers</h3>
                                    <div class=" pull-right">
                                        <span class="label label-danger">{{ count($result['customers']) }} New Members</span>
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                        <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                                    </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body no-padding">
                                    @if(count($result['customers'])>0)
                                        <ul class="users-list clearfix">
                                            <?php $i = 1; ?>
                                            @foreach ($result['customers']  as $customer)
                                                    @if($i<=21)
                                                        <li>
                                                            <img src="{{asset(''.$customer->image)}}">
                                                            <a class="users-list-name" href="{{ route('customer.edit',$customer->id) }}">{{ $customer->first_name }} {{ $customer->last_name }}</a>
                                                            <span class="users-list-date">{{$customer->created_at}}</span>
                                                        </li>
                                                    @endif
                                                    <?php $i++; ?>
                                                {{--@endforeach--}}
                                            @endforeach
                                        </ul>
                                    @else
                                        <p style="padding: 8px 0 0 10px; ">No Customer Exist</p>
                                @endif
                                </div>
                                <!-- /.box-body -->
                                <div class="box-footer text-center ">
                                    <a href="{{ route('customer.index')}} " class="uppercase " data-toggle="tooltip " data-placement="bottom " title="View All Customers ">View All Customers</a>
                                </div>
                                <!-- /.box-footer -->
                            </div>
                            <!--/.box -->
                        </div>
                        <!-- /.col -->
                    </div>
          <!-- /.row -->

          <!-- TABLE: LATEST ORDERS -->
        <div class="box box-info ">
            <div class="box-header with-border ">
                <h3 class="box-title ">New Orders</h3>
                <div class="pull-right ">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                    <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body ">
            	<div class="table-responsive ">
            		<table class="table no-margin ">
            			<thead>
            				<tr>
            					<th>Order ID</th>
            					<th>Customer Name</th>
            					<th>Total Price</th>
            					<th>Status</th>
            				</tr>
            			</thead>
            			<tbody>
            				@if(count($result['orders'])>0)
            				@foreach($result['orders'] as $total_orders)
            				@foreach($total_orders as $key=>$orders)
            				@if($key<=10)
            				<tr>
            					<td><a href="{{ route('order.edit',$orders->id) }} " data-toggle="tooltip " data-placement="bottom " title="Go to detail ">{{ $orders->id }}</a></td>
            					<td>{{ $orders->name }}</td>
            					<td>{{ floatval($orders->total_price) }}</td>
            					<td>
            					    @if($orders->order_status == 'Pending')
                                    <span class="label label-warning">
                                    @elseif($orders->order_status == 'Completed')
                                    <span class="label label-success">
                                    @elseif($orders->order_statu == 'Cancelled')
                                    <span class="label label-danger">
                                    @else
                                    <span class="label label-primary">
                                    @endif
                                    {{ $orders->order_status }}
                                    </span>
                                </td>
            				</tr>
            				@endif
            				@endforeach
            				@endforeach
            				@else
            				<tr>
            					<td colspan="4">No Order Placed</td>
            				</tr>
            				@endif
            			</tbody>
            		</table>
            	</div>
            </div>
            <!-- /.box-body -->
            <div class="box-footer clearfix ">
              <!--<a href="javascript:void(0) " class="btn btn-sm btn-info btn-flat pull-left ">Place New Order</a>-->
              <a href="{{ URL::to( 'admin/orders') }} " class="btn btn-sm btn-default btn-flat pull-right " data-toggle="tooltip " data-placement="bottom " title="View All Orders ">View All Orders</a>
            </div>
            <!-- /.box-footer -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->

        <div class="col-md-4 ">
         
          <!-- PRODUCT LIST -->
          
          <div class="box box-primary ">
            <div class="box-header with-border ">
              <h3 class="box-title">Goal Completion</h3>

              <div class="pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                </button>
                <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
              </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body ">
                <div class="progress-group">
                    <span class="progress-text ">Add Products to Cart</span>
                    <span class="progress-number"><b>{{ $result['cart'] }}</b>/500</span>
                    <div class="progress sm">
                      <div class="progress-bar progress-bar-aqua" style="width: {{ $result['cart']*100/500 }}%"></div>
                    </div>
                  </div>
                  <!-- /.progress-group -->
                  <div class="progress-group ">
                    <span class="progress-text ">Complete Orders</span>
                    <span class="progress-number"><b>{{ $result['compeleted_orders'] }}</b>/{{ $result['total_orders'] }}</span>
                    <div class="progress sm ">
                      <div class="progress-bar progress-bar-green" style="width: {{ $result['compeleted_orders']*100/$result['total_orders'] }}%"></div>
                    </div>
                  </div>
                  <!-- /.progress-group -->
                  <div class="progress-group ">
                    <span class="progress-text ">Pending Orders</span>
                    <span class="progress-number "><b>{{ $result['pending_orders'] }}</b>/{{ $result['total_orders'] }}</span>
                    <div class="progress sm ">
                      <div class="progress-bar progress-bar-yellow" style="width: {{ $result['pending_orders']*100/$result['total_orders'] }}%"></div>
                    </div>
                  </div>
                  <!-- /.progress-group -->
                  <div class="progress-group ">
                    <span class="progress-text ">Inprocess Orders</span>
                    <span class="progress-number "><b>{{ $result['inprocess'] }}</b>/{{ $result['total_orders'] }}</span>
                    <div class="progress sm ">
                      <div class="progress-bar progress-bar-red" style="width: {{ $result['inprocess']*100/$result['total_orders'] }}%"></div>
                    </div>
                  </div>
                   
            </div>
            <!-- /.box-body -->
          </div>
          <div class="box box-primary ">
            <div class="box-header with-border ">
              <h3 class="box-title ">Recently Added Products</h3>
              <div class="box-tools pull-right ">
                <button type="button " class="btn btn-box-tool " data-widget="collapse "><i class="fa fa-minus "></i>
                </button>
                <button type="button " class="btn btn-box-tool " data-widget="remove "><i class="fa fa-times "></i></button>
              </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body ">
              <ul class="products-list product-list-in-box ">
            @foreach($result['recentProducts'] as $recentProducts)
                <li class="item ">
                  <div class="product-img ">
                    <img src="{{asset('').$recentProducts->image}}" alt=" " width=" 100px " height="100px ">
                  </div>
                  <div class="product-info ">
                    <a href="{{ route('product.edit',$recentProducts->id) }}" class="product-title ">{{ $recentProducts->name }}
                      <span class="label label-warning label-succes pull-right ">{{ floatval($recentProducts->price) }}</span></a>
                        <span class="product-description">{{ $recentProducts->short_description }}</span>
                  </div>
                </li>
              @endforeach
              </ul>
            </div>
            <!-- /.box-body -->
            <div class="box-footer text-center ">
              <a href="{{ URL::to( 'admin/products') }} " class="uppercase " data-toggle="tooltip " data-placement="bottom " title="View All Products ">View All Products</a>
            </div>
            <!-- /.box-footer -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
      <div class="row " style="display:none; ">
     
        <div class="col-md-3 col-sm-6 col-xs-6 col-lg-3 " style="position: fixed;bottom: 30px;right: 0px;z-index: 99999;outline: none; color: rgb(238, 238, 238); cursor: pointer; padding:0px; border-radius: 4px;border: 3px solid #f39c12; ">
          <!-- DIRECT CHAT WARNING -->
          <div class="box box-warning direct-chat direct-chat-warning ">
            <div class="box-header with-border ">
              <h3 class="box-title ">Direct Chat</h3>

              <div class="box-tools pull-right ">
                <span data-toggle="tooltip " title=" " class="badge bg-yellow " data-original-title="3 New Messages ">3</span>
                <button type="button " class="btn btn-box-tool " data-widget="collapse "><i class="fa fa-minus "></i>
                </button>
                <button type="button " class="btn btn-box-tool " data-toggle="tooltip " title=" " data-widget="chat-pane-toggle " data-original-title="Contacts ">
                  <i class="fa fa-comments "></i></button>
                <button type="button " class="btn btn-box-tool " data-widget="remove "><i class="fa fa-times "></i></button>
              </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body ">
              <!-- Conversations are loaded here -->
              <div class="direct-chat-messages ">
                <!-- Message. Default to the left -->
                <div class="direct-chat-msg ">
                  <div class="direct-chat-info clearfix ">
                    <span class="direct-chat-name pull-left ">Alexander Pierce</span>
                    <span class="direct-chat-timestamp pull-right ">23 Jan 2:00 pm</span>
                  </div>
                  <!-- /.direct-chat-info -->
                  <img class="direct-chat-img " src="" alt="Message User Image "><!-- /.direct-chat-img -->
                  <div class="direct-chat-text ">
                    Is this template really for free? That's unbelievable!
                  </div>
                  <!-- /.direct-chat-text -->
                </div>
                <!-- /.direct-chat-msg -->

                <!-- Message to the right -->
                <div class="direct-chat-msg right ">
                  <div class="direct-chat-info clearfix ">
                    <span class="direct-chat-name pull-right ">Sarah Bullock</span>
                    <span class="direct-chat-timestamp pull-left ">23 Jan 2:05 pm</span>
                  </div>
                  <!-- /.direct-chat-info -->
                  <img class="direct-chat-img " src=" " alt="Message User Image "><!-- /.direct-chat-img -->
                  <div class="direct-chat-text ">
                    You better believe it!
                  </div>
                  <!-- /.direct-chat-text -->
                </div>
                <!-- /.direct-chat-msg -->
              </div>
              <!--/.direct-chat-messages-->

              <!-- Contacts are loaded here -->
              <div class="direct-chat-contacts ">
                <ul class="contacts-list ">
                  <li>
                    <a href="# ">
                      <img class="contacts-list-img " src=" " alt="User Image ">

                      <div class="contacts-list-info ">
                            <span class="contacts-list-name ">
                              Count Dracula
                              <small class="contacts-list-date pull-right ">2/28/2015</small>
                            </span>
                        <span class="contacts-list-msg ">How have you been? I was...</span>
                      </div>
                      <!-- /.contacts-list-info -->
                    </a>
                  </li>
                  <!-- End Contact Item -->
                </ul>
                <!-- /.contatcts-list -->
              </div>
              <!-- /.direct-chat-pane -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer ">
              <form action="# " method="post ">
                <div class="input-group ">
                  <input type="text " name="message " placeholder="Type Message ... " class="form-control ">
                      <span class="input-group-btn ">
                        <button type="submit " class="btn btn-warning btn-flat ">Send</button>
                      </span>
                </div>
              </form>
            </div>
            <!-- /.box-footer-->
          </div>
          <!--/.direct-chat -->
        </div>
        <!-- /.col -->
      </div>
    </section>
    </div>
    <!-- /.content -->
   @include('admin.common.toastr')
  </div>
  
  @endsection