@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Customers<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>Auth</li><li>Customers</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="#" target="_blank" class="btn btn-sm btn-twitter" title="Export"><i
                                            class="fa fa-download"></i><span class="hidden-xs"> Export</span></a>
                                    <button type="button" class="btn btn-sm btn-twitter dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" target="_blank">All</a></li>
                                        <li><a href="#" target="_blank">Current page</a></li>
                                        <li><a href="#" target="_blank" class="export-selected">Selected rows</a></li>
                                    </ul>
                                </div>
                                @canany(['customer.create','all'])
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a href="{{ route('customer.create') }}" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                                @endcanany

                            </div>
                            @canany(['customer.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{ url('public/admin/customer') }}"  class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                       <!-- /.box-header -->
                        <div class="box-body table-responsive">
                            <table class="table table-hover grid-table" id="example">
                                <thead>
                                    <tr>
                                        @canany(['customer.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th>ID</th>
                                        <th>Image</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Created At</th>
                                        <th>Updated At</th>
                                        @canany(['customer.edit','all'])
                                        <th class="column-__actions__">Status</th>
                                        @endcan
                                        @canany(['customer.destroy','customer.edit','all'])
                                        <th class="column-__actions__">Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($customers as  $customer)
                                    <tr data-key="{{ $customer->id }}">
                                        @canany(['customer.destroy','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{ $customer->id }}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td>{{ $customer->id }}</td>
                                        <td><img src="{{asset('').$customer->image}}" width="50px"></td>
                                        <td>
                                            <a href="{{URL::to('admin/customerProfile')}}/{{$customer->id}}">
                                        <strong>Name:</strong> {{ $customer->first_name }} {{ $customer->last_name }}<br>
                                        <strong>Wallet:</strong> QR {{ $customer->wallet }}</a>
                                        </td>
                                        <td>{{ $customer->email }}</td>
                                        <td>{{ $customer->phone }}</td>
                                        <td class="column-created_at">{{ date('Y-m-d',strtotime($customer->created_at)) }}</td>
                                        <td class="column-updated_at">{{ date('Y-m-d',strtotime($customer->updated_at)) }}</td>
                                        @canany(['customer.edit','all'])
                                        <td class="column-updated_at">
                                            <div class="status-toggle"> 
                                                <input type="checkbox" route="{{ route('customer.customerStatus') }}" id="{{ $customer->id }}" class="check"  value="{{ $customer->id }}" @if($customer->status=='Active') checked @endif>
                                                <label for="{{ $customer->id }}" class="checktoggle change_status">checkbox</label>
                                            </div>                                      
                                        </td>
                                       @endcanany
                                        @canany(['customer.destroy','customer.edit','all'])
                                        <td class="column-__actions__">
                                            @canany(['customer.destroy','all'])
                                            <a href="{{ route('customer.edit',$customer->id) }}"><i class="fa fa-edit"></i></a>&nbsp;
                                            @endcanany
                                            @canany(['customer.destroy','all'])
                                            
                                            <a data-id="{{ $customer->id }}" href="#" route="{{ route('customer.destroy',$customer->id) }}" class="grid-batch-0"><i class="fa fa-trash label-danger"></i></a>
                                            @endcanany
                                        </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>                  
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection