<?php

namespace Database\Seeders;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        $time_stamp = Carbon::now()->toDateTimeString();
         User::create([
            'first_name' => 'Administrator',
            'last_name' => 'Administrator',
            'email' => 'admin@gmail.com',
            'phone'=>'12345678',
            'password' => Hash::make('password'),
            'user_type'=>'Administrator',
            'gender'=>'Male',
            'dob'=>'2021-01-18',
            'status'=>'Active',
            'image'=>'/images/user_profile/default_user.PNG',
            'created_at'=>$time_stamp,
        ]);
        User::create([
            'first_name' => 'Data Entry',
            'last_name' => 'Sadaqat',
            'email' => 'dataentry@gmail.com',
            'phone'=>'12341234',
            'password' => Hash::make('password'),
            'user_type'=>'User',
            'gender'=>'Male',
            'dob'=>date('2021-01-18'),
            'status'=>'InActive',
            'image'=>'/images/user_profile/default_user.PNG',
            'created_at'=>$time_stamp,
        ]);
        $this->call([
            PermissionsSeeder::class,
            RolesSeeder::class,
            RoleUserSeeder::class,
            UserPermissionSeeder::class,
            RolePermissionSeeder::class,
            LanguageSeeder::class,
            MenuSeeder::class,
            CustomerSeeder::class,
            SettinsSeeder::class,
            CountrySeeder::class
        ]);
    }
}
