<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\Customer;
use Carbon\Carbon;
class CustomerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $time_stamp = Carbon::now()->toDateTimeString();
        Customer::create([
            'first_name' => 'Customer',
            'last_name' => 'Customer',
            'email' => 'customer@gmail.com',
            'phone' => '1234578',
            'status'=>'InActive',
            'password'=>Hash::make('customer'),
            'gender'=>'Male',
            'image'=>'/images/user_profile/default_user.PNG',
            'dob'=>date('2021-01-18'),
            'created_at'=>$time_stamp,
        ]);
    }
}
