<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    use HasFactory;
    protected $guarded = []; 
    public function permissions() {

        return $this->belongsToMany(Permission::class,'role_permissions','role_id','permission_id'); 
     }
     public function users() {
        return $this->belongsToMany(User::class,'roles');    
     }
     public function hasRole($permissions)
     {
         foreach($permissions as $permission){
            if($this->hasPermission($permission)){
             return true;
            }
         }
         return false;
     }

}
