<?php

namespace App\Http\Controllers\Web;
use Illuminate\Support\Facades\Collection;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Notification;
use App\Notifications\DatabaseNotification;
use App\Models\User;
use App\Models\Language;
use App\Models\Category;
use App\Models\Brand;
use App\Models\Product;
use Illuminate\Http\Request;
use DB;
use Session;
use Lang;
class ProductController extends DataController
{

    public function shop(Request $request){
         $pageTitle = Lang::get('website.Checkout');
         $commonContent = $this->commonContent();
         $result = array();
         
         $categories = Category::leftjoin('categories_description','categories_description.categories_id','=','categories.id')->where('categories_description.language_id',Session::get('locale'))->get();
         if (!empty($request->page)) {
             $page_number = $request->page;
         } else {
             $page_number = 0;
         }
         if (!empty($request->limit)) {
            $limit = $request->limit;
        } else {
            $limit = 12;
        }
         if (!empty($request->type)) {
             $type = $request->type;
         } else {
             $type = '';
         }
         //min_price
		if(!empty($request->min_price)){
			$min_price = $request->min_price;
		}else{
			$min_price = '';
		}
		//max_price
		if(!empty($request->max_price)){
			$max_price = $request->max_price;
		}else{
			$max_price = '';
		}	
		
         $exist_category = '1';
         //category
         if (!empty($request->category) and $request->category != 'all') {
             $category = Category::leftJoin('categories_description','categories_description.categories_id','=','categories.id')->select('categories.id','categories.parent_id','categories.slug','categories_description.name')->where('categories.slug',$request->category)->where('language_id',Session::get('locale'))->get();
             if(!empty($category) and count($category)>0){
                 $categories_id = $category[0]->id;
                 //for main
                 if ($category[0]->parent_id == 0) {
                     $category_name = $category[0]->name;
                     $sub_category_name = '';
                     $category_slug = $category[0]->slug;
                 } else {
                     //for sub
                     $main_category = Category::leftJoin('categories_description','categories_description.categories_id','=','categories.id')->where('categories.id',$category[0]->parent_id)->where('language_id',Session::get('locale'))->get();
                     $category_slug = $main_category[0]->slug;
                     $category_name = $main_category[0]->name;
                     $sub_category_name = $category[0]->name;
                 }
             }else{
                 $categories_id = '';
                 $category_name = '';
                 $sub_category_name = '';
                 $category_slug = '';
                 
             }
                             
 
         } else {
             $categories_id = '';
             $category_name = '';
             $sub_category_name = '';
             $category_slug = '';
             
         }
 
        $result['category_name'] = $category_name;
        $result['category_slug'] = $category_slug;
        $result['sub_category_name'] = $sub_category_name;
         
         //search value
        if (!empty($request->search)) {
            $search = $request->search;
        } else {
            $search = '';
        }
        
        if (!empty($request->brand)) {
            $brands = Brand::where('slug',$request->brand)->select('brands.id')->get();
            $brand_id = $brands[0]->id;
            $result['brand_slug'] = $request->brand;
        } else {
            $brand_id = '';
            $result['brand_slug'] = '';
        }
        
        $brands =  Brand::leftJoin('brands_description', 'brands.id', '=', 'brands_description.brand_id')->select('brands_description.name','brands.slug')->where('brands_description.language_id',Session::get('locale'))->get();
         $filters = array();
         if (!empty($request->filters_applied) and $request->filters_applied == 1) {
            $index = 0;
            $options = array();
            $option_values = array();
            $option = DB::table('products_options')->leftJoin('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
                            ->select('products_options.option_id', 'products_options_description.option_name', 'products_options_description.language_id')
                            ->where('products_options_description.language_id', '=', Session::get('locale'))->get();
                            
            foreach ($option as $key => $options_data) {
                $option_name = str_replace(' ', '_', $options_data->option_name);
                if (!empty($request->$option_name)) {
                    $index2 = 0;
                    $values = array();
                    foreach ($request->$option_name as $value) {
                        $value = DB::table('products_options_values')
                                        ->leftJoin('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
                                        ->select('products_options_values.option_value_id', 'products_options_values_description.option_value_name', 'products_options_values_description.language_id')
                                        ->where('products_options_values_description.option_value_name', $value)->where('products_options_values_description.language_id', Session::get('locale'))->get();
                        $option_values[] = $value[0]->option_value_id;
                    }
                    $options[] = $options_data->option_id;
                }
            }
    
            $filters['options_count'] = count($options);
            $filters['options'] = implode($options, ',');
            $filters['option_value'] = implode($option_values, ',');
 
            $filters['filter_attribute']['options'] = $options;
            $filters['filter_attribute']['option_values'] = $option_values;
 
            $result['filter_attribute']['options'] = $options;
            $result['filter_attribute']['option_values'] = $option_values;
         }
 
        $data = array('page_number' => $page_number, 'type' => $type,'brand_id'=> $brand_id, 'categories_id' => $categories_id, 'search' => $search,'filters' => $filters,'limit' => $limit, 'min_price' => $min_price, 'max_price' => $max_price);
        $products = $this->products($data);


         $data = array('limit' => $limit,'categories_id' => $categories_id);
         $filters = $this->filters($data);
         $result['filters'] = $filters;
 
         $cart = '';
         $result['cartArray'] = $this->cartIdArray($cart);
 
        
         //liked products
         $result['liked_products'] = $this->likedProducts();
         $result['categories'] = $this->categories();
         
        if ($limit > $products['total_record']) {
            $result['limit'] = $products['total_record'];
        } else {
            $result['limit'] = $limit;
        }
        
        $result['min_price'] = $min_price;
        $result['max_price'] = $max_price;

         return view('web.products.shop',compact('pageTitle','commonContent','categories','result','products','brands'));
         
     }
     
    public function filterProducts(Request $request){
    
        if (!empty($request->limit)) {
            $limit = $request->limit;
        } else {
            $limit = 12;
        }

        if (!empty($request->type)) {
            $type = $request->type;
        } else {
            $type = '';
        }

        //if(!empty($request->category_id)){
        if (!empty($request->category) and $request->category != 'all') {
            $category = DB::table('categories')->select('id')->where('slug', $request->category)->get();
            $categories_id = $category[0]->id;
        } else {
            $categories_id = '';
        }
        if (!empty($request->brand)) {
            $brands = Brand::where('slug',$request->brand)->select('brands.id')->get();
            $brand_id = $brands[0]->id;
            
        } else {
            $brand_id = '';
        }
        //search value
        if (!empty($request->search)) {
            $search = $request->search;
        } else {
            $search = '';
        }

        //min_price
        if (!empty($request->min_price)) {
            $min_price = $request->min_price;
        } else {
            $min_price = '';
        }

        //max_price
        if (!empty($request->max_price)) {
            $max_price = $request->max_price;
        } else {
            $max_price = '';
        }

        if (!empty($request->filters_applied) and $request->filters_applied == 1) {
            $filters['options_count'] = count($request->options_value);
            $filters['options'] = $request->options;
            $filters['options_value'] = $request->options_value;
        } else {
            $filters = array();
        }
        $data = array('page_number' => $request->page_number, 'type' => $type,'brand_id'=> $brand_id, 'categories_id' => $categories_id, 'search' => $search, 'filters' => $filters, 'limit' => $limit, 'min_price' => $min_price, 'max_price' => $max_price);
        $products = $this->products($data);

        $cart = '';
        $result['cartArray'] = $this->cartIdArray($cart);
        $result['limit'] = $limit;
        
        $commonContent = $this->commonContent();
        
        return view('web.products.filterproducts',compact('commonContent','result','products'));
    }
    
    public function filters($data){

        $categories_id = $data['categories_id'];
        $currentDate = time();

        $price = DB::table('product_category')->join('products', 'products.id', '=', 'product_category.product_id');
        
        if (isset($categories_id) and !empty($categories_id)) {
            $price->where('product_category.category_id', '=', $categories_id);
        }

        $priceContent = $price->max('price');
        if (!empty($priceContent)) {
            $maxPrice = round($priceContent + 1);            
        } else {
            $maxPrice = '';
        }

        $product = DB::table('products')
                    ->leftJoin('products_description', 'products_description.product_id', '=', 'products.id')
                    ->LeftJoin('products_specials', function ($join) use ($currentDate) {
                        $join->on('products_specials.product_id', '=', 'products.id')->where('products_specials.status', '=', 'Active')->where('products_specials.expires_date', '>', $currentDate);
                    });

        if (isset($categories_id) and !empty($categories_id)) {
            $product->LeftJoin('product_category', 'products.id', '=', 'product_category.product_id')->select('product_category.*', 'products.*', 'products_description.name','products_description.description','products_description.short_description','products_specials.special_new_product_price as discount_price');
        } else {
            $product->select('products.*', 'products_description.name','products_description.description','products_description.short_description', 'products_specials.special_new_product_price as discount_price');
        }
        $product->where('products_description.language_id', '=', Session::get('locale'));

        if (isset($categories_id) and !empty($categories_id)) {
            $product->where('product_category.category_id', '=', $categories_id);
        }

        $products = $product->get();
      
        $index = 0;
        $optionsIdArrays = array();
        $valueIdArray = array();
        foreach ($products as $products_data) {
            $option_name = DB::table('products_attributes')->where('product_id', '=', $products_data->id)->get();
           
            foreach ($option_name as $option_data) {
                if (!in_array($option_data->option_id, $optionsIdArrays)) {
                    $optionsIdArrays[] = $option_data->option_id;
                }
                if (!in_array($option_data->option_value_id, $optionsIdArrays)) {
                    $valueIdArray[] = $option_data->option_value_id;
                }
            }
        }
 
        if (!empty($optionsIdArrays)) {

            $index3 = 0;
            $result = array();
            foreach ($optionsIdArrays as $optionsIdArray) {
                $option_name = DB::table('products_options')
                    ->leftJoin('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')->select('products_options.option_id', 'products_options_description.option_name', 'products_options_description.language_id')->where('language_id', '=', Session::get('locale'))->where('products_options.option_id', '=', $optionsIdArray)->get();

                if (count($option_name) > 0) {
                    $attribute_opt_val = DB::table('products_options_values')->where('option_id', $optionsIdArray)->get();
                    if (count($attribute_opt_val) > 0) {
                        $temp = array();
                        $temp_name['name'] = $option_name[0]->option_name;
                        $attr[$index3]['option'] = $temp_name;

                        foreach ($attribute_opt_val as $attribute_opt_val_data) {

                            $attribute_value = DB::table('products_options_values')
                                ->leftJoin('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
                                ->select('products_options_values.option_value_id', 'products_options_values_description.option_value_name', 'products_options_values_description.language_id')
                                ->where('products_options_values.option_value_id', $attribute_opt_val_data->option_value_id)->where('language_id', Session::get('locale'))->get();

                            foreach ($attribute_value as $attribute_value_data) {

                                //if(in_array($attribute_value_data->products_options_values_id,$valueIdArray)){
                                $temp_value['value'] = $attribute_value_data->option_value_name;
                                $temp_value['value_id'] = $attribute_value_data->option_value_id;

                                array_push($temp, $temp_value);
                                //}
                            }
                            $attr[$index3]['values'] = $temp;
                        }
                        $index3++;
                    }
                    $response = array('success' => '1', 'attr_data' => $attr, 'message' => Lang::get('website.Returned all filters successfully'), 'maxPrice' => $maxPrice);
                } else {
                    $response = array('success' => '0', 'attr_data' => array(), 'message' => Lang::get('website.Filter is empty for this category'), 'maxPrice' => $maxPrice);
                }

            }

        } else {
            $response = array('success' => '0', 'attr_data' => array(), 'message' => Lang::get('website.Filter is empty for this category'), 'maxPrice' => $maxPrice);
        }

        return ($response);
    }
   
    public function cartIdArray($requestt){

        $cart = DB::table('customers_basket')->where('customers_basket.is_order', '=', '0');

        if (empty(session('customers_id'))) {
            $cart->where('customers_basket.session_id', '=', Session::getId());
        } else {
            $cart->where('customers_basket.customer_id', '=', session('customer_id'));
        }
        $baskit = $cart->get();

        $result = array();
        $index = 0;
        foreach ($baskit as $baskit_data) {
            $result[$index++] = $baskit_data->product_id;
        }

        return ($result);

    }
 
    public function categories(){
        $items = DB::table('categories')
            ->leftJoin('categories_description', 'categories_description.categories_id', '=', 'categories.id')
            ->select('categories.id','categories.slug', 'categories_description.name', 'categories.parent_id')
            ->where('categories_description.language_id', '=', 1)
           // ->groupBy('categories.id')
            ->get();
        if ($items->isNotEmpty()) {
            $childs = array();
            foreach ($items as $item) {
                $childs[$item->parent_id][] = $item;
            }

            foreach ($items as $item) {
                if (isset($childs[$item->id])) {
                    $item->childs = $childs[$item->id];
                }
            }

            $tree = $childs[0];
            return $tree;
        }
    }
   
    public function likedProducts(){

        $products = DB::table('liked_products')->where('liked_customer_id', '=', session('customer_id'))->get();
        $result = array();
        $index = 0;
        foreach ($products as $products_data) {
            $result[$index++] = $products_data->liked_product_id;
        }
        return ($result);

    }
  
    public function product(Request $request){
        $pageTitle = Lang::get('website.Product Detail');
        $result = array();
        $commonContent = $this->commonContent();
        //min_price
        if (!empty($request->min_price)) {
            $min_price = $request->min_price;
        } else {
            $min_price = '';
        }

        //max_price
        if (!empty($request->max_price)) {
            $max_price = $request->max_price;
        } else {
            $max_price = '';
        }
        if(!empty($request->limit)){
			$limit = $request->limit;
		}else{
			$limit = 12;
		}
        if (!empty($request->brand)) {
            $brand = Brand::where('slug',$request->brand)->select('id')->get();
            $brand_id = $brand[0]->id;
        } else {
            $brand_id = '';
        }
      

        $product = Product::where('slug', $request->slug)->get();
        if(!empty($product) and count($product)>0){
            
            //category
            $category = $this->getCategoryByParent($product[0]->id);

            if (!empty($category) and count($category) > 0) {
                $category_slug = $category[0]->slug;
                $category_name = $category[0]->name;
            } else {
                $category_slug = '';
                $category_name = '';
            }
            $sub_category = $this->getSubCategoryByParent($product[0]->id);

            if (!empty($sub_category) and count($sub_category) > 0) {
                $sub_category_name = $sub_category[0]->name;
                $sub_category_slug = $sub_category[0]->slug;
            } else {
                $sub_category_name = '';
                $sub_category_slug = '';
            }

            $result['category_name'] = $category_name;
            $result['category_slug'] = $category_slug;
            $result['sub_category_name'] = $sub_category_name;
            $result['sub_category_slug'] = $sub_category_slug;

            // $isFlash = $this->products->getFlashSale($products[0]->products_id);

            // if (!empty($isFlash) and count($isFlash) > 0) {
            //     $type = "flashsale";
            // } else {
            //     $type = "";
            // }
            $type = "";
            $postCategoryId = '';
            $data = array('page_number' => '0', 'type' => $type,'limit'=>$limit, 'brand_id'=> $brand_id, 'product_id' => $product[0]->id, 'min_price' => $min_price, 'max_price' => $max_price);
            $product = $this->products($data);
            if (!empty($product['product_data'][0]->categories) and count($product['product_data'][0]->categories) > 0) {
                $i = 0;
                foreach ($product['product_data'][0]->categories as $postCategory) {
                    if ($i == 0) {
                        $postCategoryId = $postCategory->categories_id;
                        $i++;
                    }
                }
            }

            $data = array('page_number' => '0', 'type' => '','limit'=>$limit, 'brand_id'=> $brand_id, 'categories_id' => $postCategoryId,  'min_price' => $min_price, 'max_price' => $max_price);
            $simliar_products = $this->products($data);

            $cart = '';
            $cartArray = $this->cartIdArray($cart);

            //liked products
            $liked_products = $this->likedProducts();

            $data = array('page_number' => '0', 'type' => 'TopSeller', 'limit'=>$limit, 'min_price' => $min_price, 'max_price' => $max_price);
            $top_seller = $this->products($data);
            		
        }else{
            $products = '';
            $product['product_data'] = '';
        }
       
        return view('web.products.product',compact('pageTitle','commonContent','product','simliar_products'));
        
    }
   
    public function getCategoryByParent($product_id){
        $category = Category::LeftJoin('categories_description', 'categories_description.categories_id', '=', 'categories.id')
            ->leftJoin('product_category', 'product_category.category_id', '=', 'categories.id')
            ->where('product_category.product_id', $product_id)
            ->where('categories.parent_id', 0)
            ->where('language_id', Session::get('locale'))->get();
        return $category;
    }
    
    public function getSubCategoryByParent($product_id){
        $sub_category = DB::table('categories')
            ->leftJoin('categories_description', 'categories_description.categories_id', '=', 'categories.id')
            ->leftJoin('product_category', 'product_category.category_id', '=', 'categories.id')
            ->where('product_category.product_id', $product_id)
            ->where('categories.parent_id', '>', 0)
            ->where('language_id', Session::get('locale'))
            ->get();
        return $sub_category;
    }

 	public static function getquantity($request){
        $inventory_ref_id = '';
        $result = array();
        $product_id = $request['product_id'];
        $productsType = DB::table('products')->select('type')->where('id', $product_id)->get();
        //check products type
        if ($productsType[0]->type == 'Variable') {

            $attributes = array_filter($request['attributes']);
            $attributeid = implode(',', $attributes);
            $postAttributes = count($attributes);
            $inventories = DB::table('inventory')->select('inventory_ref_id')->where('product_id', $product_id)->get();
            $reference_ids = array();
            $stocks = 0;
            $stockIn = 0;
            foreach ($inventories as $inventory) {
                $totalAttributes = DB::table('inventory_detail')->where('inventory_detail.inventory_ref_id', '=', $inventory->inventory_ref_id)->count();
                if ($postAttributes > $totalAttributes) {
                    $count = $postAttributes;
                } elseif ($postAttributes < $totalAttributes or $postAttributes == $totalAttributes) {
                    $count = $totalAttributes;
                }
                
                $individualStock = DB::table('inventory')->leftjoin('inventory_detail', 'inventory_detail.inventory_ref_id', '=', 'inventory.inventory_ref_id')
                    ->selectRaw('inventory.*')
                    ->whereIn('inventory_detail.attribute_id', [$attributeid])
                    ->where(DB::raw('(select count(*) from `inventory_detail` where `inventory_detail`.`attribute_id` in (' . $attributeid . ') and `inventory_ref_id`= "' . $inventory->inventory_ref_id . '")'), '=', $count)
                    ->where('inventory.inventory_ref_id', '=', $inventory->inventory_ref_id)
                    ->groupBy('inventory_detail.inventory_ref_id')
                    ->get();
               
                if (count($individualStock) > 0) {
                    $inventory_ref_id = $individualStock[0]->inventory_ref_id;
                    $stockIn += $individualStock[0]->stock;
                }
               
                // if (count($individualStock) > 0) {
                //     if ($individualStock[0]->stock_type == 'in') {
                //         $stockIn += $individualStock[0]->stock;
                //     }
                //     if ($individualStock[0]->stock_type == 'out') {
                //         $stockOut += $individualStock[0]->stock;
                //     }
                //     $inventory_ref_id[] = $individualStock[0]->inventory_ref_id;
                // }
            }

            //get option name and value
            $options_names = array();
            $options_values = array();
            foreach ($attributes as $attribute) {
                $productsAttributes = DB::table('products_attributes')
                    ->leftJoin('products_options', 'products_options.option_id', '=', 'products_attributes.option_id')
                    ->leftJoin('products_options_values', 'products_options_values.option_value_id', '=', 'products_attributes.option_value_id')
                    ->select('products_attributes.*', 'products_options.option_name', 'products_options_values.option_value_name')
                    ->where('products_attributes_id', $attribute)->get();

                $options_names[] = $productsAttributes[0]->option_name;
                $options_values[] = $productsAttributes[0]->option_value_name;
            }

            $options_names_count = count($options_names);
            $options_names = implode("','", $options_names);
            $options_names = "'" . $options_names . "'";
            $options_values = "'" . implode("','", $options_values) . "'";

            //orders products
            $orders_products = DB::table('orders_products')->where('product_id', $product_id)->get();
            $stockOut = 0;
            foreach ($orders_products as $orders_product) {
                $totalAttributes = DB::table('orders_products_attributes')->where('product_id', '=', $orders_product->orders_products_id)->count();
                if ($postAttributes > $totalAttributes) {
                    $count = $postAttributes;
                } elseif ($postAttributes < $totalAttributes or $postAttributes == $totalAttributes) {
                    $count = $totalAttributes;
                }
                $products = DB::select("select orders_products.* from `orders_products` left join `orders_products_attributes` on `orders_products_attributes`.`order_product_id` = `orders_products`.`orders_products_id` where `orders_products`.`product_id`='" . $product_id . "' and `orders_products_attributes`.`product_option` in (" . $options_names . ") and `orders_products_attributes`.`product_option_value` in (" . $options_values . ") and (select count(*) from `orders_products_attributes` where `orders_products_attributes`.`product_id` = '" . $product_id . "' and `orders_products_attributes`.`product_option` in (" . $options_names . ") and `orders_products_attributes`.`product_option_value` in (" . $options_values . ") and `orders_products_attributes`.`order_product_id`= '" . $orders_product->orders_products_id . "') = " . $count . " and `orders_products`.`orders_products_id` = '" . $orders_product->orders_products_id . "' group by `orders_products_attributes`.`order_product_id`");
                if (count($products) > 0) {
                    $stockOut += $products[0]->product_quantity;
                }
            }
            $stocks = $stockIn - $stockOut;
        } else {
            $stocks = 0;
            $stocksin = DB::table('inventory')->where('product_id', $product_id)->where('stock_type', 'in')->sum('stock');
            $stockOut = DB::table('inventory')->where('product_id', $product_id)->where('stock_type', 'out')->sum('stock');
            $stocks = $stocksin - $stockOut;
        }
        $responseData = array('success' => '1', 'stock' => $stocks, 'message' => "Attributes are returned successfull!");
        $response = $responseData;

        return $response;
    }

	function productQuantity(Request $request){
		
		if(!empty($request->product_id) && !empty($request->attributeid)){
			
		$inventory_ref_id = '';
		$product_id = $request->product_id;
		$attributes = array_filter($request->attributeid);
		$attributeid = implode(',',$attributes);
		$postAttributes = count($attributes);
				
		$inventories = DB::table('inventory')->where('product_id',$product_id)->get();
		
		$reference_ids = array();
		$stockIn = 0;
		$stockOut = 0;
		$inventory_ref_id = array();
		foreach($inventories as $inventory){
			
			$totalAttribute = DB::table('inventory_detail')->where('inventory_detail.inventory_ref_id','=',$inventory->inventory_ref_id)->get();
			$totalAttributes = count($totalAttribute);
			
			if($postAttributes>$totalAttributes){
				$count = $postAttributes;
			}elseif($postAttributes<$totalAttributes or $postAttributes==$totalAttributes){
				$count = $totalAttributes;
			}			
			
			$individualStock = DB::table('inventory')
			    ->leftjoin('inventory_detail','inventory_detail.inventory_ref_id','=','inventory.inventory_ref_id')
				->selectRaw('inventory.*')
				->whereIn('inventory_detail.attribute_id', [$attributeid])
				->where(DB::raw('(select count(*) from `inventory_detail` where `inventory_detail`.`attribute_id` in ('.$attributeid.') and `inventory_ref_id`= "'.$inventory->inventory_ref_id.'")'),'=',$count)
				->where('inventory.inventory_ref_id','=',$inventory->inventory_ref_id)				
				->groupBy('inventory_detail.inventory_ref_id')
				->get();		
				
			if(count($individualStock)>0){	
		
				if($individualStock[0]->stock_type=='in'){
					$stockIn += $individualStock[0]->stock;
				}
					
				if($individualStock[0]->stock_type=='out'){
					$stockOut += $individualStock[0]->stock;
				}
							
				$inventory_ref_id[] = $individualStock[0]->inventory_ref_id;
			}
			
		}
			
		//get option name and value
		$options_names  = array();
		$options_values = array(); 
		foreach($attributes as $attribute){
			$productsAttributes = DB::table('products_attributes')
					->leftJoin('products_options','products_options.option_id','=','products_attributes.option_id')
					->leftJoin('products_options_values','products_options_values.option_value_id','=','products_attributes.option_value_id')
					->select('products_attributes.*', 'products_options.option_name', 'products_options_values.option_value_name')
					->where('products_attributes_id',$attribute)->get();
			
			
			$options_names[] = $productsAttributes[0]->option_name;
			$options_values[] = $productsAttributes[0]->option_value_name;
		}
		
		$options_names_count = count($options_names);
		$options_names = implode ( "','", $options_names);
		$options_names = "'" . $options_names . "'";
		$options_values = "'" . implode ( "','", $options_values ) . "'";
				
		//orders products
		$orders_products = DB::table('orders_products')->where('product_id',$product_id)->get();
		$result = array();
	
		$result['remainingStock'] = $stockIn - $stockOut;
		
		 if (!empty($inventory_ref_id) && isset($inventory_ref_id[0])) {
                $minMax = DB::table('manage_min_max')->where([['inventory_ref_id', $inventory_ref_id[0]], ['product_id', $product_id]])->get();
            } else {
                $minMax = '';
            }
            $result['inventory_ref_id'] = $inventory_ref_id;
            $result['minMax'] = $minMax;
            $result['minMaxLevel'] = $minMax;

        } else {
            $result['inventory_ref_id'] = 0;
            $result['minMax'] = 0;
            $result['remainingStock'] = 0;
        }

        return $result;
	}
	
    
}
