<?php

namespace App\Http\Controllers\Web;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Password;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Lang;
use App\Models\Customer;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
class PasswordController extends DataController
{
    public function showResetPasswordForm(){
        $pageTitle = Lang::get('website.Reset Password');
        $commonContent = $this->commonContent();
        return view('web.customer.passwords.email',compact('pageTitle','commonContent'));
    }
    public function sendResetLinkEmail(Request $request){
        session(['forgot_pasword_request' => 'customer']);
        $data = $this->validate($request, [
            'email'     =>  'required|email',
          ]);
        $response = Password::broker('customers')->sendResetLink(
            $request->only('email')
        );
        return $response == Password::RESET_LINK_SENT
                    ? $this->sendResetLinkResponse($request, $response)
                    : $this->sendResetLinkFailedResponse($request, $response);
    }
    
    protected function sendResetLinkResponse(Request $request, $response){
        return $request->wantsJson()
                    ? new JsonResponse(['message' => trans($response)], 200)
                    : back()->with('status', trans($response));
    }
    
    protected function sendResetLinkFailedResponse(Request $request, $response){
        if ($request->wantsJson()) {
            throw ValidationException::withMessages([
                'email' => [trans($response)],
            ]);
        }
        return back()->withInput($request->only('email'))->withErrors(['email' => trans($response)]);
    }

    public function showResetForm(Request $request){
        
        $pageTitle = Lang::get('website.Reset Password');
        $commonContent = $this->commonContent();
        $token = $request->route()->parameter('token');
        $email  = $request->email;
        return view('web.customer.passwords.reset',compact('pageTitle','commonContent','token','email'));
    }
    
    public function resetPassword(Request $request){
        session()->forget('forgot_pasword_request');
         $data = $this->validate($request, [
            'token'     => 'required',
            'email'     => 'required|email',
            'password'  => 'required|confirmed|min:8',
          ]);
            $response = Password::broker('customers')->reset(
            $request->only('email', 'password', 'password_confirmation', 'token'), function ($user, $password) {
                $user->password = Hash::make($password);
                $user->setRememberToken(Str::random(60));
                $user->save();
                event(new PasswordReset($user));
                Auth::guard('customer')->login($user);
            }
        );
        return $response == Password::PASSWORD_RESET
                    ? $this->sendResetResponse($request, $response)
                    : $this->sendResetFailedResponse($request, $response);
    }
    
    protected function sendResetResponse(Request $request, $response)
    {
        if ($request->wantsJson()) {
            return new JsonResponse(['message' => trans($response)], 200);
        }
        return redirect('/')->with('status', trans($response));
    }
    protected function sendResetFailedResponse(Request $request, $response)
    {
        if ($request->wantsJson()) {
            throw ValidationException::withMessages([
                'email' => [trans($response)],
            ]);
        }
        return redirect()->back()->withInput($request->only('email'))->withErrors(['email' => trans($response)]);
    }

   
    
}
