<?php

namespace App\Http\Controllers\Web;
use Illuminate\Support\Facades\Collection;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Notification;
use App\Notifications\DatabaseNotification;
use App\Models\Order;
use App\Models\Language;
use Illuminate\Http\Request;
use PulkitJalan\GeoIP\GeoIP;
use Lang;
use DB;
use Auth;
use Session;
class OrderController extends DataController
{

    public function checkout(Request $request){ 
        
        $pageTitle = Lang::get('website.Wishlist');
        $commonContent = $this->commonContent();
        
        $result = array();

        //cart data
        $myVar = new CartController();
        $result['cart'] = $myVar->myCart($result);
        
        if (count($result['cart']) == 0) {
            
            return redirect("/");
        } else {

            //apply coupon
            if (!empty(session('coupon')) and count(session('coupon')) > 0) {
                $session_coupon_data = session('coupon');
                session(['coupon' => array()]);
                $response = array();
                if (!empty($session_coupon_data)) {
                    foreach ($session_coupon_data as $key => $session_coupon) {
                        $response = $this->common_apply_coupon($session_coupon->code);
                    }
                }
            }

            $commonContent = $this->commonContent();

            $address = array();

            if (empty(session('step'))) {
                session(['step' => '0']);
            }

            if(auth()->guard('customer')->check()){
                $myVar = new ShippingAddressController();
                $all_addresses = $myVar->getShippingAddress(array());
                
                if (!empty($all_addresses) and count($all_addresses)>0) {
                    foreach($all_addresses as $default_address){
                        if($default_address->default_address==1){                        
                            $default_address->delivery_phone = auth()->guard('customer')->user()->phone;
                            $address = $default_address;
                        }
                    }
                    
                }
            }
            
            if (empty(session('shipping_address'))) {
                session(['shipping_address' => $address]);
            }

            //shipping counties
            if (!empty(session('shipping_address')->countries_id)) {
                $countries_id = session('shipping_address')->countries_id;
            } else {
                $countries_id = '';
            }
            $myVar = new ShippingAddressController;
            $result['countries'] = $myVar->countries();
            $result['zones'] = $myVar->zones($countries_id);

            //get tax
            if (!empty(session('shipping_address')->zone_id)) {
                $tax_zone_id = session('shipping_address')->zone_id;
                $tax = $this->calculateTax($tax_zone_id);
                session(['tax_rate' => $tax]);
            } else {
                session(['tax_rate' => '0']);
            }
            //shipping methods
            $result['shipping_methods'] = $this->shipping_methods();
            $payment_methods = $this->getPaymentMethods();           

            //price
            $price = 0;
            $gift_price=0;
            if (count($result['cart']) > 0) {
                foreach ($result['cart'] as $products) {
                    $req = array();
                    $attr = array();
                    $req['product_id'] = $products->product_id;
                    if (isset($products->attributes)) {
                        foreach ($products->attributes as $key => $value) {
                            $attr[$key] = $value->products_attributes_id;
                        }
                        $req['attributes'] = $attr;
                    }
                    $myVar = new ProductController();
                    $check = $myVar->getquantity($req);
                    
                    if ($products->basket_quantity > $check['stock']) {
                        session(['out_of_stock' => 1]);
                        session(['out_of_stock_product' => $products->product_id]);
                        return redirect('viewCart');
                    }
                    $price += $products->final_price * $products->basket_quantity;
                    $gift_price += $products->gift_price * $products->basket_quantity;
                  
                }
                session(['product_price' => $price]);
                session(['gift_price'=> $gift_price]);
            }

        $geoip = new GeoIP(); 
        $CurrentCountry = $geoip->getCountry();
//         $curr=file_get_contents('https://free.currconv.com/api/v7/convert?q=QAR_USD&compact=ultra&apiKey=4f2d72cf8f2234e73240');
// 		$cr=json_decode($curr);
		$currValue = 999;//$cr->QAR_USD;
        return view('web.orders.checkout',compact('pageTitle','commonContent','result','CurrentCountry','payment_methods','currValue'));
           
        }

    }
    

    public function checkout_shipping_address(Request $request){
        $title = array('pageTitle' => Lang::get('website.Checkout'));
        $result = array();
        $result['commonContent'] = $this->index->commonContent();

        if (session('step') == '0') {
            session(['step' => '1']);
        }

        foreach ($request->all() as $key => $value) {
            $shipping_data[$key] = $value;

            //billing address
            if ($key == 'firstname') {
                $billing_data['billing_firstname'] = $value;
            } else if ($key == 'lastname') {
                $billing_data['billing_lastname'] = $value;
            } else if ($key == 'company') {
                $billing_data['billing_company'] = $value;
            } else if ($key == 'street') {
                $billing_data['billing_street'] = $value;
            } else if ($key == 'countries_id') {
                $billing_data['billing_countries_id'] = $value;
            } else if ($key == 'zone_id') {
                $billing_data['billing_zone_id'] = $value;
            } else if ($key == 'city') {
                $billing_data['billing_city'] = $value;
            } else if ($key == 'postcode') {
                $billing_data['billing_zip'] = $value;
            } else if ($key == 'delivery_phone') {
                $billing_data['billing_phone'] = $value;
            }
        }

        if (empty(session('billing_address')) or session('billing_address')->same_billing_address == 1) {
            $billing_address = (object) $billing_data;
            $billing_address->same_billing_address = 1;
            session(['billing_address' => $billing_address]);
        }

        $address = (object) $shipping_data;
        session(['shipping_address' => $address]);

        return redirect()->back();
    }

    public function checkout_billing_address(Request $request){
        if (session('step') == '1') {
            session(['step' => '2']);
        }

        if (empty($request->same_billing_address)) {

            foreach ($request->all() as $key => $value) {
                $billing_data[$key] = $value;
            }

            $billing_address = (object) $billing_data;
            $billing_address->same_billing_address = 0;
            session(['billing_address' => $billing_address]);
        } else {

            $billing_address = session('billing_address');
            $billing_address->same_billing_address = 1;
            session(['billing_address' => $billing_address]);
        }

        return redirect()->back();
    }

    public function shipping_methods(){

        $result = array();
        if (!empty(session('shipping_address'))) {
            $countries_id = session('shipping_address')->countries_id;
            $toPostalCode = session('shipping_address')->postcode;
            $toCity = session('shipping_address')->city;
            $toAddress = 'gh';
            $countries = $this->order->getCountries($countries_id);
            $toCountry = $countries[0]->countries_iso_code_2;
            $zone_id = session('shipping_address')->zone_id;
            if ($zone_id != -1 and !empty($zone_id)) {
                $zones = $this->order->getZones($zone_id);
                $toState = $zones[0]->zone_code;
            }
        } else {
            $countries_id = '';
            $toPostalCode = '';
            $toCity = '';
            $toAddress = '';
            $toCountry = '';
            $zone_id = '';
        }

        //product weight
        $myVar = new CartController();
		$cart = $myVar->myCart($result);

        $index = '0';
        

        //website path
        //$websiteURL =  "http://" . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
        $websiteURL = "https://" . $_SERVER['SERVER_NAME'] . '/';
        $replaceURL = str_replace('getRate', '', $websiteURL);
        $requiredURL = $replaceURL . 'app/ups/ups.php';

        //default shipping method
        $shippings = DB::table('shipping_methods')->get();
        $result = array();
        $mainIndex = 0;
        foreach ($shippings as $shipping_methods) {

            $shippings_detail = DB::table('shipping_description')
            ->where('language_id', Session::get('locale'))
            ->where('table_name', $shipping_methods->table_name)
            ->orwhere('language_id', 1)
            ->where('table_name', $shipping_methods->table_name)->get();

            //ups shipping rate
            if ($shipping_methods->methods_type_link == 'upsShipping' and $shipping_methods->status == '1') {

                $result2 = array();
                $is_transaction = '0';

                $ups_shipping = $this->order->getUpsShipping();

                //shipp from and all credentials
                $accessKey = $ups_shipping[0]->access_key;
                $userId = $ups_shipping[0]->user_name;
                $password = $ups_shipping[0]->password;

                //ship from address
                $fromAddress = $ups_shipping[0]->address_line_1;
                $fromPostalCode = $ups_shipping[0]->post_code;
                $fromCity = $ups_shipping[0]->city;
                $fromState = $ups_shipping[0]->state;
                $fromCountry = $ups_shipping[0]->country;

                //production or test mode
                if ($ups_shipping[0]->shippingEnvironment == 1) { #production mode
                $useIntegration = true;
                } else {
                    $useIntegration = false; #test mode
                }

                $serviceData = explode(',', $ups_shipping[0]->serviceType);

                $index = 0;
                foreach ($serviceData as $value) {
                    if ($value == "US_01") {
                        $name = Lang::get('website.Next Day Air');
                        $serviceTtype = "1DA";
                    } else if ($value == "US_02") {
                        $name = Lang::get('website.2nd Day Air');
                        $serviceTtype = "2DA";
                    } else if ($value == "US_03") {
                        $name = Lang::get('website.Ground');
                        $serviceTtype = "GND";
                    } else if ($value == "US_12") {
                        $name = Lang::get('website.3 Day Select');
                        $serviceTtype = "3DS";
                    } else if ($value == "US_13") {
                        $name = Lang::get('website.Next Day Air Saver');
                        $serviceTtype = "1DP";
                    } else if ($value == "US_14") {
                        $name = Lang::get('website.Next Day Air Early A.M.');
                        $serviceTtype = "1DM";
                    } else if ($value == "US_59") {
                        $name = Lang::get('website.2nd Day Air A.M.');
                        $serviceTtype = "2DM";
                    } else if ($value == "IN_07") {
                        $name = Lang::get('website.Worldwide Express');
                        $serviceTtype = "UPSWWE";
                    } else if ($value == "IN_08") {
                        $name = Lang::get('website.Worldwide Expedited');
                        $serviceTtype = "UPSWWX";
                    } else if ($value == "IN_11") {
                        $name = Lang::get('website.Standard');
                        $serviceTtype = "UPSSTD";
                    } else if ($value == "IN_54") {
                        $name = Lang::get('website.Worldwide Express Plus');
                        $serviceTtype = "UPSWWEXPP";
                    }

                    $some_data = array(
                        'access_key' => $accessKey, # UPS License Number
                        'user_name' => $userId, # UPS Username
                        'password' => $password, # UPS Password
                        'pickUpType' => '03', # Drop Off Location
                        'shipToPostalCode' => $toPostalCode, # Destination  Postal Code
                        'shipToCountryCode' => $toCountry, # Destination  Country
                        'shipFromPostalCode' => $fromPostalCode, # Origin Postal Code
                        'shipFromCountryCode' => $fromCountry, # Origin Country
                        'residentialIndicator' => 'IN', # Residence Shipping and for commercial shipping "COM"
                        'cServiceCodes' => $serviceTtype, # Sipping rate for UPS Ground
                        'packagingType' => '02',
                        'packageWeight' => $productsWeight,
                    );

                    $curl = curl_init();
                    // You can also set the URL you want to communicate with by doing this:
                    // $curl = curl_init('http://localhost/echoservice');

                    // We POST the data
                    curl_setopt($curl, CURLOPT_POST, 1);
                    // Set the url path we want to call
                    curl_setopt($curl, CURLOPT_URL, $requiredURL);
                    // Make it so the data coming back is put into a string
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    // Insert the data
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $some_data);

                    // You can also bunch the above commands into an array if you choose using: curl_setopt_array

                    // Send the request
                    $rate = curl_exec($curl);
                    // Free up the resources $curl is using
                    curl_close($curl);

                    if (is_numeric($rate)) {
                        $success = array('success' => '1', 'message' => "Rate is returned.", 'name' => $shippings_detail[0]->name, 'is_default' => $shipping_methods->isDefault);
                        $result2[$index] = array('name' => $name, 'rate' => $rate, 'currencyCode' => 'USD', 'shipping_method' => 'upsShipping');
                        $index++;
                    } else {
                        $success = array('success' => '0', 'message' => "Selected regions are not supported for UPS shipping", 'name' => $shippings_detail[0]->name);
                    }
                    $success['services'] = $result2;
                }
                $result[$mainIndex] = $success;
                $mainIndex++;

            } else if ($shipping_methods->methods_type_link == 'flateRate' and $shipping_methods->status == '1') {
                $ups_shipping = $this->order->getUpsShippingRate();
                $data2 = array('name' => $shippings_detail[0]->name, 'rate' => $ups_shipping[0]->flate_rate, 'currencyCode' => $ups_shipping[0]->currency, 'shipping_method' => 'flateRate');
                if (count($ups_shipping) > 0) {
                    $success = array('success' => '1', 'message' => "Rate is returned.", 'name' => $shippings_detail[0]->name, 'is_default' => $shipping_methods->isDefault);
                    $success['services'][0] = $data2;
                    $result[$mainIndex] = $success;
                    $mainIndex++;
                }

            } else if ($shipping_methods->methods_type_link == 'localPickup' and $shipping_methods->status == '1') {

                $data2 = array('name' => $shippings_detail[0]->name, 'rate' => '0', 'currencyCode' => 'USD', 'shipping_method' => 'localPickup');
                $success = array('success' => '1', 'message' => "Rate is returned.", 'name' => $shippings_detail[0]->name, 'is_default' => $shipping_methods->isDefault);
                $success['services'][0] = $data2;
                $result[$mainIndex] = $success;
                $mainIndex++;

            } else if ($shipping_methods->methods_type_link == 'freeShipping' and $shipping_methods->status == '1') {

                $data2 = array('name' => $shippings_detail[0]->name, 'rate' => '0', 'currencyCode' => 'USD', 'shipping_method' => 'freeShipping');
                $success = array('success' => '1', 'message' => "Rate is returned.", 'name' => $shippings_detail[0]->name, 'is_default' => $shipping_methods->isDefault);
                $success['services'][0] = $data2;
                $result[$mainIndex] = $success;
                $mainIndex++;
            } else if ($shipping_methods->methods_type_link == 'shippingByWeight' and $shipping_methods->status == '1') {

                //cart data
                $carts = $this->cart->myCart('');

                $weight = 0;
                foreach ($carts as $cart) {
                    $weight += $cart->weight * $cart->customers_basket_quantity;
                }

                //check price by weight
                $priceByWeight = $this->order->priceByWeight($weight);

                if (!empty($priceByWeight) and count($priceByWeight) > 0) {
                    $price = $priceByWeight[0]->weight_price;
                } else {
                    $price = 0;
                }

                $data2 = array('name' => $shippings_detail[0]->name, 'rate' => $price, 'currencyCode' => 'USD', 'shipping_method' => 'Shipping By Weight');
                $success = array('success' => '1', 'message' => "Rate is returned.", 'name' => $shippings_detail[0]->name, 'is_default' => $shipping_methods->isDefault);
                $success['services'][0] = $data2;
                $result[$mainIndex] = $success;
                $mainIndex++;
            }
        }

        return $result;
    }

    public function getPaymentMethods(){
       $payments_methods = DB::table('payment_methods')
            ->leftjoin('payment_description', 'payment_description.payment_method_id', '=', 'payment_methods.id')
            ->select('payment_description.name', 'payment_methods.environment','payment_methods.payment_method','payment_methods.currency','payment_methods.public_key')
            ->where('payment_description.language_id', Session::get('locale'))
            ->where('payment_methods.status', 'Active')
            ->get();
        return $payments_methods;
    }
    
    public function paymentComponent(Request $request){		
		$currValue=file_get_contents('https://free.currconv.com/api/v7/convert?q=QAR_USD&compact=ultra&apiKey=74f78da152b1bf841830');
		echo $currValue;
	}
    
    public function place_order(Request $request){
        
        $this->validate($request, [
            'billing_first_name'    =>  'required|string|max:50|regex:/^[\pL\s\-]+$/u',
            'billing_last_name'     =>  'required|string|max:50|regex:/^[\pL\s\-]+$/u',
            'billing_email'         =>  'required|string|email|max:50|',
            'billing_phone'         =>  'string|max:15',
            'billing_country_id'    =>  'numeric',
            'billing_zone_id'       =>  'required|numeric',
            'billing_street_address'=>  'required|string',
          ]);
         if($request->shipping == 'Yes'){
            $this->validate($request, [
            'delivery_first_name'    =>  'required|string|max:50|regex:/^[\pL\s\-]+$/u',
            'delivery_last_name'     =>  'required|string|max:50|regex:/^[\pL\s\-]+$/u',
            'delivery_phone'         =>  'string|max:15',
            'delivery_country_id'    =>  'required|numeric',
            'delivery_zone_id'       =>  'required|numeric',
            'delivery_street_address'=>  'required|string',
          ]); 
         }
        $cart = new CartController();
        $result = array();
        $cart_items = $cart->myCart($result);
        $result['cart'] = $cart_items;
        
        if (count($result['cart']) > 0) {
            foreach ($result['cart'] as $products) {
                $req = array();
                $attr = array();
                $req['product_id'] = $products->product_id;
                if (isset($products->attributes)) {
                    foreach ($products->attributes as $key => $value) {
                        $attr[$key] = $value->products_attributes_id;
                    }
                    $req['attributes'] = $attr;

                }
                $myVar = new ProductController();
                $check = $myVar->getquantity($req);
                if ($products->basket_quantity > $check['stock']) {
                    session(['out_of_stock' => 1]);
                    session(['out_of_stock_product' => $products->product_id]);
                    return redirect('viewcart');
                }
            }
        }
       
        if (Session::get('guest_checkout') == 1) {
            $email = session('shipping_address')->email;
            $check = DB::table('users')->where('role_id', 2)->where('email', $email)->first();
            if ($check == null) {
                $customers_id = DB::table('users')
                    ->insertGetId([
                        'role_id' => 2,
                        'email' => $email = session('shipping_address')->email,
                        'password' => Hash::make('123456dfdfdf'),
                        'first_name' => session('shipping_address')->firstname,
                        'last_name' => session('shipping_address')->lastname,
                        'phone' => session('billing_address')->billing_phone,
                    ]);
                session(['customers_id' => $customers_id]);
            } else {
                $customers_id = $check->id;
                $email = $check->email;
                session(['customers_id' => $customers_id]);
            }
        } else {
            $customer_id    = Auth::guard('customer')->user()->id;
            $name           = Auth::guard('customer')->user()->first_name.' '.Auth::guard('customer')->user()->last_name ? : $request->billing_first_name . ' ' . $request->billing_last_name;
            $email          = Auth::guard('customer')->user()->email;
            $phone          = Auth::guard('customer')->user()->phone ? : $request->billing_phone;
        }
        
    //========================country and Zone=======================
        $delivery = DB::table('zones')->where('id', '=', $request->delivery_zone_id)->get();
        if (count($delivery) > 0) {
            $delivery_state = $delivery[0]->name;
        } else {
            $delivery_state = 'Other';
        }
        $d_country = DB::table('countries')->where('id', '=', $request->delivery_country_id)->get();
        if (count($d_country) > 0) {
            $delivery_country = $d_country[0]->name;
        } else {
            $delivery_country = 'other';
        }

        $billing = DB::table('zones')->where('id', '=', $request->billing_zone_id)->get();
        if (count($billing) > 0) {
            $billing_state = $billing[0]->name;
        } else {
            $billing_state = 'other';
        }
        $b_country = DB::table('countries')->where('id', '=', $request->billing_country_id)->get();
        if (count($b_country) > 0) {
            $billing_country = $b_country[0]->name;
        } else {
            $billing_country = 'other';
        }
    //========================country and Zone=======================
        $order_information = array();

        if (!empty($request->cc_type)) {
            $cc_type = $request->cc_type;
            $cc_owner = $request->cc_owner;
            $cc_number = $request->cc_number;
            $cc_expires = $request->cc_expires;
        } else {
            $cc_type = '';
            $cc_owner = '';
            $cc_number = '';
            $cc_expires = '';
        }
        //price
        if (!empty(session('shipping_detail'))) {
            $shipping_price = session('shipping_detail')->shipping_price;
        } else {
            $shipping_price = 0;
        }
        $tax_rate = number_format((float) session('tax_rate'), 2, '.', '');
        $coupon_discount = number_format((float) session('coupon_discount'), 2, '.', '');
        $gift_price = number_format((float) session('gift_price'), 2, '.', '');
        $order_price = (session('product_price') + $tax_rate + $shipping_price + $gift_price) - $coupon_discount;

        $shipping_cost = '0';//session('shipping_detail')->shipping_price;
        $shipping_method = 'UPS';//session('shipping_detail')->shipping_method;
        //$orders_date_finished                =   $request->orders_date_finished;
        if (!empty(session('order_comments'))) {
            $comments = session('order_comments');
        } else {
            $comments = '';
        }

        $web_setting = DB::table('currencies')->get();
        $currency = $web_setting[0]->code;
        $total_tax = number_format((float) session('tax_rate'), 2, '.', '');
        $products_tax = 1;

        $coupon_amount = 0;
        $code = '';
        // if (!empty(session('coupon')) and count(session('coupon')) > 0) {

        //     $code = array();
        //     $exclude_product_ids = array();
        //     $product_categories = array();
        //     $excluded_product_categories = array();
        //     $exclude_product_ids = array();

        //     $coupon_amount = number_format((float) session('coupon_discount'), 2, '.', '') + 0;

        //     foreach (session('coupon') as $coupons_data) {

        //         //update coupans
        //         $coupon_id = DB::statement("UPDATE `coupons` SET `used_by`= CONCAT(used_by,',$customers_id') WHERE `code` = '" . $coupons_data->code . "'");

        //     }
        //     $code = json_encode(session('coupon'));

        // } else {
        //     $code = '0';
        //     $coupon_amount = '0';
        // }
        //payment methods
        if ($request->payment_method == 'cash_on_delivery') {
            $payment_method_name    = 'Cash on Delivery';
            $payment_status         = 'success';
            $orders_status          = 'Pending';
        } elseif ($request->payment_method == 'self_pickup'){
            $payment_method_name    = 'Self Pickup';
            $payment_status         = 'success';
            $orders_status          = 'Pending';
        } else if ($request->payment_method == 'paypal') {
            $payment_method_name    = 'Paypal';
            $payment_status         = 'success';
            $order_information      = json_decode($request->nonce, JSON_UNESCAPED_SLASHES);
            $orders_status          = 'Pending';
        }   
        //check if order is verified
        if ($payment_status == 'success') {            
            $order_id = DB::table('orders')->insertGetId([
                    'customer_id'               => $customer_id,
                    'name'                      => $name,
                    'phone'                     => $phone,
                    'email'                     => $email,
                    'street_address'            => $request->billing_street_address,
                    'suburb'                    => '',
                    'city'                      => 'Other',
                    'postcode'                  => $request->billing_postcode,
                    'state'                     => 'Other',
                    'country'                   => $b_country[0]->name,
                //'customers_address_format_id' => $delivery_address_format_id,
                    'billing_name'              => $request->billing_first_name . ' ' . $request->billing_last_name,
                    'billing_street_address'    => $request->billing_street_address,
                    'billing_suburb'            => '',
                    'billing_city'              => $billing_state,
                    'billing_postcode'          => $request->billing_postcode,
                    'billing_state'             => $billing_state,
                    'billing_country'           => $billing_country,
                    'billing_phone'             => $request->billing_phone,
                //'billing_address_format_id'   => $billing_address_format_id,
                    'delivery_name'             => $request->delivery_first_name . ' ' . $request->delivery_last_name ? : $request->billing_first_name . ' ' . $request->billing_last_name,
                    'delivery_company'          => $request->delivery_company,
                    'delivery_street_address'   => $request->delivery_street_address ? : $request->billing_street_address,
                    'delivery_suburb'           => '',
                    'delivery_city'             => $billing_state ? : $billing_state,
                    'delivery_postcode'         => $request->delivery_postcode ? : $request->billing_postcode,
                    'delivery_state'            => $delivery_state,
                    'delivery_country'          => $delivery_country,
                    'delivery_phone'            => $request->delivery_phone ? : $request->billing_phone,
                // 'delivery_address_format_id' => $delivery_address_format_id,
                    'payment_method'            => $payment_method_name,
                    'cc_type'                   => $cc_type,
                    'cc_owner'                  => $cc_owner,
                    'cc_number'                 => $cc_number,
                    'cc_expires'                => $cc_expires,
                    'order_price'               => $order_price,
                    'gift_price'                => $gift_price,
                    'shipping_cost'             => $shipping_cost,
                    'shipping_method'           => $shipping_method,
                    // 'orders_status'          => $orders_status,
                    //'orders_date_finished'    => $orders_date_finished,
                    'currency'                  => $currency,
                    'order_information'         => json_encode($order_information),
                    'coupon_code'               => $code,
                    'coupon_amount'             => $coupon_amount,
                    'total_tax'                 => $total_tax,
                    'ordered_source'            => '1',
                    'created_at'                => date('Y-m-d H:i:s'),
                   
                ]);

            //orders status history
            $orders_history_id = DB::table('orders_status_history')->insertGetId(
                [
                    'order_id'                  => $order_id,
                    'status'                    => $orders_status,
                    'date_added'                => date('Y-m-d H:i:s'),
                    'customer_notified'         => '1',
                    'comments'                  => $request->order_notes,
                ]);
                
            foreach ($cart_items as $products) {
                $orders_products_id = DB::table('orders_products')->insertGetId([
                        'order_id'          => $order_id,
                        'product_id'        => $products->product_id,
                        'product_name'      => $products->name,
                        'product_price'     => $products->price,
                        'gift_price'        => $products->gift_price* $products->basket_quantity,
                        'final_price'       => $products->final_price * $products->basket_quantity,
                        'gift_comments'     => $request->gift_comments,
				        'gift_color'        => $request->gift_color,
                        'product_tax'       => $products_tax,
                        'product_quantity'  => $products->basket_quantity,
                        'vendor_id'         => $products->vendor_id,
                        
                    ]);
                $inventory_ref_id = DB::table('inventory')->insertGetId([
                        'product_id'        => $products->product_id,
                        'reference_code'    => '',
                        'stock'             => $products->basket_quantity,
                        'admin_id'          => 0,
                        'added_date'        => time(),
                        'purchase_price'    => 0,
                        'stock_type'        => 'out',
                ]);

                if (Session::get('guest_checkout') == 1) {
                    DB::table('customers_basket')->where('session_id', Session::getId())->where('product_id', $products->product_id)->update(['is_order' => '1']);
                } else {
                    DB::table('customers_basket')->where('customer_id', $customer_id)->where('product_id', $products->product_id)->update(['is_order' => '1']);
                }

                if (!empty($products->attributes) and count($products->attributes)>0) {

                    foreach ($products->attributes as $attribute) {
                        DB::table('orders_products_attributes')->insert([   
                                'order_id'              => $order_id,
                                'product_id'            => $products->product_id,
                                'order_product_id'      => $orders_products_id,
                                'product_option'        => $attribute->attribute_name,
                                'product_option_value'  => $attribute->attribute_value,
                                'option_value_price'    => $attribute->value_price,
                                'price_prefix'          => $attribute->prefix,
                            ]);

                        DB::table('inventory_detail')->insert([
                            'inventory_ref_id'          => $inventory_ref_id,
                            'product_id'                => $products->product_id,
                            'attribute_id'              => $attribute->products_attributes_id,
                        ]);
                    }
                }

            }

        $message = array('message' => 'Your Order has been Placed successfully','type' => 'success');
          
            //send order email to user
            $order = DB::table('orders')
                ->LeftJoin('orders_status_history', 'orders_status_history.order_id', '=', 'orders.id')
                ->where('orders.id', '=', $order_id)->orderby('orders_status_history.date_added', 'DESC')->get();

            //foreach
            foreach ($order as $data) {
                $order_id = $data->id;

                $orders_products = DB::table('orders_products')
                    ->join('products', 'products.id', '=', 'orders_products.product_id')
                    ->select('orders_products.*', 'products.image')
                    ->where('orders_products.order_id', '=', $order_id)->get();
                $i = 0;
                $total_price = 0;
                $product = array();
                $subtotal = 0;
                foreach ($orders_products as $orders_products_data) {
                    $product_attribute = DB::table('orders_products_attributes')
                        ->where([
                            ['order_product_id', '=', $orders_products_data->product_id],
                            ['order_id', '=', $orders_products_data->order_id],
                        ])->get();

                    $orders_products_data->attribute = $product_attribute;
                    $product[$i] = $orders_products_data;
                    //$total_tax     = $total_tax+$orders_products_data->products_tax;
                    $total_price = $total_price + $orders_products[$i]->final_price;
                    $subtotal += $orders_products[$i]->final_price;
                    $i++;
                }

                $data->data = $product;
                $orders_data[] = $data;
            }

            $orders_status_history = DB::table('orders_status_history')->orderBy('orders_status_history.date_added', 'desc')->where('order_id', '=', $order_id)->get();
            $ordersData['orders_data'] = $orders_data;
            $ordersData['total_price'] = $total_price;
            $ordersData['orders_status'] = 'Pending';
            $ordersData['orders_status_history'] = $orders_status_history;
            $ordersData['subtotal'] = $subtotal;

            //notification/email
            $myVar = new AlertController();
            $alertSetting = $myVar->orderAlert($ordersData);

           
            // session(['orders_id' => $orders_id]);
            // session(['paymentResponseData' => '']); 
            
            // session(['paymentResponse'=>'']);
            // session(['payment_json','']);

            //change status of cart products
            if (Session::get('guest_checkout') == 1) {
                DB::table('customers_basket')->where('session_id', Session::getId())->update(['customersid' => Session::get('customer_id')]);
                
                DB::table('customers_basket')->where('session_id', Session::getId())->update(['is_order' => '1']);
            } else {
                DB::table('customers_basket')->where('customer_id', auth()->guard('customer')->user()->id)->update(['is_order' => '1']);
            } 
            
            return redirect('/view-order/'.$order_id)->with($message);
            
        } else if ($payment_status == "failed") {
            return $payment_status;
        }
    }
    
    public function orders(Request $request){
        $pageTitle = Lang::get('website.Orders');
        $commonContent = $this->commonContent();
       //orders
        if (Session::get('guest_checkout') == 1) {
            $orders = Order::orderBy('created_at', 'DESC')->where('customer_id', '=', Session::get('customer_id'))->get();
        } else {
            $orders = Order::orderBy('created_at', 'DESC')->where('customer_id', '=', auth()->guard('customer')->user()->id)->get();
        }
        $index = 0;
        $total_price = array();
        foreach ($orders as $orders_data) {
            $orders_products = DB::table('orders_products')
                ->select('final_price', DB::raw('SUM(final_price) as total_price'))
                ->where('order_id', '=', $orders_data->id)->get();
            $orders[$index]->total_price = $orders_products[0]->total_price;
            $orders_status_history = DB::table('orders_status_history')->where('order_id', '=', $orders_data->id)->orderby('orders_status_history.status_history_id', 'DESC')->limit(1)->get();
            $orders[$index]->status = $orders_status_history[0]->status;
            $index++;
        }
        return view('web.orders.orders',compact('pageTitle','commonContent','orders'));
    }
 
    public function updateOrder(Request $request){
       
        $ordersCheck = Order::where(['customer_id' => auth()->guard('customer')->user()->id], ['id' => $request->id])->get();
        if(count($ordersCheck)>0){
        $this->validate($request, [
            'order_id'        =>  'required|numeric',
            'status'         =>   'in:Cancelled',
         ]);
       $orders_history_id = DB::table('orders_status_history')->insertGetId([
                'order_id' => $request->order_id,
                'status' => $request->status,
                'date_added' => date('Y-m-d h:i:s'),
                'customer_notified' => '1',
                'comments' => 'Customer has cancelled the order',
        ]);
        $message = array('message' => 'Order has been Cancelled successfully !','type' => 'Success !');
        return redirect()->back()->with($message);
        }else{
        $message = array('message' => 'Order does not exist, something wronge !','type' => 'Error !');
        return redirect()->back()->with($message);
        }
    }
    
    public function viewOrder(Request $request, $id){
        $pageTitle = Lang::get('website.View Order');
        $commonContent = $this->commonContent();
        $result = array();
        //orders
        if (Session::get('guest_checkout') == 1) {
            $orders = Order::orderBy('created_at', 'DESC')->where('orders_id', '=', $id)->where('customer_id', '=', Session::get('customer_id'))->get();
        } else {
            $orders = Order::orderBy('created_at', 'DESC')->where('id', '=', $id)->where('customer_id', auth()->guard('customer')->user()->id)->get();
        }
        if (count($orders) > 0) {
            $index = 0;
            foreach ($orders as $orders_data) {

                $orders_status_history = DB::table('orders_status_history')->where('order_id', '=', $id)->orderby('orders_status_history.status_history_id', 'DESC')->limit(1)->get();
                $products_array = array();
                $index2 = 0;
                $order_products = DB::table('orders_products')
                    ->join('products', 'products.id', '=', 'orders_products.product_id')->select('orders_products.*','products.image')
                    ->where('orders_products.order_id', $id)->get();
                foreach ($order_products as $products) {
                    array_push($products_array, $products);
                    $attributes = DB::table('orders_products_attributes')->where([['order_id', $id], ['order_product_id', $products->orders_products_id]])->get();
                    if (count($attributes) == 0) {
                        $attributes = $attributes;
                    }
                    $products_array[$index2]->attributes = $attributes;
                    $index2++;
                }
                $orders_status_history = DB::table('orders_status_history')->where('order_id', '=', $id)->orderby('orders_status_history.status_history_id', 'DESC')->limit(1)->get();

                $orders[$index]->statusess = $orders_status_history;
                $orders[$index]->products = $products_array;
                $orders[$index]->status= $orders_status_history[0]->status;
                $index++;
            }
            return view('web.orders.detail',compact('pageTitle','commonContent','orders'));
        } else {
           return redirect()->back();
        }
    }
    
}
