<?php

namespace App\Http\Controllers\Web;
use Illuminate\Support\Facades\Collection;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Notification;
use App\Notifications\DatabaseNotification;
use App\Models\User;
use App\Models\Language;
use App\Models\Category;
use Illuminate\Http\Request;
use DB;
use Session;
use Lang;
class NewsController extends Controller
{

     //shop
     public function shop(Request $request)
     {
         $result = array();
         //$result['commonContent'] = $this->index->commonContent();
         $categories = Category::leftjoin('categories_description','categories_description.categories_id','=','categories.id')
        ->where('categories_description.language_id','1')->get();
         if (!empty($request->page)) {
             $page_number = $request->page;
         } else {
             $page_number = 0;
         }
 
         if (!empty($request->limit)) {
             $limit = $request->limit;
         } else {
             $limit = 15;
         }
 
         if (!empty($request->type)) {
             $type = $request->type;
         } else {
             $type = '';
         }
 
         //min_max_price
         if (!empty($request->price)) {
             $d = explode(";", $request->price);
             $min_price = $d[0];
             $max_price = $d[1];
         } else {
             $min_price = '';
             $max_price = '';
         }
         $exist_category = '1';
         //category
         if (!empty($request->category) and $request->category != 'all') {
             $category = $this->products->getCategories($request);
             
             if(!empty($category) and count($category)>0){
                 $categories_id = $category[0]->categories_id;
                 //for main
                 if ($category[0]->parent_id == 0) {
                     $category_name = $category[0]->categories_name;
                     $sub_category_name = '';
                     $category_slug = '';
                     $categories_status = $category[0]->categories_status;
                 } else {
                     //for sub
                     $main_category = $this->products->getMainCategories($category[0]->parent_id);
 
                     $category_slug = $main_category[0]->categories_slug;
                     $category_name = $main_category[0]->categories_name;
                     $sub_category_name = $category[0]->categories_name;
                     $categories_status = $category[0]->categories_status;
                 }
             }else{
                 $categories_id = '';
                 $category_name = '';
                 $sub_category_name = '';
                 $category_slug = '';
                 
             }
                             
 
         } else {
             $categories_id = '';
             $category_name = '';
             $sub_category_name = '';
             $category_slug = '';
             
         }
 
         $result['category_name'] = $category_name;
         $result['category_slug'] = $category_slug;
         $result['sub_category_name'] = $sub_category_name;
         
 
         //search value
         if (!empty($request->search)) {
             $search = $request->search;
         } else {
             $search = '';
         }
 
         $filters = array();
         if (!empty($request->filters_applied) and $request->filters_applied == 1) {
             $index = 0;
             $options = array();
             $option_values = array();
 
             $option = $this->products->getOptions();
 
             foreach ($option as $key => $options_data) {
                 $option_name = str_replace(' ', '_', $options_data->products_options_name);
 
                 if (!empty($request->$option_name)) {
                     $index2 = 0;
                     $values = array();
                     foreach ($request->$option_name as $value) {
                         $value = $this->products->getOptionsValues($value);
                         $option_values[] = $value[0]->products_options_values_id;
                     }
                     $options[] = $options_data->products_options_id;
                 }
             }
 
             $filters['options_count'] = count($options);
 
             $filters['options'] = implode($options, ',');
             $filters['option_value'] = implode($option_values, ',');
 
             $filters['filter_attribute']['options'] = $options;
             $filters['filter_attribute']['option_values'] = $option_values;
 
             $result['filter_attribute']['options'] = $options;
             $result['filter_attribute']['option_values'] = $option_values;
         }
 
        $data = array('page_number' => $page_number, 'type' => $type, 'limit' => $limit,'categories_id' => $categories_id, 'search' => $search,'filters' => $filters, 'limit' => $limit, 'min_price' => $min_price, 'max_price' => $max_price);
        $myVar = new DataController();
        $data = array('page_number'=>'0', 'type'=>'', 'limit'=>10, 'min_price'=>$min_price, 'max_price'=>$max_price );
        $products = $myVar->products($data);


         $data = array('limit' => $limit, 'categories_id' => $categories_id);
         $filters = $this->filters($data);
         $result['filters'] = $filters;
 
         $cart = '';
         $result['cartArray'] = $this->cartIdArray($cart);
 
         if ($limit > $products['total_record']) {
             $result['limit'] = $products['total_record'];
         } else {
             $result['limit'] = $limit;
         }
 
         //liked products
         $result['liked_products'] = $this->likedProducts();
         $result['categories'] = $this->categories();
 
         $result['min_price'] = $min_price;
         $result['max_price'] = $max_price;

         return view('web.products.shop',compact('categories','result','products'));
         
     }
 
    public function filters($data)
    {

        $categories_id = $data['categories_id'];
        $currentDate = time();

        $price = DB::table('product_category')
            ->join('products', 'products.id', '=', 'product_category.product_id');
        if (isset($categories_id) and !empty($categories_id)) {
            $price->where('product_category.category_id', '=', $categories_id);
        }

        $priceContent = $price->max('price');
        if (!empty($priceContent)) {
            $priceContent = $priceContent * session('currency_value');
            $maxPrice = round($priceContent + 1);            
        } else {
            $maxPrice = 1;
        }

        $product = DB::table('products')
            ->leftJoin('products_description', 'products_description.product_id', '=', 'products.id')
        
            ->LeftJoin('products_specials', function ($join) use ($currentDate) {
                $join->on('products_specials.product_id', '=', 'products.id')->where('products_specials.status', '=', 'Active')->where('products_specials.expires_date', '>', $currentDate);
            });

        if (isset($categories_id) and !empty($categories_id)) {
            $product->LeftJoin('product_category', 'products.id', '=', 'product_category.product_id')->select('product_category.*', 'products.*', 'products_description.*',  'products_specials.special_new_product_price as discount_price');
        } else {
            $product->select('products.*', 'products_description.*',  'products_specials.special_new_product_price as discount_price');
        }
        $product->where('products_description.language_id', '=', Session::get('locale'));

        if (isset($categories_id) and !empty($categories_id)) {
            $product->where('product_category.category_id', '=', $categories_id);
        }

        $products = $product->get();

        $index = 0;
        $optionsIdArrays = array();
        $valueIdArray = array();
        foreach ($products as $products_data) {
            $option_name = DB::table('products_attributes')->where('product_id', '=', $products_data->products_id)->get();
            foreach ($option_name as $option_data) {

                if (!in_array($option_data->options_id, $optionsIdArrays)) {
                    $optionsIdArrays[] = $option_data->options_id;
                }

                if (!in_array($option_data->options_values_id, $optionsIdArrays)) {
                    $valueIdArray[] = $option_data->options_values_id;
                }
            }
        }

        if (!empty($optionsIdArrays)) {

            $index3 = 0;
            $result = array();
            foreach ($optionsIdArrays as $optionsIdArray) {
                $option_name = DB::table('products_options')
                    ->leftJoin('products_options_descriptions', 'products_options_descriptions.products_options_id', '=', 'products_options.products_options_id')->select('products_options.products_options_id', 'products_options_descriptions.options_name as products_options_name', 'products_options_descriptions.language_id')->where('language_id', '=', Session::get('locale'))->where('products_options.products_options_id', '=', $optionsIdArray)->get();

                if (count($option_name) > 0) {
                    $attribute_opt_val = DB::table('products_options_values')->where('products_options_id', $optionsIdArray)->get();
                    if (count($attribute_opt_val) > 0) {
                        $temp = array();
                        $temp_name['name'] = $option_name[0]->products_options_name;
                        $attr[$index3]['option'] = $temp_name;

                        foreach ($attribute_opt_val as $attribute_opt_val_data) {

                            $attribute_value = DB::table('products_options_values')
                                ->leftJoin('products_options_values_descriptions', 'products_options_values_descriptions.products_options_values_id', '=', 'products_options_values.products_options_values_id')
                                ->select('products_options_values.products_options_values_id', 'products_options_values_descriptions.options_values_name as products_options_values_name', 'products_options_values_descriptions.language_id')
                                ->where('products_options_values.products_options_values_id', $attribute_opt_val_data->products_options_values_id)->where('language_id', Session::get('locale'))->get();

                            foreach ($attribute_value as $attribute_value_data) {

                                //if(in_array($attribute_value_data->products_options_values_id,$valueIdArray)){
                                $temp_value['value'] = $attribute_value_data->products_options_values_name;
                                $temp_value['value_id'] = $attribute_value_data->products_options_values_id;

                                array_push($temp, $temp_value);
                                //}
                            }
                            $attr[$index3]['values'] = $temp;
                        }
                        $index3++;
                    }
                    $response = array('success' => '1', 'attr_data' => $attr, 'message' => Lang::get('website.Returned all filters successfully'), 'maxPrice' => $maxPrice);
                } else {
                    $response = array('success' => '0', 'attr_data' => array(), 'message' => Lang::get('website.Filter is empty for this category'), 'maxPrice' => $maxPrice);
                }

            }

        } else {
            $response = array('success' => '0', 'attr_data' => array(), 'message' => Lang::get('website.Filter is empty for this category'), 'maxPrice' => $maxPrice);
        }

        return ($response);
    }
   
    public function cartIdArray($requestt)
    {

        $cart = DB::table('customers_basket')->where('customers_basket.is_order', '=', '0');

        if (empty(session('customers_id'))) {
            $cart->where('customers_basket.session_id', '=', Session::getId());
        } else {
            $cart->where('customers_basket.customers_id', '=', session('customers_id'));
        }
        $baskit = $cart->get();

        $result = array();
        $index = 0;
        foreach ($baskit as $baskit_data) {
            $result[$index++] = $baskit_data->products_id;
        }

        return ($result);

    }
 
    public function categories()
    {
        $items = DB::table('categories')
            ->leftJoin('categories_description', 'categories_description.categories_id', '=', 'categories.id')
            ->select('categories.id','categories.slug', 'categories_description.name', 'categories.parent_id')
            ->where('categories_description.language_id', '=', 1)
           // ->groupBy('categories.id')
            ->get();
        if ($items->isNotEmpty()) {
            $childs = array();
            foreach ($items as $item) {
                $childs[$item->parent_id][] = $item;
            }

            foreach ($items as $item) {
                if (isset($childs[$item->id])) {
                    $item->childs = $childs[$item->id];
                }
            }

            $tree = $childs[0];
            return $tree;
        }
    }
   
    public function likedProducts()
    {

        $products = DB::table('liked_products')->where('liked_customer_id', '=', session('customer_id'))->get();
        $result = array();
        $index = 0;
        foreach ($products as $products_data) {
            $result[$index++] = $products_data->liked_products_id;
        }
        return ($result);

    }
    //productDetail
    public function product(Request $request)
    {

        $title = array('pageTitle' => Lang::get('website.Product Detail'));
        $result = array();
        
        $result['commonContent'] = $this->commonContent();
        
        //min_price
        if (!empty($request->min_price)) {
            $min_price = $request->min_price;
        } else {
            $min_price = '';
        }

        //max_price
        if (!empty($request->max_price)) {
            $max_price = $request->max_price;
        } else {
            $max_price = '';
        }

        if (!empty($request->limit)) {
            $limit = $request->limit;
        } else {
            $limit = 15;
        }

        $products = $this->products->getProductsBySlug($request->slug);
        if(!empty($products) and count($products)>0){
            
            //category
            $category = $this->products->getCategoryByParent($products[0]->products_id);

            if (!empty($category) and count($category) > 0) {
                $category_slug = $category[0]->categories_slug;
                $category_name = $category[0]->categories_name;
            } else {
                $category_slug = '';
                $category_name = '';
            }
            $sub_category = $this->products->getSubCategoryByParent($products[0]->products_id);

            if (!empty($sub_category) and count($sub_category) > 0) {
                $sub_category_name = $sub_category[0]->categories_name;
                $sub_category_slug = $sub_category[0]->categories_slug;
            } else {
                $sub_category_name = '';
                $sub_category_slug = '';
            }

            $result['category_name'] = $category_name;
            $result['category_slug'] = $category_slug;
            $result['sub_category_name'] = $sub_category_name;
            $result['sub_category_slug'] = $sub_category_slug;

            $isFlash = $this->products->getFlashSale($products[0]->products_id);

            if (!empty($isFlash) and count($isFlash) > 0) {
                $type = "flashsale";
            } else {
                $type = "";
            }
            $postCategoryId = '';
            $data = array('page_number' => '0', 'type' => $type, 'products_id' => $products[0]->products_id, 'limit' => $limit, 'min_price' => $min_price, 'max_price' => $max_price);
            $detail = $this->products->products($data);
            $result['detail'] = $detail;
            if (!empty($result['detail']['product_data'][0]->categories) and count($result['detail']['product_data'][0]->categories) > 0) {
                $i = 0;
                foreach ($result['detail']['product_data'][0]->categories as $postCategory) {
                    if ($i == 0) {
                        $postCategoryId = $postCategory->categories_id;
                        $i++;
                    }
                }
            }

            $data = array('page_number' => '0', 'type' => '', 'categories_id' => $postCategoryId, 'limit' => $limit, 'min_price' => $min_price, 'max_price' => $max_price);
            $simliar_products = $this->products->products($data);
            $result['simliar_products'] = $simliar_products;

            $cart = '';
            $result['cartArray'] = $this->products->cartIdArray($cart);

            //liked products
            $result['liked_products'] = $this->products->likedProducts();

            $data = array('page_number' => '0', 'type' => 'topseller', 'limit' => $limit, 'min_price' => $min_price, 'max_price' => $max_price);
            $top_seller = $this->products->products($data);
            $result['top_seller'] = $top_seller;		
        }else{
            $products = '';
            $result['detail']['product_data'] = '';
        }
        return view('web.products.product',compact('categories'));
        
    }
}
