<?php

namespace App\Http\Controllers\Admin;
use App\Models\Country;
use App\Models\Zone;
use DB;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ZonesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
         if (!Gate::allows('zone.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $zones = Zone::Leftjoin('countries','zones.country_id','=','countries.id')->select('zones.*','countries.name as c_name')->get();
        return view('admin.zones.index',compact('zones'));
        
    }
     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(){
        if (!Gate::allows('zone.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        } 
        $countries = Country::all();
        return view('admin.zones.create',compact('countries'));  
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        if (!Gate::allows('zone.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        } 
        $data = $this->validate($request, [
            'name'          => 'required|string|max:50|unique:zones',
            //'name_ar'          => 'required|string|max:50|unique:zones',
            'code'    => 'required|string|max:8',
            'country_id'    => 'required|numeric',
            
          ]);
          Zone::create($data);
        $message = array('message' => 'Zone has been created successfully !','type' => 'success');
            return redirect()->back()->with($message); 
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id){
        if (!Gate::allows('zone.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $zone = Zone::find($id);
        $countries = Country::all();
        return view('admin.zones.edit',compact('zone','countries'));
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('permission.edit') && !Gate::allows('all')) {
        
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
    
        $data = $this->validate($request, [
            'name'          => 'required|string|max:50|unique:zones,name,'.$id,
            //'name_ar'          => 'required|string|max:50|unique:zones,name_ar,'.$id,',
            'code'    => 'required|string|max:8',
            'country_id'    => 'required|numeric',
        ]);
        $data['updated_at'] = date('Y-m-d H:i:s');
        Zone::find($id)->update($data);
        $message = array('message' => 'Zone has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);
        
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id){
       if (!Gate::allows('zone.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $ids = explode(',', $id);
        Zone::whereIn('id',$ids)->delete();
        $message = array('message' => 'Delete Successed','type' => 'success');
        return $message;
        
    }
}
