<?php

namespace App\Http\Controllers\Admin;
use App\Models\Setting;
use App\Models\Country;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Support\Facades\File;
class SettingsController extends Controller
{
    public function generalSettings(Request $request){
		if (!Gate::allows('generalSettings.index') && !Gate::allows('all')) {
			$message = array('message' => 'You are not allowed to access this page !','type' => 'error');
			return redirect()->back()->with($message);
			}  
		$settings = Setting::all();
		$countries = Country::all();
		
        return view('admin.settings.generalSettings',compact('settings','countries'));
    }
    public function updateGeneralSettings(Request $request){
		if (!Gate::allows('generalSettings.edit') && !Gate::allows('all')) {
			$message = array('message' => 'You are not allowed to access this page !','type' => 'error');
			return redirect()->back()->with($message);
			}  
        $data = $this->validate($request, [
            'app_name'           =>  'required|string|max:255',
            'url'                =>  'required|string|max:255',
            'contact_us_email'   =>  'required|string|max:255|email',
            'phone'              =>  'max:50',
            'city'               =>  'required|string|max:50',
            'state'              =>  'string|max:50',
            'zip'                =>  'string|max:10',
            'country'            =>  'required|string|max:255',
            'latitude'           =>  'string|max:25',
            'longitude'          =>  'string|max:25'
            // 'site_logo'          => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            // 'app_logo'           => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
          ]);
          foreach($request->all() as $key => $value){	
			//website logo
			if($key=='site_logo' ){				
			    if($request->hasfile('site_logo')){
                    $image = $request->file('site_logo');
                    $fileName = time().'-image.'.$image->getClientOriginalExtension();
                    Image::make($image)->resize(300, 42)->save(public_path('/images/site/' . $fileName));
                    $value = $fileName;
                }		
			}
			
			//favicon logo
			if($key=='app_logo' ){				
				if($request->hasFile('app_logo')){
					$image = $request->app_logo;
					$fileName = time().'.'.$image->getClientOriginalExtension();
					Image::make($image)->resize(180, 180)->save(public_path('/images/site/' . $fileName));
					$value = $fileName; 
						
				}				
			}
			
			
			$checkExist = DB::table('settings')->where('name','=', $key)->first();
			if($checkExist){
				DB::table('settings')->where('name','=', $key)->update([
					'value'			=>	addslashes($value),
					'updated_at'	=>	date('Y-m-d h:i:s')
				]);
			}else{
				DB::table('settings')->insertGetId([
					'value'			=>	addslashes($value),
					'name'			=>	$key,
				]);				
			}
			
		}
       
        $message = array('message' => 'Settings has been updated successfully !','type' => 'success');
        return redirect()->back()->with($message);
    }
    
    public function socialSettings(Request $request){
		if (!Gate::allows('socialSettings.index') && !Gate::allows('all')) {
			$message = array('message' => 'You are not allowed to access this page !','type' => 'error');
			return redirect()->back()->with($message);
			}  
        $settings = Setting::all();
        return view('admin.settings.socialSettings')->with('settings',$settings);
    }
    public function updatesocialSettings(Request $request){
		if (!Gate::allows('socialSettings.edit') && !Gate::allows('all')) {
			$message = array('message' => 'You are not allowed to access this page !','type' => 'error');
			return redirect()->back()->with($message);
			} 
        $data = $this->validate($request, [
            'google_login'           =>  'numeric|max:1',
            'google_app_id'          =>  'string|max:255',
            'google_secret_id'       =>  'string|max:255',
            'google_callback_url'    =>  'string|max:255',

            'facebook_login'         =>  'numeric|max:1',
            'facebook_app_id'        =>  'string|max:255',
            'facebook_secret_id'     =>  'string|max:255',
            'facebook_callback_url'  =>  'string|max:255',

            'apple_login'            =>  'numeric|max:1',
            'apple_app_id'           =>  'string|max:255',
            'apple_secret_id'        =>  'string|max:255',
            'apple_callback_url'     =>  'string|max:255'
          ]);
          foreach($data as $key => $value){
            $checkExist = DB::table('settings')->where('name','=', $key)->first();
			if($checkExist){
				DB::table('settings')->where('name','=', $key)->update([
					'value'			=>	addslashes($value),
					'updated_at'	=>	date('Y-m-d h:i:s')
				]);
			}
          }
          $message = array('message' => 'Settings has been updated successfully !','type' => 'success');
        return redirect()->back()->with($message);
	}
	public function socialLinks(Request $request){
		if (!Gate::allows('socialSettings.index') && !Gate::allows('all')) {
			$message = array('message' => 'You are not allowed to access this page !','type' => 'error');
			return redirect()->back()->with($message);
			} 
        $settings = Setting::all();
        return view('admin.settings.socialLinks')->with('settings',$settings);
    }
	public function updateSocialLinks(Request $request){
		if (!Gate::allows('socialSettings.edit') && !Gate::allows('all')) {
			$message = array('message' => 'You are not allowed to access this page !','type' => 'error');
			return redirect()->back()->with($message);
			} 
        $data = $this->validate($request, [
            'google_url'			=>  'string|max:255',
          	'facebook_url'        	=>  'string|max:255',
            'instagram_url'         =>  'string|max:255',
            'linkedin_url'     		=>  'string|max:255',
            'twitter_url'  			=>  'string|max:255',
			'youtube_url' 			=>  'string|max:255',
         
          ]);
          foreach($data as $key => $value){
            $checkExist = DB::table('settings')->where('name','=', $key)->first();
			if($checkExist){
				DB::table('settings')->where('name','=', $key)->update([
					'value'			=>	addslashes($value),
					'updated_at'	=>	date('Y-m-d h:i:s')
				]);
			}
          }
          $message = array('message' => 'Settings has been updated successfully !','type' => 'success');
        return redirect()->back()->with($message);
	}
	public function slugify($slug){
		
	  // replace non letter or digits by -
	  $slug = preg_replace('~[^\pL\d]+~u', '-', $slug);
	
	  // transliterate
	  if (function_exists('iconv')){
		$slug = iconv('utf-8', 'us-ascii//TRANSLIT', $slug);
	  }
	
	  // remove unwanted characters
	  $slug = preg_replace('~[^-\w]+~', '', $slug);
	
	  // trim
	  $slug = trim($slug, '-');
	
	  // remove duplicate -
	  $slug = preg_replace('~-+~', '-', $slug);
	
	  // lowercase
	  $slug = strtolower($slug);
	
	  if (empty($slug)) {
		return 'n-a';
	  }
	
	  return $slug;
	}
    public function imageType(){	
		$extensions = array('gif','jpg','jpeg','png');	
		return $extensions;
	}
}
