<?php

namespace App\Http\Controllers\Admin;
use App\Models\Category;
use App\Models\Language;
use App\Models\Product;
use App\Models\Setting;
use App\Models\Brand;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Validator;
use Response;
use DB;
use Auth;
class ProductsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
        if (!Gate::allows('product.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $data = Product::leftJoin('products_description','products_description.product_id', '=', 'products.id')
            ->leftJoin('users','users.id', '=', 'products.vendor_id')
    		->LeftJoin('products_specials', function ($join) {
                $join->on('products_specials.product_id', '=', 'products.id')->where('products_specials.status', '=', 'Active');
            });
             $data->leftJoin('product_category', 'products.id', '=', 'product_category.product_id')
            ->leftJoin('categories', 'categories.id', '=', 'product_category.category_id')
            ->leftJoin('categories_description', 'categories.id', '=', 'categories_description.categories_id');
            //product stock
		$data->select(
		    'products.*',
		    'products_description.name',
		    'categories_description.name as category_name',
		    'products_specials.special_id',
		    'products_specials.product_id as special_product_id', 
		    'products_specials.special_new_product_price as special_price',
            'products_specials.special_date_added', 
            'products_specials.special_last_modified',
            'products_specials.expires_date',
            'users.first_name','users.last_name'
            
		    );
		 if(Auth::user()->user_type == 'Vendor'){
            $data->where('products.vendor_id',Auth::user()->id);
        }
		$data->where('products_description.language_id', 'en')->where('categories_description.language_id', 'en');
		
		$products = $data->orderBy('products.id', 'DESC')->groupBy('products.id')->get();
        return view('admin.products.index',compact('products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(){
        if (!Gate::allows('product.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $language_id = 'en';
        $languages = Language::select('name','code')->get();
        $brands = Brand::Leftjoin('brands_description','brands_description.brand_id','=','brands.id')->where('language_id','en')->select('brands_description.name','brands.id')->get();
        $myVar = new CategoriesController();
		$categories = $myVar->categories($language_id);

        return view('admin.products.create',compact('languages','categories','brands'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        if (!Gate::allows('product.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
    $languages = Language::select('code')->get();
    foreach($languages as $language){
        $data2 = $this->validate($request, [
            'name_'.$language->code => 'required|string|max:100|regex:/^[\pL\s\-]+$/u',
            'description_'.$language->code => 'required|string',
        ]);	
    }
    $data = $this->validate($request, [
        'type'          =>'in:Simple,Variable,External',
        'image'         => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        'price'         => 'required|numeric',
        //'categories'    => 'required|numeric',
        'min_order'     => 'required|numeric'
    ]);
    
    if(Auth::user()->user_type == 'Vendor'){
        $data['vendor_id'] = Auth::user()->id;
    }else{
      $data['vendor_id'] = 1;  
    }
    $data['quantity'] =0;
    $data['max_stock'] =$request->max_stock;
    $data['low_limit'] = 0;
    $data['brand_id'] = $request->brand_id;
    $data['slug'] = Str::random(15);
    if($request->hasfile('image')){
        $image = $request->file('image');
        $filename = time() . '-image.' . $image->getClientOriginalExtension();
        Image::make($image)->resize(600, 600)->save(public_path('/images/products_images/' . $filename));
        $data['image'] = '/images/products_images/'.$filename;
    }else{
        $data;
        }
        
        $id = Product::create($data)->id;  
        foreach($request->categories as $c_id){
            DB::table('product_category')->Insert(['product_id'=>$id,'category_id'=>$c_id]);
        }
        $myVar = new SettingsController();
        $slug_flag = false;	
        //multiple lanugauge with record 
        foreach($languages as $language){
            
            $name = 'name_'.$language->code;
            $description = 'description_'.$language->code;
            $shoer_description = 'short_description_'.$language->code;
            $url = $name;
            DB::table('products_description')->insert([
                    'name'              =>   $request->$name,
                    'description'       =>   $request->$description,
                    'short_description' =>   $request->$shoer_description,
                    'url'               =>   $url,
                    'product_id'        =>   $id,
                    'language_id'       =>   $language->code
                ]);
        }
        //special product
        if($request->isSpecial == 'yes'){
          DB::table('products_specials')->where('product_id', '=', $id)->update([
              'special_last_modified' => time(),
              'date_status_change' => time(),
              'status' => 'InActive',
          ]);
          DB::table('products_specials')->insert([
              'product_id' => $id,
              'special_new_product_price' => $request->special_new_product_price,
              'special_date_added' => time(),
              'special_last_modified' => 0,
              'date_status_change'=>0,
              'expires_date' => 12321234,//strtotime(str_replace('/', '-', $request->expires_date)),
              'status' => $request->status,
          ]);
        }
    
        $message = array('message' => 'Product has been updated successfully','type' => 'success');
        if ($request->type == 'Variable') {
            return redirect('admin/product/productAttribute/'.$id)->with($message);
        }else{
        return redirect()->back()->with($message);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id){
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $product = product::find($id);
        //get function from other controller
		$language_id = 'en';
		$languages = Language::select('name','code')->get();
        $myVar = new CategoriesController();
		$categories = $myVar->categories($language_id);

		$product = product::find($id);
		$brands = Brand::Leftjoin('brands_description','brands_description.brand_id','=','brands.id')->where('language_id','en')->select('brands_description.name','brands.id')->get();
		$description = array();		
		foreach($languages as $language){
			$products_description= DB::table('products_description')->where([
					['language_id', '=', $language->code],
					['product_id', '=', $id],
				])->get();
				
			if(count($products_description)>0){								
				$description[$language->code]['name'] = $products_description[0]->name;
                $description[$language->code]['description'] = $products_description[0]->description;
                $description[$language->code]['short_description'] = $products_description[0]->short_description;
				$description[$language->code]['language_name'] = $language->name;
				$description[$language->code]['language_id'] = $language->code;										
			}else{
				$description[$language->code]['name'] = '';
                $description[$language->code]['description'] = '';
                $description[$language->code]['short_description'] = '';
				$description[$language->code]['language_name'] = $language->name;
				$description[$language->code]['language_id'] = $language->code;	
			}
		}

        $product_category = DB::table('product_category')
                    ->leftJoin('categories','categories.id','=','product_category.category_id')
                    ->leftJoin('categories_description','categories_description.categories_id', '=', 'categories.id')
                    ->select('categories.*','product_category.category_id')				
                    ->where('product_id','=', $id)->where('categories_description.language_id','=', $language_id )
                    ->get();

        $subCategories = array();
        $mainCategories = array();

        foreach($product_category as $category){
            if($category->parent_id==0){
                $mainCategories[] = $category->id;
            }
            if($category->parent_id!=0){
                $subCategories[] = $category->id;				
            }
        }
        
    $getSpecialProduct = DB::table('products_specials')->where('product_id', $id)->orderby('special_id', 'desc')->limit(1)->get();
    if(count($getSpecialProduct)>0){
        $specialProduct = $getSpecialProduct;
    }else{
        $specialProduct[0] = (object) array('special_id'=>'', 'product_id'=>'', 'special_new_product_price'=>'', 'status'=>'', 'expires_date' => '');
    }
    
        return view('admin.products.edit',compact('description','categories','product','subCategories','mainCategories','specialProduct','brands'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id){
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::select('name','code')->get();
        foreach($languages as $language){
            $data2 = $this->validate($request, [
                'name_'.$language->code => 'required|string|max:100|',
                'description_'.$language->code => 'required|string',
            ]);	
        }
        $data = $this->validate($request, [
            'type'          =>'in:Simple,Variable,External',
            'image'         => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            'price'         => 'required|numeric',
            //'categories'    => 'required|numeric',
            'min_order'     => 'required|numeric'
        ]);
        $product = Product::find($id);
        if($request->hasfile('image')){
            File::delete(public_path($product->image));
            $image = $request->file('image');
            $filename = time() . '-image.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(600, 600)->save(public_path('/images/products_images/' . $filename));
            $data['image'] = '/images/products_images/'.$filename;
        }else{
            $data;
            }
            $data['quantity'] =0;
            $data['max_stock'] =$request->max_stock;
            $data['low_limit'] = 0;
            $data['brand_id'] = $request->brand_id;
            $data['updated_at']=date('Y-m-d H:i:s');
            
            Product::where('id', $id)->update($data);
            
            foreach($request->categories as $c_id){
                DB::table('product_category')->insertOrIgnore(['product_id'=>$id,'category_id'=>$c_id]);
            }
		foreach($languages as $language){
			$name = 'name_'.$language->code;
            $desription = 'description_'.$language->code;
            $short_desription = 'short_description_'.$language->code;
			$checkExist = DB::table('products_description')->where('product_id','=',$id)->where('language_id','=',$language->code)->get();			
			if(count($checkExist)>0){
				DB::table('products_description')->where('product_id','=',$id)->where('language_id','=',$language->code)->update([
					'name'  	    		 =>   $request->$name,
                    'description'            =>   $request->$desription,
                    'short_description'      =>   $request->$short_desription,
                    'url'                    =>   $request->$name
					]);
			}else{
				DB::table('products_description')->insert([
					'name'  	             =>   $request->$name,
                    'description'            =>   $request->$desription,
                    'short_description'      =>   $request->$short_desription,
					'language_id'			 =>   $language->code,
					'service_id'			 =>   $id,
					'url'                    =>   $request->$name
					]);
			}
		}
		//special product
        if($request->isSpecial == 'yes'){
          DB::table('products_specials')->where('product_id', '=', $id)->update([
              'special_last_modified' => time(),
              'date_status_change' => time(),
              'status' => 'InActive',
          ]);
          DB::table('products_specials')->insert([
              'product_id' => $id,
              'special_new_product_price' => $request->special_new_product_price,
              'special_date_added' => time(),
              'expires_date' => strtotime(str_replace('/', '-', $request->expires_date)),
              'status' => $request->status,
          ]);
        }
        $message = array('message' => 'Product has been updated successfully','type' => 'success');
        if ($request->type == 'Variable') {
            return redirect('admin/product/productAttribute/'.$id)->with($message);
        }else{
        return redirect()->back()->with($message);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id){
        if (!Gate::allows('product.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        
        $get = Product::whereIn('id',$ids)->select('image')->get();
        $get2 = DB::table('products_images')->whereIn('product_id',$ids)->get();
        
        if(Auth::user()->user_type == 'Vendor'){
               
               if(Product::whereIn('products.id', $ids)->where('vendor_id',Auth::user()->id)->delete()){
                    foreach($get as $g){ File::delete(public_path($g->image)); }
                    foreach($get2 as $g){ File::delete(public_path($g->image)); }
                    DB::table('products_description')->whereIn('product_id', $ids)->delete();
                    DB::table('product_category')->whereIn('product_id', $ids)->delete();
                    DB::table('products_specials')->whereIn('product_id', $ids)->delete();
                    DB::table('products_images')->whereIn('product_id', $ids)->delete();
                    DB::table('products_attributes')->whereIn('product_id', $ids)->delete();  
                    $message = array('message' => 'Delete Succeeded f','type' => 'success');
                }else{
                    $message = array('message' => 'Delete Failed, Something went wrong !','type' => 'error');
                }
        }else{
            foreach($get as $g){ File::delete(public_path($g->image)); }
            foreach($get2 as $g){ File::delete(public_path($g->image)); }
            
            Product::whereIn('products.id', $ids)->delete();
            DB::table('products_description')->whereIn('product_id', $ids)->delete();
            DB::table('product_category')->whereIn('product_id', $ids)->delete();
            DB::table('products_specials')->whereIn('product_id', $ids)->delete();
            DB::table('products_images')->whereIn('product_id', $ids)->delete();
            DB::table('products_attributes')->whereIn('product_id', $ids)->delete();
            
            $message = array('message' => 'Delete Succeeded','type' => 'success');
        }
        return $message; 
    }
    
    public function productStatus(Request $request){
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $product =Product::find($request->id);
        if($product->status =='Active'){
            if(Auth::user()->user_type == 'Vendor'){
                $product->where('vendor_id',Auth::user()->id);	
            }
            $product->update(['status' => 'InActive']);
        }elseif($product->status =='InActive'){
            if(Auth::user()->user_type == 'Vendor'){
                $product->where('vendor_id',Auth::user()->id);	
            }	
            $product->update(['status' => 'Active']);
        }
        $message = array('message' => 'Product Status has been updated successfully','type' => 'success');
        return $message;
       
    }
//=====================Products Attributes=================

    public function addProductAttribute(Request $request){
        $language_id = 'en';
        $product_id      =   $request->id;
        $subcategory_id   =   $request->subcategory_id;
        $setting = Setting::all();
        $languages = Language::select('name','code')->get();
        $options = DB::table('products_options')
        ->leftjoin('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
        ->where('products_options_description.language_id', '=', $language_id)
        ->get();
        $products_attributes = DB::table('products_attributes')
            ->join('products_options', 'products_options.option_id', '=', 'products_attributes.option_id')
            ->join('products_options_description', 'products_options_description.option_id', '=', 'products_attributes.option_id')
            ->join('products_options_values', 'products_options_values.option_value_id', '=', 'products_attributes.option_value_id')
            ->join('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_attributes.option_value_id')
            ->select('products_attributes.*', 'products_options_description.option_name', 'products_options_values_description.option_value_name')
            ->where('products_attributes.product_id', '=', $product_id)
            ->where('products_options_description.language_id', '=', $language_id)
            ->where('products_options_values_description.language_id', '=', $language_id)
            ->orderBy('products_attributes_id', 'DESC')
            ->get();
        return view('admin.products.productAttribute',compact('product_id','languages','options','products_attributes','subcategory_id'));
  }
  
    public function getOptionsValue(Request $request){
       $language_id = 'en';
        $value = DB::table('products_options_values')
        ->leftjoin('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
        ->select('products_options_values_description.*')
        ->where('products_options_values_description.language_id', '=', $language_id)
        ->where('products_options_values.option_id', '=', $request->option_id)
        ->get();
        if (count($value) > 0) {
            foreach ($value as $value_data) {
                $value_name[] = "<option value='" . $value_data->option_value_id . "'>" . $value_data->option_value_name . "</option>";
            }
        } else {
            $value_name = "<option value=''>" . "Choose Value" . "</option>";
        }
        print_r($value_name);
    }
    
    public function productAditionalAttribute(Request $request){
            if(!empty($request->option_id) and !empty($request->product_id) and !empty($request->option_value_id) and isset($request->option_value_price)){
              $checkRecord = DB::table('products_attributes')->where([
                  'option_id' => $request->option_id,
                  'option_value_id' => $request->option_value_id,
                  'product_id' => $request->product_id
              ])->get();
                if(count($checkRecord)>0){
                    $message = array('message' => 'Product Option already exist !','type' => 'warning');
                    return $message;
                    }else{
                    $products_attributes_id = DB::table('products_attributes')->insertGetId([
                        'product_id' => $request->product_id,
                        'option_id' => $request->option_id,
                        'option_value_id' => $request->option_value_id,
                        'option_value_price' => $request->option_value_price,
                        'price_prefix' => $request->price_prefix,
                    ]);
                    $products_attributes = DB::table('products_attributes')
                        ->join('products_options', 'products_options.option_id', '=', 'products_attributes.option_id')
                        ->leftJoin('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
                        ->join('products_options_values', 'products_options_values.option_value_id', '=', 'products_attributes.option_value_id')
                        ->leftJoin('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
                        ->select('products_attributes.*', 'products_options_description.option_name', 'products_options_description.language_id', 'products_options_values_description.option_value_name')
                        ->where('products_options_description.language_id', '=', 'en')
                        ->where('products_options_values_description.language_id', '=', 'en')
                        ->where('products_attributes.product_id', '=', $request->product_id)
                        ->orderBy('products_attributes_id', 'DESC')
                        ->get();
                }
            }else{
                $products_attributes = 'empty';
            }
            return $products_attributes;
    }
    
    public function productAditionalAttributeEdit(Request $request){
        $setting = Setting::all();
        $myVarsetting = new SettingsController($setting);
        //$myVaralter = new AlertController($setting);
            $languages = Language::select('name','code')->get();
            $product_id = $request->product_id;
            $products_attributes_id = $request->products_attributes_id;
            $option_id = $request->option_id;
            $language_id = 'en';
            $options = DB::table('products_options')
              ->leftJoin('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
              ->select('products_options.option_id', 'products_options_description.option_name', 'products_options_description.language_id')
              ->where('products_options_description.language_id', '=', $language_id)
              ->get();
          $options_values = DB::table('products_options_values')
              ->leftJoin('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
              ->select('products_options_values.option_value_id', 'products_options_values_description.option_value_name')
              ->where('products_options_values_description.language_id', '=', $language_id)
              ->where('products_options_values.option_id', '=', $option_id)
              ->get();
           $products_attributes = DB::table('products_attributes')
              ->join('products_options', 'products_options.option_id', '=', 'products_attributes.option_id')
              ->leftJoin('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
              ->join('products_options_values', 'products_options_values.option_value_id', '=', 'products_attributes.option_value_id')
              ->leftJoin('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
              ->select('products_attributes.*', 'products_options_description.option_name', 'products_options_description.language_id', 'products_options_values_description.option_value_name')
              ->where('products_options_description.language_id', '=', $language_id)
              ->where('products_options_values_description.language_id', '=', $language_id)
              ->where('products_attributes.products_attributes_id', '=', $products_attributes_id)
              ->get();
         return view('admin.products.editAditionalAttributeForm',compact('product_id','option_id','options','options_values','products_attributes','products_attributes_id','language_id'));
  
  }

    public function productAditionalAttributeUpdate(Request $request){
        $language_id = 'en';
        $checkRecord = DB::table('products_attributes')->where([
            'option_id' => $request->option_id,
            'option_value_id' => $request->option_value_id,
            'product_id' => $request->product_id
        ])->where('products_attributes_id','!=', $request->products_attributes_id)->get();
        if(count($checkRecord)>0){
         $message = array('message' => 'Product Option already exist !','type' => 'warning');
                    return $message;
                    }else{
        DB::table('products_attributes')->where('products_attributes_id', '=', $request->products_attributes_id)->update([
            'option_id' => $request->option_id,
            'option_value_id' => $request->option_value_id,
            'option_value_price' => $request->option_value_price,
            'price_prefix' => $request->price_prefix,
        ]);
        $products_attributes = DB::table('products_attributes')
            ->join('products_options', 'products_options.option_id', '=', 'products_attributes.option_id')
            ->leftJoin('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
            ->join('products_options_values', 'products_options_values.option_value_id', '=', 'products_attributes.option_value_id')
            ->leftJoin('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
            ->select('products_attributes.*', 'products_options_description.option_name', 'products_options_description.language_id', 'products_options_values_description.option_value_name')
            ->where('products_options_description.language_id', '=', $language_id)
            ->where('products_options_values_description.language_id', '=', $language_id)
            ->where('products_attributes.product_id', '=', $request->product_id)
            ->orderBy('products_attributes_id', 'DESC')
            ->get();
            return $products_attributes;
    }
    }
    
    public function productAditionalAttributeDestroy($product_id, $attribute_id){
        $setting = Setting::all();
        $myVarsetting = new SettingsController($setting);
        //$myVaralter = new AlertController($setting);
        $language_id      =   'en';
        $checkRecord = DB::table('products_attributes')->where([
            'products_attributes_id' => $attribute_id,
            'product_id' => $product_id
        ])->delete();
        $products_attributes = DB::table('products_attributes')
            ->join('products_options', 'products_options.option_id', '=', 'products_attributes.option_id')
            ->leftJoin('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
            ->join('products_options_values', 'products_options_values.option_value_id', '=', 'products_attributes.option_value_id')
            ->leftJoin('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
            ->select('products_attributes.*', 'products_options_description.option_name', 'products_options_description.language_id', 'products_options_values_description.option_value_name')
            ->where('products_options_description.language_id', '=', $language_id)
            ->where('products_options_values_description.language_id', '=', $language_id)
            ->where('products_attributes.product_id', '=', $product_id)
            ->where('products_attributes.is_default', '=', '0')
            ->orderBy('products_attributes_id', 'DESC')
            ->get();
        $message = array('message' => 'Delete Succeeded','type' => 'success','products_attributes'=>$products_attributes);
        return $message;
        
  }
    
    public function defaultOption(Request $request){
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $checkRecord = DB::table('products_attributes')->where([
            'products_attributes_id'=> $request->products_attributes_id,
            'option_id' => $request->option_id,
            'product_id' => $request->product_id
        ])->get();
        if($checkRecord[0]->is_default =='Yes'){
            DB::table('products_attributes')->where(['products_attributes_id'=> $request->products_attributes_id,'option_id'=>$request->option_id,'product_id'=>$request->product_id])
            ->update([
            'is_default'=>'No'
            ]);
        }elseif($checkRecord[0]->is_default == 'No'){
             DB::table('products_attributes')->where(['option_id'=>$request->option_id,'product_id'=>$request->product_id])
            ->update([
            'is_default'=>'No'
            ]);
            DB::table('products_attributes')->where(['products_attributes_id'=> $request->products_attributes_id,'option_id'=>$request->option_id,'product_id'=>$request->product_id])
            ->update([
            'option_value_price' =>'0.00',
            'is_default'=>'Yes'
        ]);
        }
        $message = array('message' => 'Product Option Default status updated successfully','type' => 'success');
        return $message;
       
    }
//=====================Products images=====================

    public function images(Request $request){
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $product_id = $request->id;
        $images = DB::table('products_images')->where('product_id', '=', $product_id)->orderBy('sort_order', 'asc')->get();
        return view('admin.products.images.index',compact('images','product_id'));
    }
    
    public function createImage(Request $request){
        if (!Gate::allows('product.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $product_id = $request->id;
        return view('admin.products.images.create',compact('product_id'));
    }
    
    public function storeImage(Request $request){
        if (!Gate::allows('product.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
         $data = $this->validate($request, [
            'product_id'        =>'required|numeric',
            'image'             => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        $count = DB::table('products_images')->where('product_id',$request->product_id)->count();
        $data['sort_order'] = $count+1;
        $data['htmlcontent'] = $request->htmlcontent;
         if($request->hasfile('image')){
        $image = $request->file('image');
        $filename = time() . '-image.' . $image->getClientOriginalExtension();
        Image::make($image)->resize(600, 600)->save(public_path('/images/products_images/' . $filename));
        $data['image'] = '/images/products_images/'.$filename;
        }
        DB::table('products_images')->insert($data);
        $message = array('message' => 'Product images has been added successfully','type' => 'success');
        return redirect('admin/product/createImage/'.$request->product_id)->with($message);
       
    }
    
    public function editImage($id){
         if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $image = DB::table('products_images')->where('id','=', $id)->get();
        return view('admin.products.images.edit',compact('image'));
    }
    
    public function updateImage(Request $request){
       if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
         $data = $this->validate($request, [
            'id'        =>'required|numeric',
            'image'     => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        $data['htmlcontent'] = $request->htmlcontent;
        $path = DB::table('products_images')->where('id',$request->id)->select('image','product_id')->get();
        if($request->hasfile('image')){
            File::delete(public_path($path[0]->image));
            $image = $request->file('image');
            $filename = time() . '-image.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(600, 600)->save(public_path('/images/products_images/' . $filename));
            $data['image'] = '/images/products_images/'.$filename;
        }else{
            $data;
        }
        DB::table('products_images')->where('id',$request->id)->update($data);
        $message = array('message' => 'Product images has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);
    }
    
    public function destroyImage($id){
        if (!Gate::allows('product.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        $get = DB::table('products_images')->whereIn('id',$ids)->get();
        foreach($get as $g){
            File::delete(public_path($g->image));
        }
        DB::table('products_images')->whereIn('id', $ids)->delete();
        $message = array('message' => 'Delete Succeeded','type' => 'success');
        return $message;
    }
    
    public function statusImage(Request $request){
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $image = DB::table('products_images')->where('id',$request->id)->select('status')->get();
        if($image[0]->status =='Active'){
            DB::table('products_images')->where('id',$request->id)->update(['status' => 'InActive']);
        }elseif($image[0]->status =='InActive'){
            DB::table('products_images')->where('id',$request->id)->update(['status' => 'Active']);
        }
        $message = array('message' => 'Product Image Status has been updated successfully','type' => 'success');
        return $message;
       
    }
    
    //==================inventory===================
    public function inventory(Request $request){
       
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        
     $setting = DB::table('currencies')->get();
    // $myVarsetting = new SiteSettingController($setting);
    // $myVaralter = new AlertController($setting);
    $language_id      =   'en';
    $result = array();
    
    $message = array();
    $errorMessage = array();
    //$result['currency'] = $myVarsetting->getSetting();
    $product = DB::table('products')
                ->leftJoin('products_description', 'products_description.product_id', '=', 'products.id')
                ->LeftJoin('products_specials', function ($join) {
                    $join->on('products_specials.product_id', '=', 'products.id')->where('products_specials.status', '=', 'Active');

                })
                ->select('products.*', 'products_description.name', 'products_specials.special_id', 'products_specials.product_id as special_product_id', 'products_specials.special_new_product_price as special_product_price', 'products_specials.special_date_added', 'products_specials.special_last_modified', 'products_specials.expires_date')
                ->where('products_description.language_id', '=', $language_id);

    $product =  $product->get();
    $result['products'] = $product;
    $products = $product;
    $result['message'] = $message;
    $result['errorMessage'] = $errorMessage;
    $result2 = array();
    $index = 0;
    $stocks = 0;
    $min_level = 0;
    $max_level = 0;
    $purchase_price  = 0;
    if(count($product)>0){
        $product_id = $result['products'][0]->id;
    if($result['products'][0]->type!='Variable'){

      $currentStocks = DB::table('inventory')->where('product_id', $product_id)->get();
      $purchase_price = DB::table('inventory')->where('product_id', $product_id)->sum('purchase_price');

        if(count($currentStocks)>0){
            foreach($currentStocks as $currentStock){
                $stocks += $currentStock->stock;
            }
        }

          $manageLevel = DB::table('manage_min_max')->where('product_id', $product_id)->get();
        if(count($manageLevel)>0){
            $min_level = $manageLevel[0]->min_level;
            $max_level = $manageLevel[0]->max_level;
        }

    }

    $result['purchase_price'] = $purchase_price;
    $result['stocks'] = $stocks;
    $result['min_level'] = $min_level;
    $result['max_level'] = $max_level;
    $products_attribute = DB::table('products_attributes')->where('product_id', '=', $product_id)->get();
    $products_attribute = $products_attribute->unique('option_id')->keyBy('option_id');
    if(count($products_attribute)>0){
        $index2 = 0;
        foreach($products_attribute as $attribute_data){
          $option_name = DB::table('products_options')
              ->join('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
              ->select('products_options.option_id', 'products_options_description.option_name', 'products_options_description.language_id')
              ->where('products_options_description.language_id', $language_id)
              ->where('products_options.option_id', $attribute_data->option_id)
              ->get();
            if(count($option_name)>0){

                $temp = array();
                $temp_option['id'] = $attribute_data->option_id;
                $temp_option['name'] = $option_name[0]->option_name;
                $attr[$index2]['option'] = $temp_option;
                // fetch all attributes add join from products_options_values table for option value name
                $attributes_value_query = DB::table('products_attributes')
                ->where('product_id', '=', $product_id)
                ->where('option_id', '=', $attribute_data->option_id)
                ->get();
                foreach($attributes_value_query as $products_option_value){
                    $option_value = DB::table('products_options_values')
                    ->join('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
                    ->select('products_options_values.option_value_id', 'products_options_values_description.option_value_name')
                    ->where('products_options_values_description.language_id', '=', $language_id)
                    ->where('products_options_values.option_value_id', '=', $products_option_value->option_value_id)
                    ->get();
                    if(count($option_value)>0){
                        $attributes = DB::table('products_attributes')
                        ->where([['product_id', '=', $product_id], ['option_id', '=', $attribute_data->option_id], ['option_value_id', '=', $products_option_value->option_value_id]])
                        ->get();
                        $temp_i['products_attributes_id'] = $attributes[0]->products_attributes_id;
                        $temp_i['id'] = $products_option_value->option_value_id;
                        $temp_i['value'] = $option_value[0]->option_value_name;
                        $temp_i['price'] = $products_option_value->option_value_price;
                        $temp_i['price_prefix'] = $products_option_value->price_prefix;
                        array_push($temp,$temp_i);
                    }

                }

                $attr[$index2]['values'] = $temp;
                $result['attributes'] = 	$attr;
                $index2++;

            }
        }

    }else{
        $result['attributes'] = 	array();
    }

    }else{
        $result['attributes'] = 	array();
    }

      return view('admin.products.inventory',compact('result','setting'));
  }
  
    public function addInventory(Request $request){
        $data = $this->validate($request, [
            'product_id'        => 'required|numeric',
            'stock'             => 'required|numeric',
            'purchase_price'    => 'required|numeric'
        ]);
        $language_id     =   'en';
        $product = DB::table('products')
            ->leftJoin('products_description', 'products_description.product_id', '=', 'products.id')
            ->LeftJoin('products_specials', function ($join) {
                $join->on('products_specials.product_id', '=', 'products.id')->where('products_specials.status', '=', 'Active');
            })
            ->select('products.*', 'products_description.name',  'products_specials.special_id', 'products_specials.product_id as special_product_id', 'products_specials.special_new_product_price', 'products_specials.special_date_added', 'products_specials.special_last_modified', 'products_specials.expires_date')
            ->where('products_description.language_id', '=', $language_id);
            if ($data['product_id'] != null) {
                $product->where('products.id', '=', $data['product_id']);
            } else {
                $product->orderBy('products.id', 'DESC');
            }

        $product =  $product->get();
        $products = $product;
        $date_added	= date('Y-m-d h:i:s');
        $inventory_ref_id = DB::table('inventory')->insertGetId([
            'product_id' => $data['product_id'],
            'reference_code' => $request->reference_code,
            'stock' => $data['stock'],
            'admin_id' => auth()->user()->id,
            'created_at' => $date_added,
            'added_date' => strtotime(date('Y-m-d h:i:s')),
            'purchase_price' => $data['purchase_price'],
            'stock_type'  			=>   'in'
        ]);
        if($products[0]->type == 'Variable'){
            foreach($request->attributeid as $attribute){
                if(!empty($attribute)){
                  DB::table('inventory_detail')->insert([
                      'inventory_ref_id' => $inventory_ref_id,
                      'product_id' => $data['product_id'],
                      'attribute_id' => $attribute,
                  ]);
                }
            }
        }
    $message = array('message' => 'Product Stock has been added successfully','type' => 'success');
    return redirect()->back()->with('message');
    }
    
    public function ajax_attr($id){
        $setting = DB::table('currencies')->get();
        $language_id      =   'en';
        $products_id      =   $id;
        $result = array();
        $result['currency'] = $setting;
        $message = array();
        $errorMessage = array();
        $product = DB::table('products')
                    ->leftJoin('products_description', 'products_description.product_id', '=', 'products.id')
                    ->LeftJoin('products_specials', function ($join) {
                        $join->on('products_specials.product_id', '=', 'products.id')->where('products_specials.status', '=', 'Active');
                    })
                    ->select('products.*', 'products_description.name','products_description.description',  'products_specials.special_id', 'products_specials.product_id as special_product_id', 'products_specials.special_new_product_price', 'products_specials.special_date_added', 'products_specials.special_last_modified', 'products_specials.expires_date')
                    ->where('products_description.language_id', '=', $language_id);
                if ($products_id != null) {
                    $product->where('products.id', '=', $products_id);
                } else {
                    $product->orderBy('products.id', 'DESC');
                }
    
        $product =  $product->get();
        $result['products'] = $product;
        $products = $product;
        $result['message'] = $message;
        $result['errorMessage'] = $errorMessage;
        $result2 = array();
        $index = 0;
        $stocks = 0;
        $min_level = 0;
        $max_level = 0;
        $purchase_price  = 0;
        if($result['products'][0]->type!='Variable'){
    
          $stocksin = DB::table('inventory')->where('product_id', $result['products'][0]->id)->where('stock_type', 'in')->sum('stock');
          $stockOut = DB::table('inventory')->where('product_id', $result['products'][0]->id)->where('stock_type', 'out')->sum('stock');
          $stocks = $stocksin - $stockOut;
    
              $manageLevel = DB::table('manage_min_max')->where('product_id', $result['products'][0]->id)->get();
            if(count($manageLevel)>0){
                $min_level = $manageLevel[0]->min_level;
                $max_level = $manageLevel[0]->max_level;
            }
    
        }
        $result['purchase_price'] = $purchase_price;
        $result['stocks'] = $stocks;
        $result['min_level'] = $min_level;
        $result['max_level'] = $max_level;
        $products_attribute = DB::table('products_attributes')->where('product_id', '=', $products_id)->get();
        $products_attribute = $products_attribute->unique('option_id')->keyBy('option_id');
        if(count($products_attribute)>0){
            $index2 = 0;
            foreach($products_attribute as $attribute_data){
              $option_name = DB::table('products_options')
                  ->join('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
                  ->select('products_options.option_id', 'products_options_description.option_name', 'products_options_description.language_id')
                  ->where('products_options_description.language_id', $language_id)
                  ->where('products_options.option_id', $attribute_data->option_id)
                  ->get();
                if(count($option_name)>0){
    
                    $temp = array();
                    $temp_option['id'] = $attribute_data->option_id;
                    $temp_option['name'] = $option_name[0]->option_name;
                    $attr[$index2]['option'] = $temp_option;
                    // fetch all attributes add join from products_options_values table for option value name
                    $attributes_value_query = DB::table('products_attributes')
                    ->where('product_id', '=', $products_id)
                    ->where('option_id', '=', $attribute_data->option_id)
                    ->get();
                    foreach($attributes_value_query as $products_option_value){
                        $option_value = DB::table('products_options_values')
                        ->join('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
                        ->select('products_options_values.option_value_id', 'products_options_values_description.option_value_name')
                        ->where('products_options_values_description.language_id', '=', $language_id)
                        ->where('products_options_values.option_value_id', '=', $products_option_value->option_value_id)
                        ->get();
                        if(count($option_value)>0){
                            $attributes = DB::table('products_attributes')
                            ->where([['product_id', '=', $products_id], ['option_id', '=', $attribute_data->option_id], ['option_value_id', '=', $products_option_value->option_value_id]])
                            ->get();
                            $temp_i['products_attributes_id'] = $attributes[0]->products_attributes_id;
                            $temp_i['id'] = $products_option_value->option_value_id;
                            $temp_i['value'] = $option_value[0]->option_value_name;
                            $temp_i['price'] = $products_option_value->option_value_price;
                            $temp_i['price_prefix'] = $products_option_value->price_prefix;
                            array_push($temp,$temp_i);
                        }
    
                    }
                    $attr[$index2]['values'] = $temp;
                    $result['attributes'] = 	$attr;
                    $index2++;
                }
            }
        }else{
            $result['attributes'] = 	array();
        }
        return view("admin.products.attribute_div",compact('result'));
      }
      
    public function currentstock(Request $request){
    
        $inventory_ref_id = 0;
        $products_id = $request->product_id;
        $attributes = array_filter($request->attributeid);
        $attributeid = implode(',',$attributes);
        $postAttributes = count($attributes);
    
        $inventory = DB::table('inventory')->where('product_id', $products_id)->where('stock_type', 'in')->get();
        $reference_ids =array();
        $stockIn = 0;
        $purchasePrice = 0;
        foreach($inventory as $inventory){
            $totalAttribute = DB::table('inventory_detail')->where('inventory_detail.inventory_ref_id', '=', $inventory->inventory_ref_id)->get();
            $totalAttributes = count($totalAttribute);
    
            if($postAttributes>$totalAttributes){
                $count = $postAttributes;
            }elseif($postAttributes<$totalAttributes or $postAttributes==$totalAttributes){
                $count = $totalAttributes;
            }
    
            $individualStock = DB::table('inventory')->leftjoin('inventory_detail', 'inventory_detail.inventory_ref_id', '=', 'inventory.inventory_ref_id')
                ->selectRaw('inventory.*')
                ->whereIn('inventory_detail.attribute_id', [$attributeid])
                ->where(DB::raw('(select count(*) from `inventory_detail` where `inventory_detail`.`attribute_id` in (' . $attributeid . ') and `inventory_ref_id`= "' . $inventory->inventory_ref_id . '")'), '=', $count)
                ->where('inventory.inventory_ref_id', '=', $inventory->inventory_ref_id)
                ->get();
    
            if(count($individualStock) > 0 ){
    
                $inventory_ref_id = $individualStock[0]->inventory_ref_id;
                $stockIn += $individualStock[0]->stock;
                $purchasePrice += $individualStock[0]->purchase_price;
    
            }
        }
    
        $options_names  = array();
        $options_values = array();
        foreach($attributes as $attribute){
          $productsAttributes = DB::table('products_attributes')
              ->leftJoin('products_options', 'products_options.option_id', '=', 'products_attributes.option_id')
              ->leftJoin('products_options_values', 'products_options_values.option_value_id', '=', 'products_attributes.option_value_id')
              ->select('products_attributes.*', 'products_options.option_name', 'products_options_values.option_value_name')
              ->where('products_attributes_id', $attribute)->get();
            $options_names[] = $productsAttributes[0]->option_name;
            $options_values[] = $productsAttributes[0]->option_value_name;
        }
    
        $options_names_count = count($options_names);
        $options_names = implode ( "','", $options_names);
        $options_names = "'" . $options_names . "'";
        $options_values = "'" . implode ( "','", $options_values ) . "'";
        $orders_products = DB::table('orders_products')->where('product_id', $products_id)->get();
        $stockOut = 0;
        foreach($orders_products as $orders_product){
            $totalAttribute = DB::table('orders_products_attributes')->where('order_product_id', '=', $orders_product->orders_products_id)->get();
            $totalAttributes = count($totalAttribute);
            if($postAttributes>$totalAttributes){
                $count = $postAttributes;
            }elseif($postAttributes<$totalAttributes or $postAttributes==$totalAttributes){
                $count = $totalAttributes;
            }
            $products = DB::select("select orders_products.* from `orders_products` left join `orders_products_attributes` on `orders_products_attributes`.`order_product_id` = `orders_products`.`orders_products_id` where `orders_products`.`product_id`='".$products_id."' and `orders_products_attributes`.`product_option` in (".$options_names.") and `orders_products_attributes`.`product_option_value` in (".$options_values.") and (select count(*) from `orders_products_attributes` where `orders_products_attributes`.`product_id` = '".$products_id."' and `orders_products_attributes`.`product_option` in (".$options_names.") and `orders_products_attributes`.`product_option_value` in (".$options_values.") and `orders_products_attributes`.`order_product_id`= '".$orders_product->orders_products_id."') = ".$count." and `orders_products`.`orders_products_id` = '".$orders_product->orders_products_id."' group by `orders_products_attributes`.`order_product_id`");
            if(count($products)>0){
                $stockOut += $products[0]->product_quantity;
            }
        }
    
        $result = array();
        $result['purchasePrice'] = $purchasePrice;
        $result['remainingStock'] = $stockIn - $stockOut;
    
        if(!empty($inventory_ref_id)){
            $inventory_ref_id = $inventory_ref_id;
            $minMax = DB::table('manage_min_max')->where([['inventory_ref_id', $inventory_ref_id], ['product_id', $products_id]])->get();
    
        }else{
            $minMax = '';
        }
    
        $result['inventory_ref_id'] = $inventory_ref_id;
        $result['product_id'] = $products_id;
        $result['minMax'] = $minMax;
        return json_encode($result);
    }
    
    public function ajax_min_max($id){
        $setting = DB::table('currencies')->get();
        $language_id      =   'en';
        $products_id      =   $id;
        $result = array();
        $message = array();
        $errorMessage = array();
        $result['setting'] = $setting;
        $product = DB::table('products')
                    ->leftJoin('products_description', 'products_description.product_id', '=', 'products.id')
                    ->LeftJoin('products_specials', function ($join) {
                        $join->on('products_specials.product_id', '=', 'products.id')->where('products_specials.status', '=', 'Active');
                    })
                    ->select('products.*', 'products_description.name','products_description.description','products_specials.special_id', 'products_specials.product_id as special_product_id', 'products_specials.special_new_product_price', 'products_specials.special_date_added', 'products_specials.special_last_modified', 'products_specials.expires_date')
                    ->where('products_description.language_id', '=', $language_id);
                if ($products_id != null) {
                    $product->where('products.id', '=', $products_id);
                } else {
                    $product->orderBy('products.id', 'DESC');
                }
        $product =  $product->get();
        $result['products'] = $product;
        $products = $product;
        $result['message'] = $message;
        $result['errorMessage'] = $errorMessage;
        $result2 = array();
        $index = 0;
        $stocks = 0;
        $min_level = 0;
        $max_level = 0;
        $purchase_price = DB::table('inventory')->where('product_id', $result['products'][0]->id)->sum('purchase_price');
    
        if($result['products'][0]->type!='Variable'){
    
          $stocksin = DB::table('inventory')->where('product_id', $result['products'][0]->id)->where('stock_type', 'in')->sum('stock');
          $stockOut = DB::table('inventory')->where('product_id', $result['products'][0]->id)->where('stock_type', 'out')->sum('stock');
          $stocks = $stocksin - $stockOut;
    
            $manageLevel = DB::table('manage_min_max')->where('product_id', $result['products'][0]->id)->get();
            if(count($manageLevel)>0){
                $min_level = $manageLevel[0]->min_level;
                $max_level = $manageLevel[0]->max_level;
            }
    
        }
    
        $result['purchase_price'] = $purchase_price;
        $result['stocks'] = $stocks;
        $result['min_level'] = $min_level;
        $result['max_level'] = $max_level;
        $products_attribute = DB::table('products_attributes')->where('product_id', '=', $products_id)->get();
        $products_attribute = $products_attribute->unique('option_id')->keyBy('option_id');
        if(count($products_attribute)>0){
            $index2 = 0;
            foreach($products_attribute as $attribute_data){
              $option_name = DB::table('products_options')
                  ->join('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
                  ->select('products_options.option_id', 'products_options_description.option_name', 'products_options_description.language_id')
                  ->where('products_options_description.language_id', $language_id)
                  ->where('products_options.option_id', $attribute_data->option_id)
                  ->get();
                if(count($option_name)>0){
    
                    $temp = array();
                    $temp_option['id'] = $attribute_data->option_id;
                    $temp_option['name'] = $option_name[0]->option_name;
                    $attr[$index2]['option'] = $temp_option;
                    // fetch all attributes add join from products_options_values table for option value name
                    $attributes_value_query = DB::table('products_attributes')
                    ->where('product_id', '=', $products_id)
                    ->where('option_id', '=', $attribute_data->option_id)
                    ->get();
                    foreach($attributes_value_query as $products_option_value){
                        $option_value = DB::table('products_options_values')
                        ->join('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
                        ->select('products_options_values.option_value_id', 'products_options_values_description.option_value_name')
                        ->where('products_options_values_description.language_id', '=', $language_id)
                        ->where('products_options_values.option_value_id', '=', $products_option_value->option_value_id)
                        ->get();
                        if(count($option_value)>0){
                            $attributes = DB::table('products_attributes')
                            ->where([['product_id', '=', $products_id], ['option_id', '=', $attribute_data->option_id], ['option_value_id', '=', $products_option_value->option_value_id]])
                            ->get();
                            $temp_i['products_attributes_id'] = $attributes[0]->products_attributes_id;
                            $temp_i['id'] = $products_option_value->option_value_id;
                            $temp_i['value'] = $option_value[0]->option_value_name;
                            $temp_i['price'] = $products_option_value->option_value_price;
                            $temp_i['price_prefix'] = $products_option_value->price_prefix;
                            array_push($temp,$temp_i);
                        }
    
                    }
    
                    $attr[$index2]['values'] = $temp;
                    $result['attributes'] = 	$attr;
                    $index2++;
    
                }
            }
    
        }else{
    
            $result['attributes'] = 	array();
    
        }
          return $result;
      }
      
    public function addminmax($request){
        $data = $this->validate($request, [
            'product_id'        => 'required|numeric',
            'inventory_ref_id'  => 'required|numeric',
            'min_level'         => 'required|numeric',
            'max_level'         => 'required|numeric',
        ]);
    $products_id = $request->product_id;
    $language_id     =   'en';
    $product = DB::table('products')
                ->leftJoin('products_description', 'products_description.products_id', '=', 'products.id')
                ->LeftJoin('specials', function ($join) {
                    $join->on('products_specials.products_id', '=', 'products.products_id')->where('status', '=', '1');
                })
                ->select('products.*', 'products_description.name',  'products_specials.special_id', 'products_specials.product_id as special_product_id', 'products_specials.special_new_product_price', 'products_specials.special_date_added', 'products_specials.special_last_modified', 'products_specials.expires_date')
                ->where('products_description.language_id', '=', $language_id);
            if ($products_id != null) {
                $product->where('products.id', '=', $products_id);
            } else {
                $product->orderBy('products.id', 'DESC');
            }
            $product =  $product->get();

            $products = $product;
    if($products[0]->type=='Variable'){
        $inventory_ref_id = $request->inventory_ref_id;
    }else{
        $inventory_ref_id = 0;
    }
    $checkExist = DB::table('manage_min_max')
                    ->where('product_id', $products_id)
                    ->where('inventory_ref_id', $inventory_ref_id)
                    ->get();
    if(count($checkExist)==0){
      $manageMaxandMin = DB::table('manage_min_max')->insertGetId([
          'product_id' => $products_id,
          'min_level' => $request->min_level,
          'max_level' => $request->max_level,
          'inventory_ref_id' => $inventory_ref_id,
      ]);
    }else{
      $minandmax = DB::table('manage_min_max')->where('product_id', $products_id)->update([
          'min_level' => $request->min_level,
          'max_level' => $request->max_level,
          'inventory_ref_id' => $inventory_ref_id,
      ]);
    }
    $message = array('message' => 'Product Min Max Level has been added successfully','type' => 'success');
    return redirect()->back()->with('message');
  }
  
    
}
