<?php

namespace App\Http\Controllers\Admin;
use App\Models\Category;
use App\Models\Language;
use App\Models\Product;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Auth;
class ProductAttributesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!Gate::allows('attribute.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        

	    $attributes = DB::table('products_options')->get();		
		$result = array();		
		$index = 0;

		foreach($attributes as $attribute){	
			array_push($result, $attribute);
			$languages = Language::all();
			$result2 = array();
			$index2 = 0;
			foreach($languages as $language){
				array_push($result2, $language);
				$attributes = DB::table('products_options_description')
					->where('option_id','=',$attribute->option_id)
					->where('language_id','=',$language->code)
					->get();
				$result2[$index2]->attributes = $attributes;
				$values = DB::table('products_options_values')
					->join('products_options_values_description', 'products_options_values_description.option_value_id','=', 'products_options_values.option_value_id')
					->select('products_options_values_description.*')
					->where('language_id','=',$language->code)
					->where('products_options_values.option_id','=',$attribute->option_id)->get();
				$result2[$index2]->values =$values;	
				$index2++;	
			}	
			$result[$index]->data =$result2;
			$index++;
		}
        return view('admin.products.attributes.index',compact('result'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (!Gate::allows('attribute.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
        return view('admin.products.attributes.create',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!Gate::allows('attribute.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
    $languages = Language::all();
    foreach($languages as $language){
        $this->validate($request, [
            'name_'.$language->code => 'required|string|max:100|regex:/^[\pL\s\-]+$/u',
        ]);	
    }
        $i = 0;
        foreach($languages as $language){
            $name = 'name_'.$language->code;
            if($i==0){
            $id = DB::table('products_options')->insertGetId([
                    'option_name'          =>   $request->$name,
                ]);
            $i++;
            }
            DB::table('products_options_description')->insert([
					'option_name'   =>   $request->$name,
					'option_id'     =>   $id,
					'language_id'   =>   $language->code
				]);
        }
        $message = array('message' => 'Product Attribute has been added successfully','type' => 'success');
        return redirect()->back()->with($message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!Gate::allows('attribute.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
		$languages = Language::all();
		$option = $id;
		$description = array();		
		foreach($languages as $language){
			$options_description= DB::table('products_options_description')->where([
					['language_id', '=', $language->code],
					['option_id', '=', $id],
				])->get();
			if(count($options_description)>0){								
				$description[$language->code]['name'] = $options_description[0]->option_name;
				$description[$language->code]['language_name'] = $language->name;
				$description[$language->code]['language_id'] = $language->code;										
			}else{
				$description[$language->code]['name'] = '';
				$description[$language->code]['language_name'] = $language->name;
				$description[$language->code]['language_id'] = $language->code;	
			}
		}
        return view('admin.products.attributes.edit',compact('description','option'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('attribute.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
        foreach($languages as $language){
            $this->validate($request, [
                'name_'.$language->code => 'required|string|max:100|',
            ]);	
        }
		foreach($languages as $language){
			$name = 'name_'.$language->code;
			$checkExist = DB::table('products_options_description')->where('option_id','=',$id)->where('language_id','=',$language->code)->get();			
			if(count($checkExist)>0){
				DB::table('products_options_description')->where('option_id','=',$id)->where('language_id','=',$language->code)->update([
					'option_name'  	    =>   $request->$name,
					]);
			}else{
				DB::table('products_options_description')->insert([
					'option_name'  	    =>   $request->$name,
					'language_id'	    =>   $language->code,
					'option_id'			=>   $id,
					]);
			}
		}
	
        $message = array('message' => 'Product Option has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (!Gate::allows('attribute.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        DB::table('products_options')->whereIn('option_id',$ids)->delete();
        DB::table('products_options_description')->whereIn('option_id', $ids)->delete();
        $message = array('message' => 'Delete Succeeded','type' => 'success');
        return $message; 
    }

//=====================Products options Valus=====================
    public function values(Request $request){
        if (!Gate::allows('attribute.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $data = array();
        $value = DB::table('products_options_values')->where('option_id', $request->id)->get();
        $result = array();
        $index = 0;
        foreach($value as $values_data){
        array_push($result, $values_data);
            $result2 = array();
            $index2 = 0;
            $languages =  Language::all();
            foreach($languages as $language){
                array_push($result2, $language);
                $values = DB::table('products_options_values_description')
                    ->where('option_value_id', '=', $values_data->option_value_id)
                    ->where('language_id', '=', $language->code)->get();
                $result2[$index2]->values = $values;
                $index2++;
            }
            $result[$index]->data =$result2;
            $index++;
        }
        $data['languages'] =  Language::all();;
        $data['content'] = $result;
        $data['options'] = DB::table('products_options')
                          ->join('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
                          ->where('products_options.option_id', $request->id)->get();
        return view('admin.products.attributes.values.index',compact('data'));
    }
    
    
    public function storeValue(Request $request){
        if (!Gate::allows('attribute.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages =  Language::all();
        foreach($languages as $language){
            $this->validate($request, [
                'name_'.$language->code => 'required|string|max:100|',
            ]);	
        }
    
       $result = array();
        $languages =  Language::all();
        $i = 0;
        //multiple lanugauge with record
        foreach($languages as $language){
            $option_value_name = 'name_'.$language->code;
            if($i==0){
                $option_value_id = DB::table('products_options_values')->insertGetId([
                    'option_value_name'   => $request->$option_value_name,
                    'option_id'           => $request->option_id
                ]); 
            $i++;
            }
            DB::table('products_options_values_description')->insert([
                'option_value_name'   => $request->$option_value_name,
                'option_value_id'     => $option_value_id,
                'language_id'         => $language->code
          ]);
         }
        $message = array('message' => 'Attribute option vlaue has been added successfully','type' => 'success');
        return redirect()->back()->with($message);
       
    }
    
    public function editValue($id){
         if (!Gate::allows('attribute.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages =  Language::all();
        $edit = DB::table('products_options_values')->where('option_value_id', $id)->get();
        $description_data = array();
        foreach($languages as $language){
        $description = DB::table('products_options_values_description')->where([
            ['language_id', '=', $language->code],
            ['option_value_id', '=', $id],
        ])->get();
            if(count($description)>0){
              $description_data[$language->code]['name'] = $description[0]->option_value_name;
              $description_data[$language->code]['language_name'] = $language->name;
              $description_data[$language->code]['languages_id'] = $language->code;
            }else{
              $description_data[$language->code]['name'] = '';
              $description_data[$language->code]['language_name'] = $language->name;
              $description_data[$language->code]['languages_id'] = $language->code;
            }
        }
        $result['description'] = $description_data;
        $result['editoptions'] = $edit;
        return view('admin.products.attributes.values.edit',compact('result'));
    }
    
    public function updateValue(Request $request){
        if (!Gate::allows('attribute.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
         $option_value_id = $request->option_value_id;
        $languages =  Language::all();
        $languages = Language::all();
        foreach($languages as $language){
            $this->validate($request, [
                'name_'.$language->code => 'required|string|max:100|',
            ]);	
        }
        foreach($languages as $language){
          $option_value_name = 'name_'.$language->code;
          $checkExist = DB::table('products_options_values_description')->where('option_value_id', '=', $option_value_id)->where('language_id', '=', $language->code)->get();
          if(count($checkExist)>0){
              $req_option_value_name = $request->$option_value_name;
              DB::table('products_options_values_description')->where('option_value_id', '=', $option_value_id)->where('language_id', '=', $language->code)->update([
                  'option_value_name'   => $req_option_value_name,
              ]);
            }else{
                $req_option_value_name = $request->$option_value_name;
                DB::table('products_options_values_descriptions')->insert([
                    'option_value_name'  	=>   $req_option_value_name,
                    'language_id'			=>   $language->code,
                    'option_value_id'		=>   $option_value_id,
                ]);                  
            }
        }
        $message = array('message' => 'Product Option Value has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);
    }
    
    public function destroyValue($id){
        if (!Gate::allows('attribute.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        DB::table('products_options_values')->whereIn('option_value_id',$ids)->delete();
        DB::table('products_options_values_description')->whereIn('option_value_id',$ids)->delete();
        $message = array('message' => 'Delete Succeeded','type' => 'success');
        return $message;
    }
    
}
