<?php

namespace App\Http\Controllers\Admin;
use App\User;
use App\Models\Role;
use App\Models\Permission;
use DB;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PermissionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
         if (!Gate::allows('permission.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $search = request()->search;
        if(request()->search){
            $permissions = Permission::where('name', request()->search)
            ->orWhere('slug', 'like', '%' . request()->search. '%')
            ->orWhere('created_at', 'like', '%' . request()->search. '%')
            ->orWhere('updated_at', 'like', '%' . request()->search. '%')
            ->paginate(10);
        }else{
            $permissions = Permission::paginate(10);
        }
        return view('admin.permissions.index',compact('permissions','search'));
        
    }
     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(){
        if (!Gate::allows('permission.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        } 
        return view('admin.permissions.create');  
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        if (!Gate::allows('permission.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        } 
        $data = $this->validate($request, [
            'name' => 'required|string|max:50|unique:permissions',
            'slug' => 'required|string|max:50|unique:permissions',
          ]);
          if(Permission::create($data)){
            $message = array('message' => 'Permission has been added successfully !','type' => 'success');
            return redirect()->back()->with($message); 
          }else{
            $message = array('message' => 'Some thing went wrong try agian !','type' => 'warning');
            return redirect()->back()->with($message); 
          }
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id){
        if (!Gate::allows('permission.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $permission = Permission::find($id);
        return view('admin.permissions.edit',compact('permission'));
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('permission.edit') && !Gate::allows('all')) {
        
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $data = $this->validate($request, [
            'name' => 'required|string|max:50|unique:permissions,name,'.$id,
            'slug' => 'required|string|max:50|unique:permissions,slug,'.$id,
          ]);
          $data['updated_at']=date('Y-m-d H:i:s');
        Permission::find($id)->update($data);
        $message = array('message' => 'Permission has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);
        
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id){
       if (!Gate::allows('permission.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $ids = explode(',', $id);
        Permission::whereIn('id',$ids)->delete();
        DB::table('role_permissions')->whereIn('permission_id',$ids)->delete();
        $message = array('message' => 'Delete Successed','type' => 'success');
        return $message;
        
    }
}
