<?php

namespace App\Http\Controllers\Admin;
use App\Models\Payment;
use App\Models\Language;
use App\Models\Permission;
use DB;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PaymentsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
         if (!Gate::allows('payment.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $payments = Payment::Leftjoin('payment_description','payment_description.payment_method_id','=','payment_methods.id')
        ->select('payment_methods.*','payment_description.name')->where('payment_description.language_id','en')->get();
        return view('admin.payments.index',compact('payments'));
        
    }
     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(){
        if (!Gate::allows('payment.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        } 
        return view('admin.payments.create');  
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        if (!Gate::allows('payment.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        } 
        $payment = Payment::find($request->id);
        if($payment->status =='Active'){
            $payment->update(['status' => 'InActive']);	
        }elseif($payment->status =='InActive'){
            $payment->update(['status' => 'Active']);	
        }
        $message = array('message' => 'Payment Status has been updated successfully','type' => 'success');
        return $message;
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id){
        if (!Gate::allows('payment.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $payment = Payment::find($id);
      $languages = Language::all();
      
      $description_data = array();
      foreach($languages as $language){

          $description = DB::table('payment_description')->where([
              ['language_id', '=', $language->code],
              ['payment_method_id', '=', $id],
          ])->get();

          if(count($description)>0){
              $description_data[$language->code]['name'] = $description[0]->name;
              $description_data[$language->code]['language_name'] = $language->name;
              $description_data[$language->code]['language_id'] = $language->code;	
          }else{
              $description_data[$language->code]['name'] = '';
              $description_data[$language->code]['language_name'] = $language->name;
              $description_data[$language->code]['language_id'] = $language->code;	
          }

      }

        $method_detail = $description_data;
        return view('admin.payments.edit',compact('payment','method_detail'));
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('payment.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $languages = Language::all();
		foreach($languages as $language){
			$name = 'name_'.$language->code;
			$checkExist = DB::table('payment_description')->where('payment_method_id','=',$id)->where('language_id','=',$language->code)->get();			
			if(count($checkExist)>0){
				DB::table('payment_description')->where('payment_method_id','=',$id)->where('language_id','=',$language->code)->update([
					'name'  	    		 =>   $request->$name,
					]);
			}else{
				DB::table('payment_description')->insert([
					'name'  	             =>   $request->$name,
					'language_id'			 =>   $language->code,
					]);
			}
		}
       
        $message = array('message' => 'Payment method has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);
        
    }
  
    // public function destroy($id){
    //   if (!Gate::allows('payment.destroy') && !Gate::allows('all')) {
    //         $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
    //         return redirect()->back()->with($message);
    //     }
        
    // }
}
