<?php
namespace App\Http\Controllers\Admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\Language;
use DB;
use Illuminate\Support\Facades\Gate;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;
class LanguageController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
        if (!Gate::allows('language.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
        return view('admin.languages.index',compact('languages'));
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(){
        if (!Gate::allows('language.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        return view('admin.languages.create');
        
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        if (!Gate::allows('language.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
       $data = $this->validate($request, [
            'name' => 'required|string|max:50|unique:languages',
            'code' => 'required|string|max:4|unique:languages',
            'direction' => 'in:rtl,ltr',
            'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        
        if($request->hasfile('image')){
            $image = $request->file('image');
            $filename = time() . '.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(30, 20)->save(public_path('/images/language_flags/' . $filename));
            $data['image'] = '/images/language_flags/'.$filename;
        }else{
            $data;
            }
            Language::create($data);  
        $message = array('message' => 'Language has been added successfully','type' => 'success');
        return redirect()->back()->with($message);
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    public function edit($id){
         if (!Gate::allows('language.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $language = Language::find($id);
        return view('admin.languages.edit',compact('language'));
        
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id){
      if (!Gate::allows('language.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $get = Language::find($id);
        $data =$this->validate($request,[
            'name' => 'required|string|max:50|unique:languages,name,'.$id,
            'code' => 'required|string|max:4|unique:languages,code,'.$id,
            'direction' => 'in:rtl,ltr',
            'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
          ]);
          $data['updated_at']=date('Y-m-d H:i:s');
          if($request->hasfile('image')){
            File::delete(public_path($get->image));
            $image = $request->file('image');
            $filename = time() . '.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(30, 20)->save(public_path('/images/language_flags/' . $filename));
            $data['image'] = '/images/language_flags/'.$filename;
        }else{
            $data;
        } 
        Language::find($id)->update($data);
        $message = array('message' => 'Language has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);  
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id){
      if (!Gate::allows('language.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        $ids = array_diff($ids, ["1"]);

        $get = Language::whereIn('id',$ids)->get();
        foreach($get as $g){
            File::delete(base_path($g->image));
        }
        if (Language::whereIn('id',$ids)->delete()) {
            $message = array('message' => 'Delete Succeeded','type' => 'success');
        } else {
            $message = array('message' => 'Delete Failed','type' => 'error');
        }
        return $message;
    }

    public function defaultLanguage(Request $request){
        if (!Gate::allows('language.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        Language::where('isdefault','=', '1')->update([				
			'isdefault'	=>	'0'
			]);		
        Language::where('id','=', $request->id)->update([
				'isdefault'	=>	'1'
                ]);	
        $message = array('message' => 'Language has been updated successfully','type' => 'success');
        return $message;
    }

    public function languageStatus(Request $request){
        if (!Gate::allows('language.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this action !','type' => 'error');
            return $message;
        }
        Language::where('status', 'Active')->update(['status' => 'InActive']);		
        Language::find($request->id)->update(['status' => 'Active']);	
        $message = array('message' => 'Language Status has been updated successfully','type' => 'success');
        return $message;
    }
    
    
}