<?php

namespace App\Http\Controllers\Admin;
use App\Models\Customer;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Hash;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
class CustomerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!Gate::allows('customer.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $customers = Customer::all();
        return view('admin.customers.index',compact('customers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (!Gate::allows('customer.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
   
    return view('admin.customers.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!Gate::allows('customer.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
            }
            $data = $this->validate($request, [
                'first_name'=>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
                'last_name' =>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
                'email'     =>  'required|string|email|max:50|unique:customers',
                'password'  =>  'required|string|min:6|confirmed',
                'gender'    =>  'in:Male,Female',
                'dob'       =>  'date|date_format:Y-m-d',
                'image'     =>  'mimes:jpeg,png,jpg,gif,svg|max:2048',
                'phone'     =>  'string|max:15|unique:customers'
              ]);
              $data['phone'] =$request->phone;
            if($request->hasfile('image')){
                $image = $request->file('image');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                Image::make($image)->resize(100, 100)->save(public_path('/images/customer_images/' . $filename));
                $data['image'] = '/images/customer_images/'.$filename;
            }else{
                $oldPath = public_path('/images/default_images/default_customer.png');
                $fileExtension = \File::extension($oldPath);
                $newName = time().'.'.$fileExtension;
                $newPathWithName =public_path('/images/customer_images/' .$newName);
                File::copy($oldPath , $newPathWithName);
                $data['image'] = '/images/customer_images/'.$newName;
            } 
            $data['password'] = Hash::make($request->password);
            $customer = Customer::create($data);
            $message = array('message' => 'Customer user has been added successfully !','type' => 'success');
            return redirect()->back()->with($message);
          
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!Gate::allows('customer.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $customer = Customer::find($id);
        return view('admin.customers.edit',compact('customer'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('cusotmer.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
            }
            $user = Customer::find($id);
            $data = $this->validate($request, [
                'first_name'=>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
                'last_name' =>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
                'email'     => 'required|string|email|max:50|unique:customers,email,'.$id,
                'gender'    => 'in:Male,Female',
                'dob'       => 'date|date_format:Y-m-d',
                'image'     => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
                'phone'     => 'string|max:15|unique:customers,phone,'.$id
              ]);
              $data['phone'] = $request->phone;
              $data['updated_at']=date('Y-m-d H:i:s');
            if($request->hasfile('image')){
                File::delete(public_path($user->image));
                $image = $request->file('image');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                Image::make($image)->resize(100, 100)->save(public_path('/images/customer_images/' . $filename));
                $data['image'] = '/images/customer_images/'.$filename;
            }else{
                $data;
                } 
                Customer::find($id)->update($data);
                if($request->change_password=="yes"){
                    $this->validate($request, [
                        'password' => 'required|string|min:6|confirmed', 
                      ]);
                      Customer::find($id)->update([
                        'password' => Hash::make($request->password),
                    ]);
                }
            $message = array('message' => 'Customer has been updated successfully','type' => 'success');
            return redirect()->back()->with($message);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (!Gate::allows('customer.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
            }
            $ids = explode(',', $id);
            $ids = array_diff($ids, ["1"]);
            $get = Customer::whereIn('id',$ids)->get();
            foreach($get as $g){
                File::delete(public_path($g->image));
            }
           Customer::destroy(array_filter($ids));
           return $message = array('message' => 'Delete Succeeded','type' => 'success');   
    }
    public function CustomerStatus(Request $request){
        if (!Gate::allows('customer.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this action !','type' => 'error');
            return $message;
        }
        $customer =Customer::find($request->id);
        if($customer->status =='Active'){
            $customer->update(['status' => 'InActive']);	
        }elseif($customer->status =='InActive'){
            $customer->update(['status' => 'Active']);	
        }
        $message = array('message' => 'Customer Status has been updated successfully','type' => 'success');
        return $message;
       
    }
    public function customerProfile(Request $request){
        if (!Gate::allows('customer.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this action !','type' => 'error');
            return $message;
        }
        $customer = Customer::find($request->id);
        return view('admin.customers.profiles',compact('customer'));
    }
    
}
