@extends('admin.layout')
@section('content')
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1> {{ trans('labels.EditCustomers') }} <small>{{ trans('labels.EditCustomers') }}...</small> </h1>
    <ol class="breadcrumb">
      <li><a href="{{ URL::to('admin/dashboard/this_month')}}"><i class="fa fa-dashboard"></i> {{ trans('labels.breadcrumb_dashboard') }}</a></li>
      <li><a href="listingCustomers"><i class="fa fa-users"></i> {{ trans('labels.ListingAllCustomers') }}</a></li>
      <li class="active">{{ trans('labels.EditCustomers') }}</li>
    </ol>
  </section>
  
  <!-- Main content -->
  <section class="content"> 
    <!-- Info boxes --> 
    
    <!-- /.row -->

    <div class="row">
      <div class="col-md-12">
        <div class="box">
          <div class="box-header">
            <h3 class="box-title">{{ trans('labels.EditCustomers') }} </h3>
          </div>
          
          <!-- /.box-header -->
          <div class="box-body">
            <div class="row">
              <div class="col-xs-12">
              		<div class="box box-info">
                        <!--<div class="box-header with-border">
                          <h3 class="box-title">Edit category</h3>
                        </div>-->
                        <!-- /.box-header -->
                        <br>                       
                       	@if(count($instalation['message'])>0)						
						<div class="alert alert-success alert-dismissible" role="alert">
						  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						 {{ $instalation['message'] }}
						</div>						
						@endif
                        
                       @if(count($instalation['errorMessage'])>0)						
						<div class="alert alert-danger" role="alert">
						  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						 {{ $instalation['errorMessage'] }}
						</div>						
						@endif
                        
                        <!-- form start -->                        
                         <div class="box-body">
                         
                            {!! Form::open(array('url' =>'admin/updateInstalation', 'method'=>'post', 'class' => 'form-horizontal form-validate', 'enctype'=>'multipart/form-data')) !!}
                            	{!! Form::hidden('id',  $instalation['instalation'][0]->id, array('class'=>'form-control', 'id'=>'customers_id')) !!}
                            	
                            	<div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.CustomerName') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    <select class="form-control field-validate select2" name="customers_id">
                                        @if(count($instalation['customers'])>0)
                                            @foreach ($instalation['customers'] as $customer)
                                            <option @if( $customer->customers_id == $instalation['instalation'][0]->customers_id ) selected @endif value="{{ $customer->customers_id }}">{{ $customer->customers_firstname}}&nbsp;{{ $customer->customers_lastname}}&nbsp;&nbsp;{{ $customer->customers_telephone}}&nbsp;&nbsp; {{ $customer->customers_email_address }}</option>
                                        @endforeach
                                        @endif
                                        
                                    </select>
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.FirstNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                
                              <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Elevater Code') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('elevator_code',$instalation['instalation'][0]->elevator_code, array('class'=>'form-control field-validate', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                              
                                
                                 <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Address') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                      {!! Form::text('address',  $instalation['instalation'][0]->address, array('class'=>'form-control field-validate', 'id'=>'pac-input','autocomplete'=>'rutjfkde')) !!}
                                      
                                      <input name="lat" id="latitude" class=" form-control" autocomplete="rutjfkde" value="{{$instalation['instalation'][0]->lat}}" type="hidden" >
                                      <input name="lng" id="longitude" class=" form-control" autocomplete="rutjfkde" value="{{$instalation['instalation'][0]->lng}}" type="hidden" >
                                     
                                     
                                    <div id="map" ></div>
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Floor No') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('floor_no',  $instalation['instalation'][0]->floor_no, array('class'=>'form-control field-validate ', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Doors') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('door_no',  $instalation['instalation'][0]->door_no, array('class'=>'form-control field-validate ', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.QA00') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('qa',  $instalation['instalation'][0]->qa, array('class'=>'form-control field-validate ', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Elevater Type') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('elevator_type', $instalation['instalation'][0]->elevator_type, array('class'=>'form-control field-validate', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                               <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Installation Date') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('installation_date',  $instalation['instalation'][0]->installation_date, array('class'=>'form-control field-validate datepicker','readonly', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Expiry Date') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('expiry_date',  $instalation['instalation'][0]->expiry_date, array('class'=>'form-control field-validate datepicker','readonly', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                               <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Maintenance Frequency') }} </label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::text('maintenance_frequency',  $instalation['instalation'][0]->maintenance_frequency, array('class'=>'form-control field-validate', 'id'=>'customers_lastname')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.lastNameText') }}</span>
                                    <span class="help-block hidden">{{ trans('labels.textRequiredFieldMessage') }}</span>
                                  </div>
                                </div>
                                 <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Image') }}</label>
                                  <div class="col-sm-10 col-md-4">
                                    {!! Form::file('newImage', array('id'=>'image')) !!}
                                    <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">
                                    {{ trans('labels.UploadProductImageText') }}</span>
                                    
                                    {!! Form::hidden('oldImage',  $instalation['instalation'][0]->image , array('id'=>'oldImage', )) !!}
                                    <img src="{{asset('').$instalation['instalation'][0]->image}}" alt="" width=" 100px">
                                  </div>
                                </div>
                                <div class="form-group">
                                  <label for="name" class="col-sm-2 col-md-3 control-label">{{ trans('labels.Status') }}
                                   </label>
                                  <div class="col-sm-10 col-md-4">
                                    <select class="form-control" name="status">
                                          <option
                                              @if($instalation['instalation'][0]->status == 1)
                                                selected
                                              @endif
                                           value="1">Contract Created</option>
                                          <option 
                                           @if($instalation['instalation'][0]->status == 0)
                                                selected
                                              @endif
                                           value="0">{{ trans('labels.Inactive') }}</option>
                                           
                                           
                                           <option 
                                           @if($instalation['instalation'][0]->status == 4)
                                                selected
                                              @endif
                                           value="4">Mechanical</option>
                                           
                                           
                                           <option 
                                           @if($instalation['instalation'][0]->status == 5)
                                                selected
                                              @endif
                                           value="5">Electrical</option>
                                           
                                           
                                           <option 
                                           @if($instalation['instalation'][0]->status == 2)
                                                selected
                                              @endif
                                           value="2">In Maintanance</option>
									</select><span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">{{ trans('labels.StatusText') }}</span>
                                 
                                  </div>
                                </div>
                                
                              <!-- /.box-body -->
                              <div class="box-footer text-center">
                                <button type="submit" class="btn btn-primary">{{ trans('labels.Update') }} </button>
                                <a href="../listingInstalations" type="button" class="btn btn-default">{{ trans('labels.back') }}</a>
                              </div>
                              <!-- /.box-footer -->
                            {!! Form::close() !!}
                        </div>
                  </div>
              </div>
            </div>
            
          </div>
          <!-- /.box-body --> 
        </div>
        <!-- /.box --> 
      </div>
      <!-- /.col --> 
    </div>
    <!-- /.row --> 
    
    <!-- Main row --> 
    
    <!-- /.row --> 
  </section>
  <!-- /.content --> 
</div>
@endsection 