<?php
/*
Project Name: Laundry Project

Author: Omkar Khalipe

Version: 2.9.2
*/
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;

//validator is builtin class in laravel
use Validator;

use App;
use Lang;

use DB;
//for password encryption or hash protected
use Hash;
use App\Administrator;

//for authenitcate login data
use Auth;

//use Illuminate\Foundation\Auth\ThrottlesLogins;
//use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;

//for requesting a value 
use Illuminate\Http\Request;
//use Illuminate\Routing\Controller;


class AdminVendorController extends Controller
{
	
	//listingTaxClass
	public function listingVendors(Request $request){
		$title = array('pageTitle' => Lang::get("labels.ListingVendors"));		
		
		$result = array();
		$message = array();
			
		$banners = DB::table('technician')->paginate(20);
		
		$result['message'] = $message;
		$result['banners'] = $banners;
		
		return view("admin.listingVendor", $title)->with('result', $result);
	}
	
	public function listingVendorHistory($id){
		$title = array('pageTitle' => Lang::get("labels.ListingVendors"));		
		
		$result = array();
		$message = array();
			
		$banners = DB::table('site_visits')
		->leftJoin("instalations","instalations.id","site_visits.installation_id")
		->leftJoin("customers","customers.customers_id","instalations.customers_id")
		->where("site_visits.tecnician_id",$id)
		->select("customers.*","instalations.*","site_visits.*")
		->paginate(20);
		
		$result['message'] = $message;
		$result['banners'] = $banners;
		
		return view("admin.listingVendorHistory", $title)->with('result', $result);
	}
	
	public function listingQuestion(){
		$title = array('pageTitle' => Lang::get("labels.ListingVendors"));		
		
		$result = array();
		$message = array();
			
		$banners = DB::table('questions')->paginate(20);
		
		$result['message'] = $message;
		$result['banners'] = $banners;
		
		return view("admin.listingQuestions", $title)->with('result', $result);
	}
	
	public function addQuestion()
	{
	    		$title = array('pageTitle' => Lang::get("labels.ListingVendors"));		

	    return view("admin.addQuestion",$title);
	}
	
	public function addNewQuestion(Request $request)
	{
	    DB::table("questions")->insert([
	        'name'=>$request->Name,
	        'type'=>$request->type
	        ]);
	        		
		$message ="Question added";
		return redirect("admin/listingQuestion")->withErrors([$message]);
	}
	

	//addTaxClass
	
	public function addvendors(Request $request){
		$title = array('pageTitle' => Lang::get("labels.AddVendor"));
		
		$result = array();
		$message = array();
		
		//get function from other controller
		$myVar = new AdminCategoriesController();
		$categories = $myVar->getSubCategories(1);
		
		//get function from other controller
		$myVar = new AdminProductsController();
		$products = $myVar->getProducts(1);
		//print_r($products);
		$result['message'] = $message;
		$result['categories'] = $categories;
		$result['products'] = $products;
		
		return view("admin.addvendors", $title)->with('result', $result);
	}
	
	
	//Addnewvendor
	
		public function addnewvendor(Request $request){
			$created_at	= date('y-m-d h:i:s');
		 	//$auth = Auth::guard('admin');
		
		
		
	if($request->hasFile('image')){
			$image = $request->image;
			$fileName = time().'.'.$image->getClientOriginalName();
			$image->move('resources/assets/images/vendor_images/', $fileName);
			$uploadImage = 'resources/assets/images/vendor_images/'.$fileName; 
		}else{
			$uploadImage = '';
		}	
		
		
		DB::table('technician')->insert([
				'first_name'            =>$request->first_name,
				'arabic_name'           =>$request->arabic_name,
				'type'                 =>$request->type,
				'password'              =>Hash::make($request->password),
				'status'                =>$request->status,
				'address'               =>$request->address,
				'phone'                 =>$request->phone,
			    'image'			        =>$uploadImage,
		        'created_at'            =>$created_at,
		        
				]);
										
		$message = Lang::get("labels.VendorAddedMessage");
		return redirect()->back()->withErrors([$message]);
	}
	
	
	
		public function editvendor(Request $request){		
		$title = array('pageTitle' => Lang::get("labels.EditVendor"));
		$result = array();		
		$result['message'] = array();
		
		$banners = DB::table('technician')->where('myid', $request->id)->get();
		$result['vendor'] = $banners;	
		
	
		
		return view("admin.editvendor",$title)->with('result', $result);
	}
	//editTaxClass
	public function updatevendorpassword(Request $request){
	
		$title = array('pageTitle' => Lang::get("labels.EditVendor"));
		
		$message = Lang::get("labels.BannerUpdatedMessage");
				
		$countryUpdate = DB::table('technician')->where('myid', $request->id)->update([
				'password'              =>Hash::make($request->password),
					]);
				
		return redirect()->back()->withErrors([$message ]);
	}
	
	//updateTaxClass
	public function updatevendor(Request $request){
		$updated_at	= date('y-m-d h:i:s');
	
		$title = array('pageTitle' => Lang::get("labels.EditVendor"));
		
		$expiryDate = str_replace('/', '-', $request->expires_date);
		$expiryDateFormate = date('Y-m-d H:i:s', strtotime($expiryDate));
		$type = $request->type;
		
		if($request->hasFile('image')){
			$image = $request->image;
			$fileName = time().'.'.$image->getClientOriginalName();
			$image->move('resources/assets/images/vendor_images/', $fileName);
			$uploadImage = 'resources/assets/images/vendor_images/'.$fileName; 
		}else{
			$uploadImage = $request->image;
		}
		
		
			
		$message = Lang::get("labels.BannerUpdatedMessage");
				
		$countryUpdate = DB::table('technician')->where('myid', $request->id)->update([
				'first_name'            =>$request->first_name,
				'arabic_name'           =>$request->arabic_name,
				'type'                  =>$request->type,
				'password'              =>Hash::make($request->password),
				'status'                =>$request->status,
				'address'               =>$request->address,
				'phone'                 =>$request->phone,
			    'image'			        =>$uploadImage,
		        'updated_at'            =>$updated_at,
					]);
				
		return redirect()->back()->withErrors([$message ]);
	}
	
	//deleteCountry
	public function deletevendor(Request $request){
		DB::table('technician')->where('myid', $request->banners_id)->delete();
		return redirect()->back()->withErrors([Lang::get("labels.VendorDeletedMessage")]);
	}
}
